/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.nameservice.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.silvertunnel_ng.netlib.nameservice.cache.CacheEntry;

public class Cache<K, V>
implements Map<K, V> {
    private final Map<K, CacheEntry<K, V>> storage;
    private final int timeToLiveSeconds;
    private final int maxElements;
    private static final int MIN_MAX_ELEMENTS = 1;

    public Cache(int maxElements, int timeToLiveSeconds) {
        this.timeToLiveSeconds = timeToLiveSeconds < 0 ? Integer.MAX_VALUE : timeToLiveSeconds;
        if (maxElements < 1) {
            throw new IllegalArgumentException("invalid maxElements=" + maxElements);
        }
        this.maxElements = maxElements;
        this.storage = new HashMap<K, CacheEntry<K, V>>(maxElements);
    }

    @Override
    public synchronized void clear() {
        this.storage.clear();
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        V v = this.get(key);
        return v != null;
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public synchronized Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> entries = new HashSet<Map.Entry<K, V>>(this.storage.size());
        for (K key : this.storage.keySet()) {
            CacheEntry<K, V> cacheValue = this.storage.get(key);
            if (cacheValue == null) continue;
            entries.add(cacheValue);
        }
        return entries;
    }

    @Override
    public synchronized V get(Object key) {
        if (this.timeToLiveSeconds == 0) {
            return null;
        }
        CacheEntry<K, V> value = this.storage.get(key);
        if (value == null) {
            return null;
        }
        if (value.isExpired()) {
            this.storage.remove(key);
            return null;
        }
        return value.getValue();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.storage.isEmpty();
    }

    @Override
    public synchronized Set<K> keySet() {
        return this.storage.keySet();
    }

    @Override
    public synchronized V put(K key, V value) {
        if (this.timeToLiveSeconds == 0) {
            return null;
        }
        this.ensureThatAtLeastOneMoreEntryCanBePutted();
        CacheEntry<K, V> valueNew = new CacheEntry<K, V>(key, value, this.timeToLiveSeconds);
        CacheEntry<K, V> valueOld = this.storage.put(key, valueNew);
        return valueOld == null ? null : (V)valueOld.getValue();
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public synchronized V remove(Object key) {
        CacheEntry<K, V> v = this.storage.remove(key);
        return v == null ? null : (V)v.getValue();
    }

    @Override
    public synchronized int size() {
        this.removeExpiredEntries();
        return this.storage.size();
    }

    @Override
    public synchronized Collection<V> values() {
        ArrayList<V> values = new ArrayList<V>(this.storage.size());
        for (K key : this.storage.keySet()) {
            CacheEntry<K, V> value = this.storage.get(key);
            if (value == null) continue;
            values.add(value.getValue());
        }
        return values;
    }

    public String toString() {
        return "Cache(" + this.storage + ")";
    }

    private synchronized void ensureThatAtLeastOneMoreEntryCanBePutted() {
        if (this.storage.size() < this.maxElements) {
            return;
        }
        K remainingKey = this.removeExpiredEntries();
        if (this.storage.size() > this.maxElements - 1) {
            if (remainingKey != null) {
                this.storage.remove(remainingKey);
            } else {
                throw new IllegalStateException("no remainingKey found, but storage is not empty: " + this.storage);
            }
        }
    }

    private synchronized K removeExpiredEntries() {
        K remainingKey = null;
        ArrayList<K> keysToRemove = new ArrayList<K>(this.storage.size());
        for (Map.Entry<K, CacheEntry<K, V>> entry : this.storage.entrySet()) {
            if (entry.getValue().isExpired()) {
                keysToRemove.add(entry.getKey());
                continue;
            }
            remainingKey = entry.getKey();
        }
        for (Map.Entry<K, CacheEntry<K, V>> keyToRemove : keysToRemove) {
            this.storage.remove(keyToRemove);
        }
        return remainingKey;
    }
}

