/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tor.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Util {
    private static final Logger LOG = LoggerFactory.getLogger(Util.class);
    public static final String MYNAME = "silvertunnel-ng-org-Netlib";
    public static final String UTF8 = "UTF-8";
    private static final String UTC_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static DateFormat utcTimestampDateFormat;

    private static synchronized void initUtcTimestampIfNeeded() {
        if (utcTimestampDateFormat == null) {
            utcTimestampDateFormat = new SimpleDateFormat(UTC_TIMESTAMP_FORMAT);
            utcTimestampDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseUtcTimestamp(String timestampStr) {
        try {
            Class<Util> clazz = Util.class;
            synchronized (Util.class) {
                Util.initUtcTimestampIfNeeded();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return utcTimestampDateFormat.parse(timestampStr);
            }
        }
        catch (Exception e) {
            LOG.debug("Exception while parsing timestampStr={}", (Object)timestampStr, (Object)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long parseUtcTimestampAsLong(String timestampStr) {
        try {
            Class<Util> clazz = Util.class;
            synchronized (Util.class) {
                Util.initUtcTimestampIfNeeded();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return utcTimestampDateFormat.parse(timestampStr).getTime();
            }
        }
        catch (Exception e) {
            LOG.debug("Exception while parsing timestampStr={}", (Object)timestampStr, (Object)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatUtcTimestamp(Date timestamp) {
        try {
            Class<Util> clazz = Util.class;
            synchronized (Util.class) {
                Util.initUtcTimestampIfNeeded();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return utcTimestampDateFormat.format(timestamp);
            }
        }
        catch (Exception e) {
            LOG.debug("Exception while formatting timestamp={}", (Object)timestamp, (Object)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatUtcTimestamp(Long timestamp) {
        try {
            Class<Util> clazz = Util.class;
            synchronized (Util.class) {
                Util.initUtcTimestampIfNeeded();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return utcTimestampDateFormat.format(timestamp);
            }
        }
        catch (Exception e) {
            LOG.debug("Exception while formatting timestamp={}", (Object)timestamp, (Object)e);
            return null;
        }
    }
}

