/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tor.util;

import java.math.BigInteger;
import java.net.Socket;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.net.ssl.X509KeyManager;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrivateKeyHandler
implements X509KeyManager {
    private static final Logger LOG = LoggerFactory.getLogger(PrivateKeyHandler.class);
    private KeyPair keypair;

    public PrivateKeyHandler() {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA", "BC");
            generator.initialize(1024, new SecureRandom());
            this.keypair = generator.generateKeyPair();
        }
        catch (Exception e) {
            LOG.error("PrivateKeyHandler: Caught exception: " + e.getMessage());
        }
    }

    public KeyPair getIdentity() {
        return this.keypair;
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        return "silvertunnel-ng-org-Netlib";
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this.keypair.getPrivate();
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        String[] s = new String[]{"TorJava"};
        return s;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        try {
            X509V3CertificateGenerator generator = new X509V3CertificateGenerator();
            generator.reset();
            generator.setSerialNumber(BigInteger.valueOf(42L));
            generator.setNotBefore(new Date(System.currentTimeMillis() - 86400000L));
            generator.setNotAfter(new Date(System.currentTimeMillis() + 31536000000L));
            generator.setIssuerDN(new X509Name("CN=silvertunnel-ng-org-Netlib"));
            generator.setSubjectDN(new X509Name("CN=silvertunnel-ng-org-Netlib"));
            generator.setPublicKey(this.keypair.getPublic());
            generator.setSignatureAlgorithm("SHA1WITHRSA");
            X509Certificate x509 = generator.generate(this.keypair.getPrivate(), "BC");
            X509Certificate[] x509s = new X509Certificate[]{x509, x509};
            return x509s;
        }
        catch (Exception e) {
            LOG.error("Caught exception: " + e.getMessage());
            return null;
        }
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return null;
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return null;
    }
}

