/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tor.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import javax.crypto.Cipher;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.x509.RSAPublicKeyStructure;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.encodings.OAEPEncoding;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.JCERSAPrivateCrtKey;
import org.bouncycastle.jce.provider.JCERSAPrivateKey;
import org.bouncycastle.jce.provider.JCERSAPublicKey;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.util.encoders.Base64;
import org.silvertunnel_ng.netlib.layer.tor.util.AESCounterMode;
import org.silvertunnel_ng.netlib.layer.tor.util.Encoding;
import org.silvertunnel_ng.netlib.layer.tor.util.HybridEncryption;
import org.silvertunnel_ng.netlib.layer.tor.util.RSAKeyPair;
import org.silvertunnel_ng.netlib.layer.tor.util.TorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Encryption {
    private static final Logger LOG = LoggerFactory.getLogger(Encryption.class);
    public static final String DIGEST_ALGORITHM = "SHA-1";
    private static final String PK_ALGORITHM = "RSA";
    private static final int KEY_STRENGTH = 1024;
    private static final int KEY_CERTAINTY = 80;

    public static byte[] getDigest(byte[] input) {
        return Encryption.getDigest(DIGEST_ALGORITHM, input);
    }

    public static byte[] getDigest(String algorithm, byte[] input) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            md.update(input);
            return md.digest();
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static MessageDigest getMessagesDigest() {
        try {
            MessageDigest md = MessageDigest.getInstance(DIGEST_ALGORITHM);
            return md;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] intermediateDigest(MessageDigest md) {
        try {
            MessageDigest mdClone = (MessageDigest)md.clone();
            return mdClone.digest();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean verifySignature(byte[] signature, RSAPublicKeyStructure signingKey, byte[] input) {
        byte[] hash = Encryption.getDigest(input);
        try {
            RSAKeyParameters myRSAKeyParameters = new RSAKeyParameters(false, signingKey.getModulus(), signingKey.getPublicExponent());
            PKCS1Encoding pkcsAlg = new PKCS1Encoding((AsymmetricBlockCipher)new RSAEngine());
            pkcsAlg.init(false, (CipherParameters)myRSAKeyParameters);
            byte[] decryptedSignature = pkcsAlg.processBlock(signature, 0, signature.length);
            return Arrays.equals(hash, decryptedSignature);
        }
        catch (Exception e) {
            LOG.warn("unexpected", (Throwable)e);
            return false;
        }
    }

    public static boolean verifySignature(byte[] signature, PublicKey signingKey, byte[] data) {
        byte[] dataDigest = Encryption.getDigest(data);
        return Encryption.verifySignatureWithHash(signature, signingKey, dataDigest);
    }

    public static boolean verifySignatureWithHash(byte[] signature, PublicKey signingKey, byte[] dataDigest) {
        try {
            boolean verificationSuccessful;
            Cipher cipher = Cipher.getInstance(PK_ALGORITHM);
            cipher.init(2, signingKey);
            byte[] decryptedDigest = cipher.doFinal(signature);
            if (decryptedDigest != null && dataDigest != null && decryptedDigest.length > dataDigest.length) {
                LOG.warn("verifySignature(): try to fix bug in security calculation with OpenJDK-6 java web start (ticket #59)");
                LOG.warn("verifySignature(): original decryptedDigest=" + Encoding.toHexString(decryptedDigest));
                LOG.warn("verifySignature(): dataDigest              =" + Encoding.toHexString(dataDigest));
                byte[] fixedDecryptedDigest = new byte[dataDigest.length];
                System.arraycopy(decryptedDigest, decryptedDigest.length - dataDigest.length, fixedDecryptedDigest, 0, dataDigest.length);
                decryptedDigest = fixedDecryptedDigest;
            }
            if (!(verificationSuccessful = Arrays.equals(decryptedDigest, dataDigest))) {
                LOG.info("verifySignature(): decryptedDigest=" + Encoding.toHexString(decryptedDigest));
                LOG.info("verifySignature(): dataDigest     =" + Encoding.toHexString(dataDigest));
            }
            return verificationSuccessful;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] signData(byte[] data, RSAKeyParameters signingKey) {
        try {
            byte[] hash = Encryption.getDigest(data);
            PKCS1Encoding pkcs1 = new PKCS1Encoding((AsymmetricBlockCipher)new RSAEngine());
            pkcs1.init(true, (CipherParameters)signingKey);
            return pkcs1.processBlock(hash, 0, hash.length);
        }
        catch (InvalidCipherTextException e) {
            LOG.warn("Common.signData(): " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static byte[] signData(byte[] data, PrivateKey signingKey) {
        try {
            Cipher cipher = Cipher.getInstance(PK_ALGORITHM);
            cipher.init(1, signingKey);
            return cipher.doFinal(Encryption.getDigest(DIGEST_ALGORITHM, data));
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static RSAPublicKey extractPublicRSAKey(String s) {
        RSAPublicKey theKey;
        try {
            PEMReader reader = new PEMReader((Reader)new StringReader(s));
            Object o = reader.readObject();
            reader.close();
            if (!(o instanceof JCERSAPublicKey)) {
                throw new IOException("Encryption.extractPublicRSAKey: no public key found in string '" + s + "'");
            }
            JCERSAPublicKey JCEKey = (JCERSAPublicKey)o;
            theKey = Encryption.getRSAPublicKey(JCEKey.getModulus(), JCEKey.getPublicExponent());
        }
        catch (Exception e) {
            LOG.warn("Encryption.extractPublicRSAKey: Caught exception:" + e.getMessage());
            theKey = null;
        }
        return theKey;
    }

    public static RSAKeyPair extractRSAKeyPair(String s) {
        RSAKeyPair rsaKeyPair;
        try {
            PEMReader reader = new PEMReader((Reader)new StringReader(s));
            Object o = reader.readObject();
            reader.close();
            if (!(o instanceof KeyPair)) {
                throw new IOException("Encryption.extractRSAKeyPair: no private key found in string '" + s + "'");
            }
            KeyPair keyPair = (KeyPair)o;
            if (!(keyPair.getPrivate() instanceof JCERSAPrivateKey)) {
                throw new IOException("Encryption.extractRSAKeyPair: no private key found in key pair of string '" + s + "'");
            }
            if (!(keyPair.getPublic() instanceof JCERSAPublicKey)) {
                throw new IOException("Encryption.extractRSAKeyPair: no public key found in key pair of string '" + s + "'");
            }
            JCERSAPrivateCrtKey privateKey = (JCERSAPrivateCrtKey)keyPair.getPrivate();
            LOG.debug("JCEPrivateKey={}", (Object)privateKey);
            JCERSAPublicKey publicKey = (JCERSAPublicKey)keyPair.getPublic();
            rsaKeyPair = new RSAKeyPair((RSAPublicKey)publicKey, (RSAPrivateCrtKey)privateKey);
        }
        catch (Exception e) {
            LOG.warn("Encryption.extractPrivateRSAKey: Caught exception:" + e.getMessage());
            rsaKeyPair = null;
        }
        return rsaKeyPair;
    }

    public static String getPEMStringFromRSAKeyPair(RSAKeyPair rsaKeyPair) {
        StringWriter pemStrWriter = new StringWriter();
        PEMWriter pemWriter = new PEMWriter((Writer)pemStrWriter);
        try {
            KeyPair keyPair = new KeyPair(rsaKeyPair.getPublic(), rsaKeyPair.getPrivate());
            pemWriter.writeObject((Object)keyPair.getPrivate());
            pemWriter.close();
        }
        catch (IOException e) {
            LOG.warn("Caught exception:" + e.getMessage());
            return "";
        }
        return pemStrWriter.toString();
    }

    public static RSAPublicKey getRSAPublicKey(BigInteger modulus, BigInteger publicExponent) {
        try {
            return (RSAPublicKey)KeyFactory.getInstance(PK_ALGORITHM).generatePublic(new RSAPublicKeySpec(modulus, publicExponent));
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static RSAPrivateKey getRSAPrivateKey(BigInteger modulus, BigInteger privateExponent) {
        try {
            return (RSAPrivateKey)KeyFactory.getInstance(PK_ALGORITHM).generatePrivate(new RSAPrivateKeySpec(modulus, privateExponent));
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static RSAPublicKey extractBinaryRSAKey(byte[] b) {
        RSAPublicKey theKey;
        try {
            ASN1InputStream ais = new ASN1InputStream(b);
            DERObject asnObject = ais.readObject();
            ASN1Sequence sequence = (ASN1Sequence)asnObject;
            RSAPublicKeyStructure tempKey = new RSAPublicKeyStructure(sequence);
            theKey = Encryption.getRSAPublicKey(tempKey.getModulus(), tempKey.getPublicExponent());
            ais.close();
        }
        catch (IOException e) {
            LOG.warn("Caught exception:" + e.getMessage());
            theKey = null;
        }
        return theKey;
    }

    public static RSAPublicKey getRSAPublicKey(JCERSAPublicKey jpub) {
        return Encryption.getRSAPublicKey(jpub.getModulus(), jpub.getPublicExponent());
    }

    public static byte[] getPKCS1EncodingFromRSAPublicKey(RSAPublicKey pubKeyStruct) {
        try {
            RSAPublicKeyStructure myKey = new RSAPublicKeyStructure(pubKeyStruct.getModulus(), pubKeyStruct.getPublicExponent());
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ASN1OutputStream aOut = new ASN1OutputStream((OutputStream)bOut);
            aOut.writeObject((Object)myKey.toASN1Object());
            aOut.close();
            return bOut.toByteArray();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getPEMStringFromRSAPublicKey(RSAPublicKey rsaPublicKey) {
        StringBuffer tmpDirSigningKey = new StringBuffer();
        try {
            tmpDirSigningKey.append("-----BEGIN RSA PUBLIC KEY-----\n");
            byte[] base64Encoding = Base64.encode((byte[])Encryption.getPKCS1EncodingFromRSAPublicKey(rsaPublicKey));
            for (int i = 0; i < base64Encoding.length; ++i) {
                tmpDirSigningKey.append((char)base64Encoding[i]);
                if ((i + 1) % 64 != 0) continue;
                tmpDirSigningKey.append("\n");
            }
            tmpDirSigningKey.append("\n");
            tmpDirSigningKey.append("-----END RSA PUBLIC KEY-----\n");
        }
        catch (Exception e) {
            return null;
        }
        return tmpDirSigningKey.toString();
    }

    public static byte[] asymEncrypt(RSAPublicKey pub, byte[] symmetricKey, byte[] data) throws TorException {
        if (data == null) {
            throw new NullPointerException("can't encrypt NULL data");
        }
        HybridEncryption hybridEncryption = new HybridEncryption();
        byte[] result = hybridEncryption.encrypt(data, pub, symmetricKey);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encryption.asymEncrypt(): unencrypted payload:\n" + Encoding.toHexString(data, 100));
            LOG.debug("Encryption.asymEncrypt(): encrypted payload:\n" + Encoding.toHexString(result, 100));
        }
        return result;
    }

    public static byte[] asymDecrypt(RSAPrivateKey priv, byte[] data) throws TorException {
        if (data == null) {
            throw new NullPointerException("can't encrypt NULL data");
        }
        if (data.length < 70) {
            throw new TorException("input array too short");
        }
        try {
            int encryptedBytes = 0;
            OAEPEncoding oaep = new OAEPEncoding((AsymmetricBlockCipher)new RSAEngine());
            oaep.init(false, (CipherParameters)new RSAKeyParameters(true, priv.getModulus(), priv.getPrivateExponent()));
            encryptedBytes = oaep.getInputBlockSize();
            byte[] oaepInput = new byte[encryptedBytes];
            System.arraycopy(data, 0, oaepInput, 0, encryptedBytes);
            byte[] part1 = oaep.decodeBlock(oaepInput, 0, encryptedBytes);
            byte[] symmetricKey = new byte[16];
            System.arraycopy(part1, 0, symmetricKey, 0, 16);
            AESCounterMode aes = new AESCounterMode(symmetricKey);
            byte[] aesInput = new byte[data.length - encryptedBytes];
            System.arraycopy(data, encryptedBytes, aesInput, 0, aesInput.length);
            byte[] part2 = aes.processStream(aesInput);
            byte[] result = new byte[part1.length - 16 + part2.length];
            System.arraycopy(part1, 16, result, 0, part1.length - 16);
            System.arraycopy(part2, 0, result, part1.length - 16, part2.length);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Encryption.asymDecrypt():: encrypted payload:\n" + Encoding.toHexString(data, 100));
                LOG.debug("Encryption.asymDecrypt():: unencrypted payload:\n" + Encoding.toHexString(result, 100));
            }
            return result;
        }
        catch (InvalidCipherTextException e) {
            LOG.error("Encryption.asymDecrypt(): can't decrypt cipher text:" + e.getMessage());
            throw new TorException("Encryption.asymDecrypt(): InvalidCipherTextException:" + e.getMessage());
        }
    }

    public static RSAKeyPair createNewRSAKeyPair() {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(PK_ALGORITHM);
            keyGen.initialize(1024);
            KeyPair keypair = keyGen.genKeyPair();
            RSAPrivateCrtKey privateKey = (RSAPrivateCrtKey)keypair.getPrivate();
            RSAPublicKey publicKey = (RSAPublicKey)keypair.getPublic();
            LOG.debug("privateKey={}", (Object)privateKey);
            LOG.debug("publicKey={}", (Object)publicKey);
            return new RSAKeyPair(publicKey, privateKey);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("Could not create new key pair", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            if (Security.getProvider("BC") == null) {
                Security.addProvider((Provider)new BouncyCastleProvider());
            }
        }
        catch (Throwable t) {
            LOG.error("Cannot initialize class Encryption", t);
        }
    }
}

