/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tor.util;

import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AESCounterMode {
    private static final Logger LOG = LoggerFactory.getLogger(AESCounterMode.class);
    private static final String ALGORITHM = "AES";
    public static final int KEY_LEN = 16;
    private final Cipher cipher;
    private int blockSize;
    private byte[] counterBuffer;
    private byte[] streamBuffer;
    private int streamNext;

    public AESCounterMode(Key key) {
        if (key.getEncoded().length != 16) {
            String msg = "AESCounterMode.<init>: HINT: key.length!=16 bytes/128 bits";
            LOG.warn("AESCounterMode.<init>: HINT: key.length!=16 bytes/128 bits");
            LOG.debug("AESCounterMode.<init>: HINT: key.length!=16 bytes/128 bits", (Throwable)new Exception("Exception to log a stack trace"));
        }
        try {
            this.cipher = Cipher.getInstance("AES/ECB/NoPadding");
            this.cipher.init(1, key);
            this.blockSize = this.cipher.getBlockSize();
            this.counterBuffer = new byte[this.blockSize];
            this.streamBuffer = new byte[this.blockSize];
            this.streamNext = this.blockSize;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public AESCounterMode(byte[] key) {
        this(new SecretKeySpec(key, ALGORITHM));
    }

    private byte nextStreamByte() {
        ++this.streamNext;
        if (this.streamNext >= this.blockSize) {
            this.streamBuffer = this.cipher.update(this.counterBuffer);
            this.streamNext = 0;
            int j = this.blockSize - 1;
            do {
                int n = j--;
                this.counterBuffer[n] = (byte)(this.counterBuffer[n] + 1);
            } while (this.counterBuffer[j + 1] == 0 && j >= 0);
        }
        return this.streamBuffer[this.streamNext];
    }

    public byte[] processStream(byte[] input) {
        byte[] out = new byte[input.length];
        for (int i = 0; i < input.length; ++i) {
            byte cipherBytes = this.nextStreamByte();
            out[i] = (byte)(input[i] + 256 ^ cipherBytes + 256);
        }
        return out;
    }
}

