/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tor.stream;

import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.silvertunnel_ng.netlib.layer.tor.circuit.cells.Cell;
import org.silvertunnel_ng.netlib.layer.tor.circuit.cells.CellRelay;
import org.silvertunnel_ng.netlib.layer.tor.stream.SafePipedInputStream;
import org.silvertunnel_ng.netlib.layer.tor.stream.TCPStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TCPStreamThreadTor2JavaThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(TCPStreamThreadTor2JavaThread.class);
    private final TCPStream stream;
    private PipedInputStream sin;
    private PipedOutputStream fromtor;
    private boolean stopped;

    TCPStreamThreadTor2JavaThread(TCPStream stream) {
        this.stream = stream;
        try {
            this.sin = new SafePipedInputStream();
            this.fromtor = new PipedOutputStream(this.sin);
        }
        catch (IOException e) {
            LOG.error("TCPStreamThreadTor2Java: caught IOException " + e.getMessage());
        }
        this.start();
    }

    public void close() {
        this.stopped = true;
        this.interrupt();
    }

    @Override
    public void run() {
        while (!this.stream.isClosed() && !this.stopped) {
            Cell cell = this.stream.queue.get();
            if (cell == null) continue;
            if (!cell.isTypeRelay()) {
                LOG.error("TCPStreamThreadTor2Java.run(): stream " + this.stream.getId() + " received NON-RELAY cell:\n" + cell.toString());
                continue;
            }
            CellRelay relay = (CellRelay)cell;
            if (relay.isTypeData()) {
                LOG.debug("TCPStreamThreadTor2Java.run(): stream {} received data", (Object)this.stream.getId());
                try {
                    this.fromtor.write(relay.getData(), 0, relay.getLength());
                }
                catch (IOException e) {
                    LOG.error("TCPStreamThreadTor2Java.run(): caught IOException " + e.getMessage());
                }
                continue;
            }
            if (relay.isTypeEnd()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("TCPStreamThreadTor2Java.run(): stream " + this.stream.getId() + " is closed: " + relay.getReasonForClosing());
                }
                this.stream.setClosedForReason(relay.getPayload()[0] & 0xFF);
                this.stream.setClosed(true);
                this.stream.close(true);
                continue;
            }
            LOG.error("TCPStreamThreadTor2Java.run(): stream " + this.stream.getId() + " received strange cell:\n" + relay.toString());
        }
    }
}

