/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tor.stream;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.silvertunnel_ng.netlib.layer.tor.circuit.cells.CellRelayData;
import org.silvertunnel_ng.netlib.layer.tor.stream.TCPStream;
import org.silvertunnel_ng.netlib.layer.tor.util.TorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TCPStreamOutputStream
extends OutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(TCPStreamOutputStream.class);
    private final TCPStream stream;
    private PipedOutputStream sout;
    private PipedInputStream fromjava;
    private boolean stopped;
    private final byte[] buffer;
    private int bufferFilled;

    TCPStreamOutputStream(TCPStream stream) {
        this.stream = stream;
        this.buffer = new byte[498];
        this.bufferFilled = 0;
        try {
            this.sout = new PipedOutputStream();
            this.fromjava = new PipedInputStream(this.sout);
        }
        catch (IOException e) {
            LOG.error("TCPStreamThreadJava2Tor: caught IOException " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void close() {
        this.stopped = true;
    }

    @Override
    public void write(int b) throws IOException {
        byte[] bytes = new byte[]{(byte)b};
        this.write(bytes, 0, 1);
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.stopped) {
            return;
        }
        if (this.bufferFilled < 1) {
            return;
        }
        if (this.bufferFilled > this.buffer.length) {
            throw new IOException("TCPStreamOutputStream.flush(): there must be an error somewhere else");
        }
        CellRelayData cell = new CellRelayData(this.stream);
        cell.setLength(this.bufferFilled);
        if (cell.getLength() > cell.getData().length) {
            cell.setLength(cell.getData().length);
        }
        System.arraycopy(this.buffer, 0, cell.getData(), 0, this.bufferFilled);
        try {
            this.stream.sendCell(cell);
        }
        catch (TorException exception) {
            throw new IOException(exception);
        }
        this.bufferFilled = 0;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        int bytesFree = this.buffer.length;
        if (this.bufferFilled == this.buffer.length) {
            this.flush();
        } else {
            bytesFree = this.buffer.length - this.bufferFilled;
        }
        if (len > bytesFree) {
            this.write(b, off, bytesFree);
            this.write(b, off + bytesFree, len - bytesFree);
        } else {
            System.arraycopy(b, off, this.buffer, this.bufferFilled, len);
            this.bufferFilled += len;
            this.flush();
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }
}

