/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tor.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.Arrays;
import org.silvertunnel_ng.netlib.api.NetSocket;
import org.silvertunnel_ng.netlib.layer.tor.circuit.Circuit;
import org.silvertunnel_ng.netlib.layer.tor.circuit.Queue;
import org.silvertunnel_ng.netlib.layer.tor.circuit.Stream;
import org.silvertunnel_ng.netlib.layer.tor.circuit.cells.Cell;
import org.silvertunnel_ng.netlib.layer.tor.circuit.cells.CellRelay;
import org.silvertunnel_ng.netlib.layer.tor.circuit.cells.CellRelayBegin;
import org.silvertunnel_ng.netlib.layer.tor.circuit.cells.CellRelayBeginDir;
import org.silvertunnel_ng.netlib.layer.tor.circuit.cells.CellRelayConnected;
import org.silvertunnel_ng.netlib.layer.tor.circuit.cells.CellRelayData;
import org.silvertunnel_ng.netlib.layer.tor.circuit.cells.CellRelayDrop;
import org.silvertunnel_ng.netlib.layer.tor.circuit.cells.CellRelayEnd;
import org.silvertunnel_ng.netlib.layer.tor.circuit.cells.CellRelaySendme;
import org.silvertunnel_ng.netlib.layer.tor.common.TCPStreamProperties;
import org.silvertunnel_ng.netlib.layer.tor.common.TorConfig;
import org.silvertunnel_ng.netlib.layer.tor.common.TorEvent;
import org.silvertunnel_ng.netlib.layer.tor.directory.RouterImpl;
import org.silvertunnel_ng.netlib.layer.tor.stream.QueueTor2JavaHandler;
import org.silvertunnel_ng.netlib.layer.tor.stream.TCPStreamOutputStream;
import org.silvertunnel_ng.netlib.layer.tor.util.TorException;
import org.silvertunnel_ng.netlib.layer.tor.util.TorNoAnswerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCPStream
implements Stream,
NetSocket {
    private static final Logger LOG = LoggerFactory.getLogger(TCPStream.class);
    private static final int STREAM_LEVEL_FLOW_WINDOW = 500;
    private static final int STREAM_LEVEL_FLOW_INCREMENT = 50;
    private int streamLevelFlowControlRecv = 500;
    private int streamLevelFlowControlSend = 500;
    private final int queueTimeout = TorConfig.queueTimeoutStreamBuildup;
    public static final int QUEUE_TIMEOUNT2 = 20;
    protected transient Circuit circuit;
    protected int streamId;
    protected Queue queue;
    private InetAddress resolvedAddress;
    private boolean established;
    private boolean closed;
    private int closedForReason;
    private QueueTor2JavaHandler qhT2J;
    private TCPStreamOutputStream outputStream;
    private long created;
    private long lastAction;
    private long lastCellSentDate;
    private final transient Object waitForSendme = new Object();

    public TCPStream(Circuit circuit, TCPStreamProperties sp) throws IOException, TorException, TorNoAnswerException {
        this.established = false;
        this.lastAction = this.created = System.currentTimeMillis();
        this.lastCellSentDate = this.created;
        this.circuit = circuit;
        circuit.assignStreamId(this);
        this.queue = new Queue(this.queueTimeout);
        this.closed = false;
        this.closedForReason = 0;
        if (LOG.isDebugEnabled()) {
            LOG.debug("TCPStream: building new stream " + this.toString());
        }
        long startSetupTime = System.currentTimeMillis();
        if (sp.isConnectToDirServer()) {
            this.sendCell(new CellRelayBeginDir(this));
        } else {
            this.sendCell(new CellRelayBegin((Stream)this, sp));
        }
        CellRelay relay = null;
        try {
            LOG.debug("TCPStream: Waiting for Relay-Connected Cell...");
            relay = this.queue.receiveRelayCell(4);
            LOG.debug("TCPStream: Got Relay-Connected Cell");
        }
        catch (TorException e) {
            if (!this.closed) {
                LOG.warn("TCPStream: Closed: " + this.toString() + " due to TorException:" + e.getMessage());
            }
            this.closed = true;
            circuit.reportStreamFailure(this);
            throw e;
        }
        catch (IOException e) {
            this.closed = true;
            LOG.warn("TCPStream: Closed:" + this.toString() + " due to IOException:" + e.getMessage());
            throw e;
        }
        int setupDuration = (int)(System.currentTimeMillis() - startSetupTime);
        switch (relay.getLength()) {
            case 8: {
                byte[] ip = new byte[4];
                System.arraycopy(relay.getData(), 0, ip, 0, ip.length);
                try {
                    this.resolvedAddress = InetAddress.getByAddress(ip);
                    sp.setAddr(this.resolvedAddress);
                    sp.setAddrResolved(true);
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug("TCPStream: storing resolved IP " + this.resolvedAddress.toString());
                }
                catch (IOException e) {
                    LOG.info("unexpected for resolved ip={}", (Object)Arrays.toString(ip), (Object)e);
                }
                break;
            }
            case 25: {
                break;
            }
            default: {
                LOG.error("this should not happen");
            }
        }
        this.qhT2J = new QueueTor2JavaHandler(this);
        this.queue.addHandler(this.qhT2J);
        this.outputStream = new TCPStreamOutputStream(this);
        LOG.info("TCPStream: build stream " + this.toString() + " within " + setupDuration + " ms");
        circuit.registerStream(sp, setupDuration);
        this.established = true;
        circuit.getTorEventService().fireEvent(new TorEvent(20, this, "Stream build: " + this.toString()));
    }

    public TCPStream(Circuit circuit, int streamId) throws IOException, TorException, TorNoAnswerException {
        this.established = false;
        this.lastAction = this.created = System.currentTimeMillis();
        this.lastCellSentDate = this.created;
        this.circuit = circuit;
        circuit.assignStreamId(this, streamId);
        this.queue = new Queue(20);
        this.closed = false;
        this.closedForReason = 0;
        if (LOG.isDebugEnabled()) {
            LOG.debug("TCPStream(2): building new stream " + this.toString());
        }
        long startSetupTime = System.currentTimeMillis();
        this.sendCell(new CellRelayConnected(this));
        int setupDuration = (int)(System.currentTimeMillis() - startSetupTime);
        this.qhT2J = new QueueTor2JavaHandler(this);
        this.queue.addHandler(this.qhT2J);
        this.outputStream = new TCPStreamOutputStream(this);
        LOG.info("TCPStream: build stream " + this.toString() + " within " + setupDuration + " ms");
        TCPStreamProperties sp = new TCPStreamProperties();
        circuit.registerStream(sp, setupDuration);
        this.established = true;
        circuit.getTorEventService().fireEvent(new TorEvent(20, this, "Stream build: " + this.toString()));
    }

    protected TCPStream(Circuit circuit) {
        this.circuit = circuit;
    }

    @Override
    public void sendCell(Cell cell) throws TorException {
        this.lastCellSentDate = System.currentTimeMillis();
        if (!cell.isTypePadding()) {
            this.lastAction = this.lastCellSentDate;
            if (cell.isTypeRelay() && cell instanceof CellRelayData) {
                --this.streamLevelFlowControlSend;
                LOG.debug("STREAM_FLOW_CONTROL_SEND = {}", (Object)this.streamLevelFlowControlSend);
                if (this.streamLevelFlowControlSend == 0) {
                    LOG.debug("waiting for SENDME cell");
                    try {
                        this.waitForSendme.wait();
                    }
                    catch (InterruptedException exception) {
                        throw new TorException("interrupted while trying to wait for SENDME cell", exception);
                    }
                }
            }
        }
        try {
            this.circuit.sendCell(cell);
        }
        catch (IOException e) {
            this.circuit.reportStreamFailure(this);
            this.close(false);
            throw new TorException(e);
        }
    }

    public void sendKeepAlive() {
        try {
            this.sendCell(new CellRelayDrop(this));
        }
        catch (TorException e) {
            LOG.debug("got TorException while trying to send a keep alive", (Throwable)e);
        }
    }

    @Override
    public void close() {
        this.close(false);
        if (LOG.isDebugEnabled()) {
            LOG.debug("TCPStream.close(): removing stream " + this.toString());
        }
        this.circuit.removeStream(this.streamId);
    }

    @Override
    public void close(boolean force) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("TCPStream.close(): closing stream " + this.toString());
        }
        this.circuit.getTorEventService().fireEvent(new TorEvent(21, this, "Stream closed: " + this.toString()));
        if (!this.closed && !force) {
            try {
                this.sendCell(new CellRelayEnd((Stream)this, 6));
            }
            catch (TorException e) {
                LOG.debug("got TorException while trying to close the stream", (Throwable)e);
            }
        }
        this.closed = true;
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (Exception e) {
                LOG.debug("got Exception : {}", (Object)e.getMessage(), (Object)e);
            }
        }
        this.queue.close();
        this.circuit.removeStream(this.streamId);
    }

    @Override
    public InputStream getInputStream() {
        return this.qhT2J.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public String getRoute() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.circuit.getRouteEstablished(); ++i) {
            RouterImpl r = this.circuit.getRouteNodes()[i].getRouter();
            sb.append(", ");
            sb.append(r.getNickname() + " (" + r.getCountryCode() + ")");
        }
        return sb.toString();
    }

    public String toString() {
        if (this.closed) {
            return this.streamId + " on circuit " + this.circuit.toString() + " to ??? (closed)";
        }
        return this.streamId + " on circuit " + this.circuit.toString() + " to ???";
    }

    @Override
    public void setId(int id) {
        if (this.streamId == 0) {
            this.streamId = id;
        } else {
            this.streamId = id;
            LOG.warn("replaced TCPStream.ID " + this.streamId + " by " + id);
        }
    }

    @Override
    public int getId() {
        return this.streamId;
    }

    @Override
    public long getLastCellSentDate() {
        return this.lastCellSentDate;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    void setClosed(boolean closed) {
        this.closed = closed;
    }

    @Override
    public Circuit getCircuit() {
        return this.circuit;
    }

    @Override
    public void processCell(Cell cell) throws TorException {
        if (cell.isTypeRelay() && cell instanceof CellRelay) {
            CellRelay relay = (CellRelay)cell;
            if (relay.isTypeData()) {
                --this.streamLevelFlowControlRecv;
                LOG.debug("STREAM_FLOW_CONTROL_RECV = {}", (Object)this.streamLevelFlowControlRecv);
                this.circuit.reduceCircWindowRecv();
                if (this.streamLevelFlowControlRecv <= 450) {
                    try {
                        this.sendCell(new CellRelaySendme(this));
                        this.streamLevelFlowControlRecv += 50;
                    }
                    catch (TorException exception) {
                        LOG.warn("problems with sending RELAY_SENDME for stream {}", (Object)this.getId(), (Object)exception);
                        throw new TorException("problems with sending RELAY_SENDME for stream " + this.getId(), exception);
                    }
                }
            } else if (relay.isTypeSendme()) {
                this.streamLevelFlowControlSend += 50;
                this.waitForSendme.notifyAll();
                LOG.debug("got RELAY_SENDME cell, increasing stream {} flow send window to {}", (Object)this.getId(), (Object)this.streamLevelFlowControlRecv);
            }
        }
        this.queue.add(cell);
    }

    public int getQueueTimeout() {
        return this.queueTimeout;
    }

    public InetAddress getResolvedAddress() {
        return this.resolvedAddress;
    }

    public boolean isEstablished() {
        return this.established;
    }

    public int getClosedForReason() {
        return this.closedForReason;
    }

    public void setClosedForReason(int closedForReason) {
        this.closedForReason = closedForReason;
    }

    public long getCreated() {
        return this.created;
    }

    public long getLastAction() {
        return this.lastAction;
    }
}

