/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tor.stream;

import org.silvertunnel_ng.netlib.layer.tor.circuit.Circuit;
import org.silvertunnel_ng.netlib.layer.tor.common.TCPStreamProperties;
import org.silvertunnel_ng.netlib.layer.tor.stream.TCPStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(StreamThread.class);
    private TCPStream stream;
    private final Circuit cs;
    private final TCPStreamProperties sp;

    public StreamThread(Circuit cs, TCPStreamProperties sp) {
        this.cs = cs;
        this.sp = sp;
        this.start();
    }

    @Override
    public void run() {
        try {
            this.stream = new TCPStream(this.cs, this.sp);
        }
        catch (Exception e) {
            if (this.stream != null && this.stream.queue != null && !this.stream.queue.isClosed()) {
                LOG.warn("Tor.StreamThread.run(): " + e.getMessage());
            }
            this.stream = null;
        }
    }

    public TCPStream getStream() {
        return this.stream;
    }
}

