/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tor.stream;

import java.io.IOException;
import org.silvertunnel_ng.netlib.api.util.IpNetAddress;
import org.silvertunnel_ng.netlib.layer.tor.circuit.Circuit;
import org.silvertunnel_ng.netlib.layer.tor.circuit.Queue;
import org.silvertunnel_ng.netlib.layer.tor.circuit.Stream;
import org.silvertunnel_ng.netlib.layer.tor.circuit.cells.CellRelay;
import org.silvertunnel_ng.netlib.layer.tor.circuit.cells.CellRelayResolve;
import org.silvertunnel_ng.netlib.layer.tor.common.TorConfig;
import org.silvertunnel_ng.netlib.layer.tor.stream.TCPStream;
import org.silvertunnel_ng.netlib.layer.tor.util.TorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResolveStream
extends TCPStream {
    private static final Logger LOG = LoggerFactory.getLogger(ResolveStream.class);
    private final int queueTimeoutS = TorConfig.queueTimeoutResolve;

    public ResolveStream(Circuit c) {
        super(c);
    }

    public Object resolve(String hostname) throws TorException, IOException {
        this.circuit.assignStreamId(this);
        this.circuit.getStreamHistory().add(hostname);
        this.queue = new Queue(this.queueTimeoutS);
        this.setClosed(false);
        if (LOG.isDebugEnabled()) {
            LOG.debug("resolving hostname " + hostname + " on stream " + this.toString());
        }
        this.sendCell(new CellRelayResolve((Stream)this, hostname));
        CellRelay relay = this.queue.receiveRelayCell(12);
        int len = relay.getData()[1] & 0xFF;
        byte[] value = new byte[len];
        byte[] relayData = relay.getData();
        System.arraycopy(relayData, 2, value, 0, value.length);
        if (relayData[0] == -16) {
            throw new TorException("transient error: " + new String(value));
        }
        if (relayData[0] == -15) {
            throw new TorException("non transient error: " + new String(value));
        }
        if (relayData[0] != 0 && relayData[0] != 4 && relayData[0] != 6) {
            throw new TorException("can't handle answers of type " + relayData[0]);
        }
        if (relayData[0] == 0) {
            return new String(value, "UTF-8");
        }
        return new IpNetAddress(value);
    }
}

