/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tor.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.silvertunnel_ng.netlib.layer.tor.circuit.QueueHandler;
import org.silvertunnel_ng.netlib.layer.tor.circuit.cells.Cell;
import org.silvertunnel_ng.netlib.layer.tor.circuit.cells.CellRelay;
import org.silvertunnel_ng.netlib.layer.tor.stream.SafePipedInputStream;
import org.silvertunnel_ng.netlib.layer.tor.stream.TCPStream;
import org.silvertunnel_ng.netlib.layer.tor.util.TorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class QueueTor2JavaHandler
implements QueueHandler {
    private static final Logger LOG = LoggerFactory.getLogger(QueueTor2JavaHandler.class);
    private final TCPStream stream;
    private PipedInputStream sin;
    private PipedOutputStream fromtor;
    private boolean stopped;

    QueueTor2JavaHandler(TCPStream stream) {
        this.stream = stream;
        try {
            this.sin = new SafePipedInputStream();
            this.fromtor = new PipedOutputStream(this.sin);
        }
        catch (IOException e) {
            LOG.error("QueueTor2JavaHandler: caught IOException " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void close() {
        this.stopped = true;
        try {
            this.fromtor.close();
        }
        catch (Exception e) {
            LOG.debug("got Exception : {}", (Object)e.getMessage(), (Object)e);
        }
    }

    @Override
    public boolean handleCell(Cell cell) throws TorException {
        if (this.stream.isClosed() || this.stopped) {
            return false;
        }
        if (cell == null) {
            return false;
        }
        if (!cell.isTypeRelay()) {
            return false;
        }
        CellRelay relay = (CellRelay)cell;
        if (relay.isTypeData()) {
            LOG.debug("QueueTor2JavaHandler.handleCell(): stream {} received data", (Object)this.stream.getId());
            try {
                this.fromtor.write(relay.getData(), 0, relay.getLength());
            }
            catch (IOException e) {
                LOG.error("QueueTor2JavaHandler.handleCell(): caught IOException " + e.getMessage(), (Throwable)e);
            }
            return true;
        }
        if (relay.isTypeEnd()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("QueueTor2JavaHandler.handleCell(): stream " + this.stream.getId() + " is closed: " + relay.getReasonForClosing());
            }
            this.stream.setClosedForReason(relay.getPayload()[0] & 0xFF);
            this.stream.setClosed(true);
            this.stream.close(true);
            this.stopped = true;
            return true;
        }
        return false;
    }

    public InputStream getInputStream() {
        return this.sin;
    }
}

