/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tor.hiddenservice;

import java.io.IOException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.HashSet;
import java.util.Set;
import org.silvertunnel_ng.netlib.layer.tor.directory.SDIntroductionPoint;
import org.silvertunnel_ng.netlib.layer.tor.util.Encryption;
import org.silvertunnel_ng.netlib.layer.tor.util.RSAKeyPair;
import org.silvertunnel_ng.netlib.layer.tor.util.TorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiddenServiceProperties {
    private static final Logger LOG = LoggerFactory.getLogger(HiddenServiceProperties.class);
    private RSAPublicKey pub;
    private RSAPrivateKey priv;
    private byte[] pubKeyHash;
    private int port;
    private Set<SDIntroductionPoint> introPoints;
    private int minimumNumberOfIntroPoints;

    public HiddenServiceProperties(int port, RSAKeyPair keyPair) throws TorException {
        this.init(port, new HashSet<SDIntroductionPoint>(), keyPair);
    }

    public HiddenServiceProperties(int port, Set<SDIntroductionPoint> introPoints, RSAKeyPair keyPair) throws TorException {
        this.init(port, introPoints, keyPair);
    }

    private void init(int port, Set<SDIntroductionPoint> introPoints, RSAKeyPair keyPair) throws TorException {
        this.port = port;
        this.introPoints = introPoints;
        this.minimumNumberOfIntroPoints = 3;
        this.pub = keyPair.getPublic();
        this.priv = keyPair.getPrivate();
        this.pubKeyHash = Encryption.getDigest(Encryption.getPKCS1EncodingFromRSAPublicKey(this.pub));
    }

    public HiddenServiceProperties(String filename) throws IOException {
        throw new IOException("not implemented yet");
    }

    void writeToFile(String filename) throws IOException {
        throw new IOException("not implemented yet");
    }

    public void addIntroPoint(SDIntroductionPoint introPoint) {
        this.introPoints.add(introPoint);
    }

    public RSAPublicKey getPublicKey() {
        return this.pub;
    }

    public RSAPrivateKey getPrivateKey() {
        return this.priv;
    }

    public byte[] getPubKeyHash() {
        return this.pubKeyHash;
    }

    public int getPort() {
        return this.port;
    }

    public Set<SDIntroductionPoint> getIntroPoints() {
        return this.introPoints;
    }

    public int getNumberOfIntroPoints() {
        return this.introPoints.size();
    }

    public int getMinimumNumberOfIntroPoints() {
        return this.minimumNumberOfIntroPoints;
    }
}

