/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tor.hiddenservice;

import java.util.HashMap;
import java.util.Map;
import org.silvertunnel_ng.netlib.layer.tor.common.TorConfig;
import org.silvertunnel_ng.netlib.layer.tor.directory.RendezvousServiceDescriptor;

public final class HiddenServiceDescriptorCache {
    private static HiddenServiceDescriptorCache instance;
    private static Map<String, RendezvousServiceDescriptor> cachedRendezvousServiceDescriptors;

    public static synchronized HiddenServiceDescriptorCache getInstance() {
        if (instance == null) {
            instance = new HiddenServiceDescriptorCache();
            instance.init();
        }
        return instance;
    }

    public synchronized void init() {
        cachedRendezvousServiceDescriptors.clear();
        if (TorConfig.isCacheHiddenServiceDescriptor()) {
            // empty if block
        }
    }

    public synchronized void saveCacheToDisk() {
        if (!TorConfig.isCacheHiddenServiceDescriptor()) {
            return;
        }
    }

    public void put(String z, RendezvousServiceDescriptor descriptor) {
        cachedRendezvousServiceDescriptors.put(z, descriptor);
    }

    public RendezvousServiceDescriptor get(String z) {
        RendezvousServiceDescriptor result = cachedRendezvousServiceDescriptors.get(z);
        if (result == null) {
            return null;
        }
        if (result.isPublicationTimeValid()) {
            return result;
        }
        return null;
    }

    static {
        cachedRendezvousServiceDescriptors = new HashMap<String, RendezvousServiceDescriptor>();
    }
}

