/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tor.directory;

import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.silvertunnel_ng.netlib.api.util.TcpipNetAddress;
import org.silvertunnel_ng.netlib.layer.tor.api.Fingerprint;
import org.silvertunnel_ng.netlib.layer.tor.directory.FingerprintImpl;
import org.silvertunnel_ng.netlib.layer.tor.util.Encoding;
import org.silvertunnel_ng.netlib.layer.tor.util.Encryption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDIntroductionPoint {
    private static final Logger LOG = LoggerFactory.getLogger(SDIntroductionPoint.class);
    private static Pattern patternSingle;
    private final String identifier;
    private final TcpipNetAddress ipAddressAndOnionPort;
    private final RSAPublicKey onionPublicKey;
    private final RSAPublicKey servicePublicKey;

    public static Collection<SDIntroductionPoint> parseMultipleIntroductionPoints(String introductionPointsStr) {
        ArrayList<SDIntroductionPoint> result = new ArrayList<SDIntroductionPoint>();
        Matcher m = patternSingle.matcher(introductionPointsStr);
        int i = 0;
        while (m.find()) {
            try {
                SDIntroductionPoint ip = new SDIntroductionPoint(m);
                result.add(ip);
            }
            catch (Exception e) {
                LOG.debug("invalid introduction-point i={} skipped", (Object)i, (Object)e);
            }
            ++i;
        }
        return result;
    }

    public static String formatMultipleIntroductionPoints(Collection<SDIntroductionPoint> introPoints) {
        StringBuffer result = new StringBuffer();
        for (SDIntroductionPoint introPoint : introPoints) {
            result.append(introPoint.toIntroductionPoint());
        }
        return result.toString();
    }

    public Fingerprint getIdentifierAsFingerprint() {
        return new FingerprintImpl(Encoding.parseBase32(this.identifier));
    }

    private SDIntroductionPoint(Matcher m) {
        this.identifier = m.group(1);
        String ipAddress = m.group(2);
        int onionPort = Integer.parseInt(m.group(3));
        this.ipAddressAndOnionPort = new TcpipNetAddress(ipAddress + ":" + onionPort);
        String onionKeyStr = m.group(4);
        this.onionPublicKey = Encryption.extractPublicRSAKey(onionKeyStr);
        String serviceKeyStr = m.group(5);
        this.servicePublicKey = Encryption.extractPublicRSAKey(serviceKeyStr);
    }

    public SDIntroductionPoint(String identifier, TcpipNetAddress ipAddressAndOnionPort, RSAPublicKey onionPublicKey, RSAPublicKey servicePublicKey) {
        this.identifier = identifier;
        this.ipAddressAndOnionPort = ipAddressAndOnionPort;
        this.onionPublicKey = onionPublicKey;
        this.servicePublicKey = servicePublicKey;
    }

    public String toString() {
        return this.identifier + "-" + this.ipAddressAndOnionPort;
    }

    public String toIntroductionPoint() {
        return "introduction-point " + this.identifier + "\n" + "ip-address " + this.ipAddressAndOnionPort.getIpaddressAsString() + "\n" + "onion-port " + this.ipAddressAndOnionPort.getPort() + "\n" + "onion-key\n" + Encryption.getPEMStringFromRSAPublicKey(this.onionPublicKey) + "service-key\n" + Encryption.getPEMStringFromRSAPublicKey(this.servicePublicKey);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public TcpipNetAddress getIpAddressAndOnionPort() {
        return this.ipAddressAndOnionPort;
    }

    public RSAPublicKey getOnionPublicKey() {
        return this.onionPublicKey;
    }

    public RSAPublicKey getServicePublicKey() {
        return this.servicePublicKey;
    }

    static {
        try {
            patternSingle = Pattern.compile("introduction-point ([a-z2-7]+)\nip-address (\\d+\\.\\d+\\.\\d+\\.\\d+)\nonion-port (\\d+)\nonion-key\n(-----BEGIN RSA PUBLIC KEY-----\n.*?-----END RSA PUBLIC KEY-----)\nservice-key\n(-----BEGIN RSA PUBLIC KEY-----\n.*?-----END RSA PUBLIC KEY-----)", 43);
        }
        catch (Exception e) {
            LOG.error("could not initialze class " + SDIntroductionPoint.class.getName(), (Throwable)e);
        }
    }
}

