/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tor.directory;

import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Date;
import javax.xml.bind.DatatypeConverter;
import org.silvertunnel_ng.netlib.layer.tor.api.Fingerprint;
import org.silvertunnel_ng.netlib.layer.tor.directory.FingerprintImpl;

public class RouterStatusDescription {
    private String nickname;
    private Fingerprint fingerprint;
    private byte[] digestDescriptor;
    private Date lastPublication;
    private String ip;
    private int orPort;
    private int dirPort;
    private String flags;
    private SecureRandom rnd = new SecureRandom();

    public boolean isBetterThan(RouterStatusDescription other) {
        if (this.flags.indexOf("Running") >= 0 && other.flags.indexOf("Running") < 0) {
            return true;
        }
        if (other.flags.indexOf("Running") >= 0 && this.flags.indexOf("Running") < 0) {
            return false;
        }
        if (this.flags.indexOf("Authority") >= 0 && other.flags.indexOf("Authority") < 0) {
            return true;
        }
        if (other.flags.indexOf("Authority") >= 0 && this.flags.indexOf("Authority") < 0) {
            return false;
        }
        if (this.flags.indexOf("Exit") >= 0 && other.flags.indexOf("Exit") < 0) {
            return true;
        }
        if (other.flags.indexOf("Exit") >= 0 && this.flags.indexOf("Exit") < 0) {
            return false;
        }
        if (this.flags.indexOf("Guard") >= 0 && other.flags.indexOf("Guard") < 0) {
            return true;
        }
        if (other.flags.indexOf("Guard") >= 0 && this.flags.indexOf("Guard") < 0) {
            return false;
        }
        if (this.flags.indexOf("Fast") >= 0 && other.flags.indexOf("Fast") < 0) {
            return true;
        }
        if (other.flags.indexOf("Fast") >= 0 && this.flags.indexOf("Fast") < 0) {
            return false;
        }
        if (this.flags.indexOf("Stable") >= 0 && other.flags.indexOf("Stable") < 0) {
            return true;
        }
        if (other.flags.indexOf("Stable") >= 0 && this.flags.indexOf("Stable") < 0) {
            return false;
        }
        if (this.flags.indexOf("Valid") >= 0 && other.flags.indexOf("Valid") < 0) {
            return true;
        }
        if (other.flags.indexOf("Valid") >= 0 && this.flags.indexOf("Valid") < 0) {
            return false;
        }
        if (this.lastPublication.compareTo(other.lastPublication) < 0) {
            return true;
        }
        if (this.lastPublication.compareTo(other.lastPublication) > 0) {
            return false;
        }
        if (this.rnd != null) {
            return this.rnd.nextBoolean();
        }
        return false;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public Fingerprint getFingerprint() {
        return this.fingerprint;
    }

    public void setFingerprint(String fingerprint) {
        this.fingerprint = new FingerprintImpl(fingerprint);
    }

    public void setFingerprint(byte[] fingerprint) {
        this.fingerprint = new FingerprintImpl(fingerprint);
    }

    public void setFingerprint(Fingerprint fingerprint) {
        this.fingerprint = fingerprint;
    }

    public byte[] getDigestDescriptor() {
        return this.digestDescriptor;
    }

    public void setDigestDescriptor(String digestDescriptorBase64) {
        String base64 = digestDescriptorBase64;
        while (base64.length() % 4 != 0) {
            base64 = base64 + "=";
        }
        this.setDigestDescriptor(DatatypeConverter.parseBase64Binary((String)base64));
    }

    public void setDigestDescriptor(byte[] digestDescriptor) {
        this.digestDescriptor = digestDescriptor;
    }

    public Date getLastPublication() {
        return this.lastPublication;
    }

    public void setLastPublication(Date lastPublication) {
        this.lastPublication = lastPublication;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public int getOrPort() {
        return this.orPort;
    }

    public void setOrPort(int orPort) {
        this.orPort = orPort;
    }

    public int getDirPort() {
        return this.dirPort;
    }

    public void setDirPort(int dirPort) {
        this.dirPort = dirPort;
    }

    public String getFlags() {
        return this.flags;
    }

    public void setFlags(String flags) {
        this.flags = flags;
    }

    public SecureRandom getRnd() {
        return this.rnd;
    }

    public void setRnd(SecureRandom rnd) {
        this.rnd = rnd;
    }

    public String toString() {
        return "RouterStatusDescription [nickname=" + this.nickname + ", fingerprint=" + this.fingerprint + ", digestDescriptor=" + Arrays.toString(this.digestDescriptor) + ", lastPublication=" + this.lastPublication + ", ip=" + this.ip + ", orPort=" + this.orPort + ", dirPort=" + this.dirPort + ", flags=" + this.flags + ", rnd=" + this.rnd + "]";
    }
}

