/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tor.directory;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import org.silvertunnel_ng.netlib.api.util.TcpipNetAddress;
import org.silvertunnel_ng.netlib.layer.tor.api.Fingerprint;
import org.silvertunnel_ng.netlib.layer.tor.api.Router;
import org.silvertunnel_ng.netlib.layer.tor.api.RouterExitPolicy;
import org.silvertunnel_ng.netlib.layer.tor.common.LookupServiceUtil;
import org.silvertunnel_ng.netlib.layer.tor.common.TorConfig;
import org.silvertunnel_ng.netlib.layer.tor.directory.FingerprintImpl;
import org.silvertunnel_ng.netlib.layer.tor.directory.RouterDescriptorFormatKeys;
import org.silvertunnel_ng.netlib.layer.tor.directory.RouterExitPolicyImpl;
import org.silvertunnel_ng.netlib.layer.tor.util.Encoding;
import org.silvertunnel_ng.netlib.layer.tor.util.Encryption;
import org.silvertunnel_ng.netlib.layer.tor.util.TorException;
import org.silvertunnel_ng.netlib.layer.tor.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RouterImpl
implements Router,
Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(RouterImpl.class);
    private String routerDescriptor;
    private String nickname;
    private String hostname;
    private InetAddress address;
    private String countryCode;
    private int orPort;
    private int socksPort;
    private int dirPort;
    private int bandwidthAvg;
    private int bandwidthBurst;
    private int bandwidthObserved;
    private String platform;
    private long published;
    private Fingerprint fingerprint;
    private Fingerprint v3ident;
    private int uptime;
    private RSAPublicKey onionKey;
    private RSAPrivateKey onionKeyPrivate;
    private RSAPublicKey signingKey;
    private RSAPrivateKey signingKeyPrivate;
    private RouterExitPolicy[] exitpolicy;
    private byte[] routerSignature;
    private String contact;
    private Set<Fingerprint> family = new HashSet<Fingerprint>();
    private long validUntil;
    private static final int MAX_EXITPOLICY_ITEMS = 300;
    private long lastUpdate;
    private boolean dirv2Authority = false;
    private boolean dirv2Exit = false;
    private boolean dirv2Fast = false;
    private boolean dirv2Guard = false;
    private boolean dirv2Named = false;
    private boolean dirv2Stable = false;
    private boolean dirv2Running = false;
    private boolean dirv2Valid = false;
    private boolean dirv2V2dir = false;
    private boolean dirv2HSDir = false;
    private float rankingIndex;
    private static final int highBandwidth = 0x200000;
    private static final float alpha = 0.6f;
    private static final float punishmentFactor = 0.75f;
    private static final int MAX_ROUTERDESCRIPTOR_LENGTH = 10000;

    public RouterImpl(String routerDescriptor) throws TorException {
        if (routerDescriptor.length() > 10000) {
            throw new TorException("skipped router with routerDescriptor of length=" + routerDescriptor.length());
        }
        this.init();
        this.parseRouterDescriptor(routerDescriptor);
        this.updateServerRanking();
        this.countryCode = LookupServiceUtil.getCountryCodeOfIpAddress(this.address);
    }

    public RouterImpl(RSAPublicKey pk) throws TorException {
        this.init();
        this.onionKey = pk;
        this.countryCode = "--";
    }

    RouterImpl(String nickname, InetAddress address, int orPort, int dirPort, Fingerprint v3ident, Fingerprint fingerprint) throws TorException {
        this.nickname = nickname;
        this.address = address;
        this.hostname = address.getHostAddress();
        this.orPort = orPort;
        this.dirPort = dirPort;
        this.fingerprint = fingerprint.cloneReliable();
        this.v3ident = v3ident == null ? null : v3ident.cloneReliable();
    }

    private void init() {
        this.rankingIndex = -1.0f;
    }

    void updateServerStatus(String flags) {
        if (flags.contains("Running")) {
            this.dirv2Running = true;
        }
        if (flags.contains("Exit")) {
            this.dirv2Exit = true;
        }
        if (flags.contains("Authority")) {
            this.dirv2Authority = true;
        }
        if (flags.contains("Fast")) {
            this.dirv2Fast = true;
        }
        if (flags.contains("Guard")) {
            this.dirv2Guard = true;
        }
        if (flags.contains("Stable")) {
            this.dirv2Stable = true;
        }
        if (flags.contains("Named")) {
            this.dirv2Named = true;
        }
        if (flags.contains("V2Dir")) {
            this.dirv2V2dir = true;
        }
        if (flags.contains("Valid")) {
            this.dirv2Valid = true;
        }
        if (flags.contains("HSDir")) {
            this.dirv2HSDir = true;
        }
    }

    public RouterImpl cloneReliable() throws RuntimeException {
        try {
            return (RouterImpl)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    private RouterExitPolicy[] parseExitPolicy(String routerDescriptor) {
        ArrayList<RouterExitPolicyImpl> epList = new ArrayList<RouterExitPolicyImpl>(30);
        Pattern p = Pattern.compile("^(accept|reject) (.*?):(.*?)$", 43);
        Matcher m = p.matcher(routerDescriptor);
        for (int nr = 0; m.find() && nr < 300; ++nr) {
            int epHiPort;
            int epLoPort;
            boolean epAccept = m.group(1).equals("accept");
            String network = m.group(2);
            long epIp = 0L;
            long epNetmask = 0L;
            if (!network.equals("*")) {
                int slash = network.indexOf("/");
                if (slash >= 0) {
                    epIp = Encoding.dottedNotationToBinary(network.substring(0, slash));
                    String netmask = network.substring(slash + 1);
                    epNetmask = netmask.indexOf(".") > -1 ? Encoding.dottedNotationToBinary(netmask) : 0xFFFFFFFFL << 32 - Integer.parseInt(netmask) & 0xFFFFFFFFL;
                } else {
                    epIp = Encoding.dottedNotationToBinary(network);
                    epNetmask = -1L;
                }
            }
            epIp &= epNetmask;
            if (m.group(3).equals("*")) {
                epLoPort = 0;
                epHiPort = 65535;
            } else {
                int dash = m.group(3).indexOf("-");
                if (dash > 0) {
                    epLoPort = Integer.parseInt(m.group(3).substring(0, dash));
                    epHiPort = Integer.parseInt(m.group(3).substring(dash + 1));
                } else {
                    epHiPort = epLoPort = Integer.parseInt(m.group(3));
                }
            }
            epList.add(new RouterExitPolicyImpl(epAccept, epIp, epNetmask, epLoPort, epHiPort));
        }
        return epList.toArray(new RouterExitPolicy[epList.size()]);
    }

    public static Map<Fingerprint, RouterImpl> parseRouterDescriptors(String routerDescriptors) {
        long timeStart = System.currentTimeMillis();
        HashMap<Fingerprint, RouterImpl> result = new HashMap<Fingerprint, RouterImpl>();
        Pattern p = Pattern.compile("^(router.*?END SIGNATURE-----)", 43);
        Matcher m = p.matcher(routerDescriptors);
        while (m.find()) {
            try {
                String singleDescriptor = m.group(1);
                singleDescriptor = new String(singleDescriptor);
                RouterImpl singleServer = new RouterImpl(singleDescriptor);
                result.put(singleServer.fingerprint, singleServer);
            }
            catch (TorException e) {
                LOG.info("got TorException while parsing RouterDescriptor", (Throwable)e);
            }
            catch (Exception e) {
                LOG.info("unexpected exception", (Throwable)e);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("RouterImpl.parseRouterDescriptors took " + (System.currentTimeMillis() - timeStart) + " ms");
        }
        return result;
    }

    private void parseRouterDescriptor(String routerDescriptor) throws TorException {
        long timeStart = System.currentTimeMillis();
        this.routerDescriptor = routerDescriptor;
        String[] tmpLine = routerDescriptor.split("\n");
        Map<RouterDescriptorFormatKeys, Integer> keysToFind = RouterDescriptorFormatKeys.getAllKeysAsMap();
        MessageDigest mdMessage = null;
        boolean runMd = false;
        StringBuffer exitPolicyString = new StringBuffer();
        for (int i = 0; i < tmpLine.length; ++i) {
            if (mdMessage == null && tmpLine[i].startsWith("router ")) {
                mdMessage = Encryption.getMessagesDigest();
                runMd = true;
            }
            if (runMd) {
                mdMessage.update((tmpLine[i] + "\n").getBytes());
                if ("router-signature".equals(tmpLine[i])) {
                    runMd = false;
                }
            }
            if (tmpLine[i].startsWith("opt")) {
                tmpLine[i] = tmpLine[i].substring(4);
            }
            String[] tmpElements = tmpLine[i].split(" ");
            Iterator<Map.Entry<RouterDescriptorFormatKeys, Integer>> it = keysToFind.entrySet().iterator();
            block32: while (it.hasNext()) {
                Map.Entry<RouterDescriptorFormatKeys, Integer> entry = it.next();
                RouterDescriptorFormatKeys key = entry.getKey();
                if (!tmpLine[i].startsWith(key.getValue())) continue;
                if (entry.getValue() == 1) {
                    it.remove();
                } else {
                    entry.setValue(entry.getValue() - 1);
                }
                switch (key) {
                    case ROUTER_INFO: {
                        this.nickname = tmpElements[1];
                        this.hostname = tmpElements[2];
                        this.orPort = Integer.parseInt(tmpElements[3]);
                        this.socksPort = Integer.parseInt(tmpElements[4]);
                        this.dirPort = Integer.parseInt(tmpElements[5]);
                        continue block32;
                    }
                    case PLATFORM: {
                        this.platform = tmpLine[i].substring("platform".length() + 1);
                        continue block32;
                    }
                    case FINGERPRINT: {
                        try {
                            this.fingerprint = new FingerprintImpl(DatatypeConverter.parseHexBinary((String)tmpLine[i].substring("fingerprint".length()).replaceAll(" ", "")));
                            continue block32;
                        }
                        catch (Exception e) {
                            LOG.debug("got Exception while parsing fingerprint : {}", (Object)e, (Object)e);
                            throw new TorException("Server " + this.nickname + " skipped as router", e);
                        }
                    }
                    case PUBLISHED: {
                        this.published = Util.parseUtcTimestamp(tmpElements[1] + " " + tmpElements[2]).getTime();
                        this.validUntil = this.published + 86400000L;
                        continue block32;
                    }
                    case UPTIME: {
                        this.uptime = Integer.parseInt(tmpElements[1]);
                        continue block32;
                    }
                    case BANDWIDTH: {
                        this.bandwidthAvg = Integer.parseInt(tmpElements[1]);
                        this.bandwidthBurst = Integer.parseInt(tmpElements[2]);
                        this.bandwidthObserved = Integer.parseInt(tmpElements[3]);
                        continue block32;
                    }
                    case CONTACT: {
                        this.contact = tmpLine[i].substring("contact".length() + 1);
                        continue block32;
                    }
                    case FAMILY: {
                        for (int n = 1; n < tmpElements.length; ++n) {
                            if (tmpElements[n].startsWith("$")) {
                                this.family.add(new FingerprintImpl(DatatypeConverter.parseHexBinary((String)tmpElements[n].substring(1, 21))));
                                continue;
                            }
                            LOG.debug("skipping family member {}", (Object)tmpElements[n]);
                        }
                    }
                    case HIBERNATING: {
                        continue block32;
                    }
                    case HIDDEN_SERVICE_DIR: {
                        continue block32;
                    }
                    case PROTOCOLS: {
                        continue block32;
                    }
                    case EXTRA_INFO_DIGEST: {
                        continue block32;
                    }
                    case CACHES_EXTRA_INFO: {
                        continue block32;
                    }
                    case NTOR_ONION_KEY: {
                        continue block32;
                    }
                    case ONION_KEY: {
                        StringBuffer tmpOnionKey = new StringBuffer();
                        ++i;
                        while (!tmpLine[i].contains("END RSA PUBLIC KEY")) {
                            tmpOnionKey.append(tmpLine[i]).append('\n');
                            ++i;
                        }
                        tmpOnionKey.append(tmpLine[i]).append('\n');
                        mdMessage.update(tmpOnionKey.toString().getBytes());
                        this.onionKey = Encryption.extractPublicRSAKey(tmpOnionKey.toString());
                        continue block32;
                    }
                    case SIGNING_KEY: {
                        StringBuffer tmpSigningKey = new StringBuffer();
                        ++i;
                        while (!tmpLine[i].contains("END RSA PUBLIC KEY")) {
                            tmpSigningKey.append(tmpLine[i]).append('\n');
                            ++i;
                        }
                        tmpSigningKey.append(tmpLine[i]).append('\n');
                        mdMessage.update(tmpSigningKey.toString().getBytes());
                        this.signingKey = Encryption.extractPublicRSAKey(tmpSigningKey.toString());
                        continue block32;
                    }
                    case ROUTER_SIGNATURE: {
                        StringBuffer tmpSignature = new StringBuffer();
                        i += 2;
                        while (!tmpLine[i].contains("END SIGNATURE")) {
                            tmpSignature.append(tmpLine[i]);
                            ++i;
                        }
                        while (tmpSignature.length() % 4 != 0) {
                            tmpSignature.append('=');
                        }
                        this.routerSignature = DatatypeConverter.parseBase64Binary((String)tmpSignature.toString());
                        continue block32;
                    }
                    case REJECT: {
                        exitPolicyString.append(tmpLine[i]).append('\n');
                        continue block32;
                    }
                    case ACCEPT: {
                        exitPolicyString.append(tmpLine[i]).append('\n');
                        continue block32;
                    }
                    case ALLOW_SINGLE_HOP_EXITS: {
                        continue block32;
                    }
                    case IPV6_POLICY: {
                        continue block32;
                    }
                    case OR_ADDRESS: {
                        continue block32;
                    }
                }
                LOG.debug("it seems that we are not reading the following key : {}", (Object)key.getValue());
            }
        }
        try {
            byte[] pkcs = Encryption.getPKCS1EncodingFromRSAPublicKey(this.signingKey);
            byte[] keyHash = Encryption.getDigest(pkcs);
            if (!new FingerprintImpl(keyHash).equals(this.fingerprint)) {
                throw new TorException("Server " + this.nickname + " doesn't verify signature vs fingerprint");
            }
        }
        catch (TorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TorException("Server " + this.nickname + " doesn't verify signature vs fingerprint", e);
        }
        byte[] sha1Digest = mdMessage.digest();
        if (!Encryption.verifySignatureWithHash(this.routerSignature, this.signingKey, sha1Digest)) {
            LOG.info("Server -> router-signature check failed for " + this.nickname);
            throw new TorException("Server " + this.nickname + ": description signature verification failed");
        }
        this.exitpolicy = this.parseExitPolicy(exitPolicyString.toString());
        try {
            this.address = InetAddress.getByName(this.hostname);
        }
        catch (UnknownHostException e) {
            throw new TorException("Server.ParseRouterDescriptor: Unresolvable hostname " + this.hostname);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("RouterImpl.parseRouterDescriptor took " + (System.currentTimeMillis() - timeStart) + " ms");
        }
    }

    private void updateServerRanking() {
        float rankingFromDirectory = ((float)Math.min(1, this.uptime / 86400) + Math.min(1.0f, ((float)this.bandwidthAvg * 0.6f + (float)this.bandwidthObserved * 0.39999998f) / 2097152.0f)) / 2.0f;
        this.rankingIndex = this.rankingIndex < 0.0f ? rankingFromDirectory : rankingFromDirectory * (1.0f - TorConfig.rankingTransferPerServerUpdate) + this.rankingIndex * TorConfig.rankingTransferPerServerUpdate;
    }

    float getRefinedRankingIndex(float p) {
        return this.rankingIndex * p + TorConfig.rankingIndexEffect * (1.0f - p);
    }

    public void punishRanking() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Punishing " + this.toLongString());
        }
        this.rankingIndex *= 0.75f;
    }

    public boolean exitPolicyAccepts(InetAddress addr, int port) {
        long ip;
        if (addr != null) {
            byte[] temp1 = addr.getAddress();
            long[] temp = new long[4];
            for (int i = 0; i < 4; ++i) {
                temp[i] = temp1[i];
                if (temp[i] >= 0L) continue;
                temp[i] = 256L + temp[i];
            }
            ip = temp[0] << 24 | temp[1] << 16 | temp[2] << 8 | temp[3];
        } else {
            if (port == 0) {
                return true;
            }
            ip = 0xFFFFFFFFL;
        }
        for (int i = 0; i < this.exitpolicy.length; ++i) {
            if (this.exitpolicy[i].getLoPort() > port || this.exitpolicy[i].getHiPort() < port || this.exitpolicy[i].getIp() != (ip & this.exitpolicy[i].getNetmask())) continue;
            return this.exitpolicy[i].isAccept();
        }
        return false;
    }

    protected boolean isDirServer() {
        return this.dirPort > 0;
    }

    @Override
    public boolean isExitNode() {
        for (RouterExitPolicy singleExitPolicy : this.exitpolicy) {
            if (!singleExitPolicy.isAccept()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("router=" + this.nickname);
        sb.append("," + this.hostname);
        sb.append("," + this.fingerprint);
        sb.append("," + this.platform);
        return sb.toString();
    }

    public String toLongString() {
        StringBuffer sb = new StringBuffer();
        sb.append("---- ").append(this.nickname).append(" (").append(this.contact).append(")\n");
        sb.append("hostname:").append(this.hostname).append('\n');
        sb.append("or port:").append(this.orPort).append('\n');
        sb.append("socks port:").append(this.socksPort).append('\n');
        sb.append("dirserver port:").append(this.dirPort).append('\n');
        sb.append("platform:").append(this.platform).append('\n');
        sb.append("published:").append(new Date(this.published)).append('\n');
        sb.append("uptime:").append(this.uptime).append('\n');
        sb.append("rankingIndex:").append(this.rankingIndex).append('\n');
        sb.append("bandwidth: ").append(this.bandwidthAvg).append(' ').append(this.bandwidthBurst).append(' ').append(this.bandwidthObserved).append('\n');
        sb.append("fingerprint:").append(this.fingerprint).append('\n');
        sb.append("validUntil:").append(new Date(this.validUntil)).append('\n');
        sb.append("onion key:").append(this.onionKey).append('\n');
        sb.append("signing key:").append(this.signingKey).append('\n');
        sb.append("signature:").append(DatatypeConverter.printHexBinary((byte[])this.routerSignature)).append('\n');
        sb.append("exit policies:").append('\n');
        for (int i = 0; i < this.exitpolicy.length; ++i) {
            sb.append("  ").append(this.exitpolicy[i]).append('\n');
        }
        return sb.toString();
    }

    public boolean isValid() {
        return this.validUntil > System.currentTimeMillis();
    }

    public TcpipNetAddress getDirAddress() {
        byte[] ipaddress = this.address.getAddress();
        if (ipaddress != null) {
            return new TcpipNetAddress(ipaddress, this.dirPort);
        }
        return new TcpipNetAddress(this.address.getHostName(), this.dirPort);
    }

    public TcpipNetAddress getOrAddress() {
        byte[] ipaddress = this.address.getAddress();
        if (ipaddress != null) {
            return new TcpipNetAddress(ipaddress, this.orPort);
        }
        return new TcpipNetAddress(this.address.getHostName(), this.orPort);
    }

    @Override
    public String getNickname() {
        return this.nickname;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public InetAddress getAddress() {
        return this.address;
    }

    @Override
    public String getCountryCode() {
        return this.countryCode;
    }

    @Override
    public int getOrPort() {
        return this.orPort;
    }

    @Override
    public int getSocksPort() {
        return this.socksPort;
    }

    @Override
    public int getDirPort() {
        return this.dirPort;
    }

    @Override
    public int getBandwidthAvg() {
        return this.bandwidthAvg;
    }

    @Override
    public int getBandwidthBurst() {
        return this.bandwidthBurst;
    }

    @Override
    public int getBandwidthObserved() {
        return this.bandwidthObserved;
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    @Override
    public long getPublished() {
        return this.published;
    }

    @Override
    public Fingerprint getFingerprint() {
        return this.fingerprint;
    }

    public Fingerprint getV3Ident() {
        return this.v3ident;
    }

    @Override
    public int getUptime() {
        return this.uptime;
    }

    @Override
    public RSAPublicKey getOnionKey() {
        return this.onionKey;
    }

    @Override
    public RSAPublicKey getSigningKey() {
        return this.signingKey;
    }

    @Override
    public RouterExitPolicy[] getExitpolicy() {
        return this.exitpolicy;
    }

    @Override
    public String getContact() {
        return this.contact;
    }

    @Override
    public Set<Fingerprint> getFamily() {
        return this.family;
    }

    @Override
    public long getValidUntil() {
        return this.validUntil;
    }

    @Override
    public long getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    public boolean isDirv2Authority() {
        return this.dirv2Authority;
    }

    @Override
    public boolean isDirv2Exit() {
        return this.dirv2Exit;
    }

    @Override
    public boolean isDirv2Fast() {
        return this.dirv2Fast;
    }

    @Override
    public boolean isDirv2Guard() {
        return this.dirv2Guard;
    }

    @Override
    public boolean isDirv2Named() {
        return this.dirv2Named;
    }

    @Override
    public boolean isDirv2Stable() {
        return this.dirv2Stable;
    }

    @Override
    public boolean isDirv2Running() {
        return this.dirv2Running;
    }

    @Override
    public boolean isDirv2Valid() {
        return this.dirv2Valid;
    }

    @Override
    public boolean isDirv2V2dir() {
        return this.dirv2V2dir;
    }

    public boolean isDirv2HSDir() {
        return this.dirv2HSDir;
    }

    @Override
    public float getRankingIndex() {
        return this.rankingIndex;
    }

    public String getRouterDescriptor() {
        return this.routerDescriptor;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + this.bandwidthAvg;
        result = 31 * result + this.bandwidthBurst;
        result = 31 * result + this.bandwidthObserved;
        result = 31 * result + (this.contact == null ? 0 : this.contact.hashCode());
        result = 31 * result + (this.countryCode == null ? 0 : this.countryCode.hashCode());
        result = 31 * result + this.dirPort;
        result = 31 * result + (this.dirv2Authority ? 1231 : 1237);
        result = 31 * result + (this.dirv2Exit ? 1231 : 1237);
        result = 31 * result + (this.dirv2Fast ? 1231 : 1237);
        result = 31 * result + (this.dirv2Guard ? 1231 : 1237);
        result = 31 * result + (this.dirv2HSDir ? 1231 : 1237);
        result = 31 * result + (this.dirv2Named ? 1231 : 1237);
        result = 31 * result + (this.dirv2Running ? 1231 : 1237);
        result = 31 * result + (this.dirv2Stable ? 1231 : 1237);
        result = 31 * result + (this.dirv2V2dir ? 1231 : 1237);
        result = 31 * result + (this.dirv2Valid ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.exitpolicy);
        result = 31 * result + (this.family == null ? 0 : this.family.hashCode());
        result = 31 * result + (this.fingerprint == null ? 0 : this.fingerprint.hashCode());
        result = 31 * result + (this.hostname == null ? 0 : this.hostname.hashCode());
        result = 31 * result + (int)this.lastUpdate;
        result = 31 * result + (this.nickname == null ? 0 : this.nickname.hashCode());
        result = 31 * result + (this.onionKey == null ? 0 : this.onionKey.hashCode());
        result = 31 * result + (this.onionKeyPrivate == null ? 0 : this.onionKeyPrivate.hashCode());
        result = 31 * result + this.orPort;
        result = 31 * result + (this.platform == null ? 0 : this.platform.hashCode());
        result = 31 * result + (int)this.published;
        result = 31 * result + Float.floatToIntBits(this.rankingIndex);
        result = 31 * result + (this.routerDescriptor == null ? 0 : this.routerDescriptor.hashCode());
        result = 31 * result + Arrays.hashCode(this.routerSignature);
        result = 31 * result + (this.signingKey == null ? 0 : this.signingKey.hashCode());
        result = 31 * result + (this.signingKeyPrivate == null ? 0 : this.signingKeyPrivate.hashCode());
        result = 31 * result + this.socksPort;
        result = 31 * result + this.uptime;
        result = 31 * result + (this.v3ident == null ? 0 : this.v3ident.hashCode());
        result = (int)((long)(31 * result) + this.validUntil);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouterImpl)) {
            return false;
        }
        RouterImpl other = (RouterImpl)obj;
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        if (this.bandwidthAvg != other.bandwidthAvg) {
            return false;
        }
        if (this.bandwidthBurst != other.bandwidthBurst) {
            return false;
        }
        if (this.bandwidthObserved != other.bandwidthObserved) {
            return false;
        }
        if (this.contact == null ? other.contact != null : !this.contact.equals(other.contact)) {
            return false;
        }
        if (this.countryCode == null ? other.countryCode != null : !this.countryCode.equals(other.countryCode)) {
            return false;
        }
        if (this.dirPort != other.dirPort) {
            return false;
        }
        if (this.dirv2Authority != other.dirv2Authority) {
            return false;
        }
        if (this.dirv2Exit != other.dirv2Exit) {
            return false;
        }
        if (this.dirv2Fast != other.dirv2Fast) {
            return false;
        }
        if (this.dirv2Guard != other.dirv2Guard) {
            return false;
        }
        if (this.dirv2HSDir != other.dirv2HSDir) {
            return false;
        }
        if (this.dirv2Named != other.dirv2Named) {
            return false;
        }
        if (this.dirv2Running != other.dirv2Running) {
            return false;
        }
        if (this.dirv2Stable != other.dirv2Stable) {
            return false;
        }
        if (this.dirv2V2dir != other.dirv2V2dir) {
            return false;
        }
        if (this.dirv2Valid != other.dirv2Valid) {
            return false;
        }
        if (!Arrays.equals(this.exitpolicy, other.exitpolicy)) {
            return false;
        }
        if (this.family == null ? other.family != null : !this.family.equals(other.family)) {
            return false;
        }
        if (this.fingerprint == null ? other.fingerprint != null : !this.fingerprint.equals(other.fingerprint)) {
            return false;
        }
        if (this.hostname == null ? other.hostname != null : !this.hostname.equals(other.hostname)) {
            return false;
        }
        if (this.lastUpdate != other.lastUpdate) {
            return false;
        }
        if (this.nickname == null ? other.nickname != null : !this.nickname.equals(other.nickname)) {
            return false;
        }
        if (this.onionKey == null ? other.onionKey != null : !this.onionKey.equals(other.onionKey)) {
            return false;
        }
        if (this.onionKeyPrivate == null ? other.onionKeyPrivate != null : !Arrays.equals(this.onionKeyPrivate.getEncoded(), other.onionKeyPrivate.getEncoded())) {
            return false;
        }
        if (this.orPort != other.orPort) {
            return false;
        }
        if (this.platform == null ? other.platform != null : !this.platform.equals(other.platform)) {
            return false;
        }
        if (this.published != other.published) {
            return false;
        }
        if (Float.floatToIntBits(this.rankingIndex) != Float.floatToIntBits(other.rankingIndex)) {
            return false;
        }
        if (this.routerDescriptor == null ? other.routerDescriptor != null : !this.routerDescriptor.equals(other.routerDescriptor)) {
            return false;
        }
        if (!Arrays.equals(this.routerSignature, other.routerSignature)) {
            return false;
        }
        if (this.signingKey == null ? other.signingKey != null : !Arrays.equals(this.signingKey.getEncoded(), other.signingKey.getEncoded())) {
            return false;
        }
        if (this.signingKeyPrivate == null ? other.signingKeyPrivate != null : !Arrays.equals(this.signingKeyPrivate.getEncoded(), other.signingKeyPrivate.getEncoded())) {
            return false;
        }
        if (this.socksPort != other.socksPort) {
            return false;
        }
        if (this.uptime != other.uptime) {
            return false;
        }
        if (this.v3ident == null ? other.v3ident != null : !this.v3ident.equals(other.v3ident)) {
            return false;
        }
        return this.validUntil == other.validUntil;
    }
}

