/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tor.directory;

import org.silvertunnel_ng.netlib.layer.tor.api.RouterExitPolicy;
import org.silvertunnel_ng.netlib.layer.tor.util.Encoding;

public class RouterExitPolicyImpl
implements RouterExitPolicy,
Cloneable {
    private final boolean accept;
    private final long ip;
    private final long netmask;
    private final int loPort;
    private final int hiPort;

    public RouterExitPolicyImpl(boolean accept, long ip, long netmask, int loPort, int hiPort) {
        this.accept = accept;
        this.ip = ip;
        this.netmask = netmask;
        this.loPort = loPort;
        this.hiPort = hiPort;
    }

    @Override
    public RouterExitPolicy cloneReliable() throws RuntimeException {
        try {
            return (RouterExitPolicy)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        return this.accept + " " + Encoding.toHex(this.ip) + "/" + Encoding.toHex(this.netmask) + ":" + this.loPort + "-" + this.hiPort;
    }

    @Override
    public boolean isAccept() {
        return this.accept;
    }

    @Override
    public long getIp() {
        return this.ip;
    }

    @Override
    public long getNetmask() {
        return this.netmask;
    }

    @Override
    public int getLoPort() {
        return this.loPort;
    }

    @Override
    public int getHiPort() {
        return this.hiPort;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accept ? 1231 : 1237);
        result = 31 * result + this.hiPort;
        result = 31 * result + (int)(this.ip ^ this.ip >>> 32);
        result = 31 * result + this.loPort;
        result = 31 * result + (int)(this.netmask ^ this.netmask >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouterExitPolicyImpl)) {
            return false;
        }
        RouterExitPolicyImpl other = (RouterExitPolicyImpl)obj;
        if (this.accept != other.accept) {
            return false;
        }
        if (this.hiPort != other.hiPort) {
            return false;
        }
        if (this.ip != other.ip) {
            return false;
        }
        if (this.loPort != other.loPort) {
            return false;
        }
        return this.netmask == other.netmask;
    }
}

