/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tor.directory;

import java.io.UnsupportedEncodingException;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import org.silvertunnel_ng.netlib.layer.tor.directory.RendezvousServiceDescriptorKeyValues;
import org.silvertunnel_ng.netlib.layer.tor.directory.RendezvousServiceDescriptorUtil;
import org.silvertunnel_ng.netlib.layer.tor.directory.SDIntroductionPoint;
import org.silvertunnel_ng.netlib.layer.tor.util.Encoding;
import org.silvertunnel_ng.netlib.layer.tor.util.Encryption;
import org.silvertunnel_ng.netlib.layer.tor.util.TorException;
import org.silvertunnel_ng.netlib.layer.tor.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RendezvousServiceDescriptor {
    private static final Logger LOG = LoggerFactory.getLogger(RendezvousServiceDescriptor.class);
    private static Pattern serviceDescriptorStringPattern;
    private static final long MAX_SERVICE_DESCRIPTOR_AGE_IN_MS = 172800000L;
    private byte[] descriptorId;
    private String version = "2";
    private RSAPublicKey permanentPublicKey;
    private String z;
    private byte[] secretIdPart;
    private Long publicationTime;
    private Collection<String> protocolVersions = Arrays.asList("2");
    private Collection<SDIntroductionPoint> introductionPoints;
    private String url;
    private PrivateKey privateKey;
    private static final String DEFAULT_SERVICE_DESCRIPTOR_VERSION = "2";

    public String toServiceDescriptorString() {
        StringBuffer protocolVersionsStrBuf = new StringBuffer(10);
        boolean firstProtocolVersion = true;
        for (String protocolVersion : this.protocolVersions) {
            if (!firstProtocolVersion) {
                protocolVersionsStrBuf.append(",");
            }
            protocolVersionsStrBuf.append(protocolVersion);
            firstProtocolVersion = false;
        }
        String protocolVersionsStr = protocolVersionsStrBuf.toString();
        String introductionPointsStr = SDIntroductionPoint.formatMultipleIntroductionPoints(this.introductionPoints) + "\n";
        byte[] introductionPointsBytes = null;
        try {
            introductionPointsBytes = introductionPointsStr.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.debug("got UnsupportedEncodingException : {}", (Object)e.getMessage(), (Object)e);
        }
        int BASE64_COLUMN_WITH = 64;
        String introductionPointsBase64 = Encoding.toBase64(introductionPointsBytes, 64);
        String dataToSignStr = "rendezvous-service-descriptor " + Encoding.toBase32(this.descriptorId) + "\n" + "version " + this.version + "\n" + "permanent-key\n" + Encryption.getPEMStringFromRSAPublicKey(this.permanentPublicKey) + "secret-id-part " + Encoding.toBase32(this.secretIdPart) + "\n" + "publication-time " + Util.formatUtcTimestamp(this.publicationTime) + "\n" + "protocol-versions " + protocolVersionsStr + "\n" + "introduction-points\n" + "-----BEGIN MESSAGE-----\n" + introductionPointsBase64 + "-----END MESSAGE-----\n" + "signature\n";
        String signatureStr = "";
        if (this.privateKey != null) {
            byte[] dataToSign = null;
            try {
                dataToSign = dataToSignStr.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOG.warn("unexpected", (Throwable)e);
            }
            byte[] signature = Encryption.signData(dataToSign, this.privateKey);
            signatureStr = Encoding.toBase64(signature, 64);
        }
        return dataToSignStr + "-----BEGIN SIGNATURE-----\n" + signatureStr + "-----END SIGNATURE-----\n";
    }

    public RendezvousServiceDescriptor(String hiddenServicePermanentIdBase32, int replica, long now, RSAPublicKey publicKey, RSAPrivateKey privateKey, Collection<SDIntroductionPoint> givenIntroPoints) throws TorException {
        this(DEFAULT_SERVICE_DESCRIPTOR_VERSION, hiddenServicePermanentIdBase32, replica, now, publicKey, privateKey, givenIntroPoints);
    }

    public RendezvousServiceDescriptor(String version, String hiddenServicePermanentIdBase32, int replica, Long publicationTime, RSAPublicKey publicKey, RSAPrivateKey privateKey, Collection<SDIntroductionPoint> givenIntroPoints) throws TorException {
        if (!DEFAULT_SERVICE_DESCRIPTOR_VERSION.equals(version)) {
            throw new TorException("not implemented: service descriptors of version != 2 are not supported, yet");
        }
        this.version = version;
        RendezvousServiceDescriptorKeyValues calculatedValues = RendezvousServiceDescriptorUtil.getRendezvousDescriptorId(hiddenServicePermanentIdBase32, replica, publicationTime);
        this.descriptorId = calculatedValues.getDescriptorId();
        this.publicationTime = publicationTime;
        this.permanentPublicKey = publicKey;
        this.privateKey = privateKey;
        this.updateURL();
        this.introductionPoints = givenIntroPoints;
        this.secretIdPart = calculatedValues.getSecretIdPart();
    }

    protected RendezvousServiceDescriptor(String serviceDescriptorStr, Long currentDate) throws TorException {
        this(serviceDescriptorStr, currentDate, true);
    }

    protected RendezvousServiceDescriptor(String serviceDescriptorStr, Long currentTime, boolean checkSignature) throws TorException {
        try {
            Matcher m = serviceDescriptorStringPattern.matcher(serviceDescriptorStr);
            m.find();
            String descriptorIdBase32 = m.group(2);
            this.descriptorId = Encoding.parseBase32(descriptorIdBase32);
            this.version = m.group(3);
            String permanentKeyStr = m.group(4);
            this.permanentPublicKey = Encryption.extractPublicRSAKey(permanentKeyStr);
            this.z = RendezvousServiceDescriptorUtil.calculateZFromPublicKey(this.permanentPublicKey);
            String secretIdPartBase32 = m.group(5);
            this.secretIdPart = Encoding.parseBase32(secretIdPartBase32);
            this.publicationTime = Util.parseUtcTimestampAsLong(m.group(6));
            if (!this.isPublicationTimeValid(currentTime)) {
                throw new TorException("invalid publication-time=" + this.publicationTime);
            }
            String protocolVersionsStr = m.group(7);
            this.protocolVersions = Arrays.asList(protocolVersionsStr.split(","));
            String introductionPointsBase64 = m.group(8);
            while (introductionPointsBase64.length() % 4 != 0) {
                introductionPointsBase64 = introductionPointsBase64 + "=";
            }
            byte[] introductionPointsBytes = DatatypeConverter.parseBase64Binary((String)introductionPointsBase64);
            String introductionPointsStr = new String(introductionPointsBytes, "UTF-8");
            this.introductionPoints = SDIntroductionPoint.parseMultipleIntroductionPoints(introductionPointsStr);
            if (LOG.isDebugEnabled()) {
                LOG.debug("ips = " + this.introductionPoints);
            }
            String signatureStr = m.group(9);
            while (signatureStr.length() % 4 != 0) {
                signatureStr = signatureStr + "=";
            }
            byte[] signature = DatatypeConverter.parseBase64Binary((String)signatureStr);
            String signedDataStr = m.group(1);
            byte[] signedData = null;
            try {
                signedData = signedDataStr.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOG.warn("unexpected", (Throwable)e);
            }
            if (checkSignature && !Encryption.verifySignature(signature, this.permanentPublicKey, signedData)) {
                throw new TorException("dirKeyCertification check failed");
            }
        }
        catch (TorException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.info("long log", (Throwable)e);
            throw new TorException("could not parse service descriptor:" + e);
        }
    }

    void updateSignature() throws TorException {
        throw new UnsupportedOperationException("not yet implemented");
    }

    byte[] toByteArray() {
        try {
            return this.toServiceDescriptorString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn("may not occur", (Throwable)e);
            return null;
        }
    }

    private void updateURL() {
        try {
            byte[] hash = Encryption.getDigest(Encryption.getPKCS1EncodingFromRSAPublicKey(this.permanentPublicKey));
            byte[] h1 = new byte[10];
            System.arraycopy(hash, 0, h1, 0, 10);
            this.url = Encoding.toBase32(h1) + ".onion";
        }
        catch (Exception e) {
            LOG.error("ServiceDescriptor.updateURL(): " + e.getMessage(), (Throwable)e);
            this.url = null;
        }
    }

    public boolean isPublicationTimeValid(Long currentTime) {
        if (this.publicationTime == null) {
            return false;
        }
        return this.publicationTime <= currentTime && currentTime - this.publicationTime <= 172800000L;
    }

    public boolean isPublicationTimeValid() {
        return this.isPublicationTimeValid(System.currentTimeMillis());
    }

    public String toString() {
        return "RendezvousServiceDescriptor=(descriptorIdBase32=" + Encoding.toBase32(this.descriptorId) + ",publicationTime=" + this.publicationTime + ",introductionPoints=" + this.introductionPoints + ")";
    }

    public String getURL() {
        return this.url;
    }

    public RSAPublicKey getPermamentPublicKey() {
        return this.permanentPublicKey;
    }

    public byte[] getDescriptorId() {
        return this.descriptorId;
    }

    public String getVersion() {
        return this.version;
    }

    public RSAPublicKey getPermanentPublicKey() {
        return this.permanentPublicKey;
    }

    public String getZ() {
        return this.z;
    }

    public byte[] getSecretIdPart() {
        return this.secretIdPart;
    }

    public Long getPublicationTime() {
        return this.publicationTime;
    }

    public Collection<String> getProtocolVersions() {
        return this.protocolVersions;
    }

    public Collection<SDIntroductionPoint> getIntroductionPoints() {
        return this.introductionPoints;
    }

    static {
        try {
            serviceDescriptorStringPattern = Pattern.compile("^(rendezvous-service-descriptor ([a-z2-7]+)\nversion (\\d+)\npermanent-key\n(-----BEGIN RSA PUBLIC KEY-----\n.*?-----END RSA PUBLIC KEY-----)\nsecret-id-part ([a-z2-7]+)\npublication-time (\\S+ \\S+)\nprotocol-versions (\\d+(?:,\\d+)?(?:,\\d+)?(?:,\\d+)?(?:,\\d+)?)\nintroduction-points\n-----BEGIN MESSAGE-----\n(.*?)-----END MESSAGE-----\nsignature\n)-----BEGIN SIGNATURE-----\n(.*?)-----END SIGNATURE-----", 43);
        }
        catch (Exception e) {
            LOG.error("could not initialze class RendezvousServiceDescriptor", (Throwable)e);
        }
    }
}

