/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tor.directory;

import java.util.Arrays;
import javax.xml.bind.DatatypeConverter;
import org.silvertunnel_ng.netlib.layer.tor.api.Fingerprint;
import org.silvertunnel_ng.netlib.layer.tor.util.Parsing;

public class FingerprintImpl
implements Fingerprint,
Cloneable {
    private byte[] bytes;
    private String hexCache;

    public FingerprintImpl(String identityKeyBase64) {
        String b64fp = identityKeyBase64;
        while (b64fp.length() % 4 != 0) {
            b64fp = b64fp + "=";
        }
        this.setIdentityKey(DatatypeConverter.parseBase64Binary((String)b64fp));
    }

    public FingerprintImpl(byte[] identityKey) {
        this.setIdentityKey(identityKey);
    }

    private void setIdentityKey(byte[] identityKey) {
        if (identityKey == null) {
            throw new NullPointerException();
        }
        if (identityKey.length < 4) {
            throw new IllegalArgumentException("invalid array length=" + identityKey.length);
        }
        this.bytes = identityKey;
    }

    @Override
    public String getHex() {
        if (this.hexCache == null) {
            this.hexCache = Parsing.renderFingerprint(this.bytes, false);
        }
        return this.hexCache;
    }

    @Override
    public String getHexWithSpaces() {
        return Parsing.renderFingerprint(this.bytes, true);
    }

    @Override
    public byte[] getBytes() {
        byte[] result = new byte[this.bytes.length];
        System.arraycopy(this.bytes, 0, result, 0, this.bytes.length);
        return result;
    }

    @Override
    public String toString() {
        return "fingerprintHexWithSpaces=" + this.getHexWithSpaces();
    }

    @Override
    public int hashCode() {
        return this.bytes[0] * 256 + this.bytes[1] * 256 + this.bytes[2];
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof FingerprintImpl)) {
            return false;
        }
        FingerprintImpl o = (FingerprintImpl)obj;
        return Arrays.equals(this.bytes, o.bytes);
    }

    @Override
    public int compareTo(Fingerprint other) {
        return this.getHex().compareTo(other.getHex());
    }

    @Override
    public Fingerprint cloneReliable() throws RuntimeException {
        try {
            return (Fingerprint)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

