/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tor.directory;

import org.silvertunnel_ng.netlib.layer.tor.common.TorConfig;
import org.silvertunnel_ng.netlib.layer.tor.directory.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DirectoryManagerThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(DirectoryManagerThread.class);
    private static final int MILLISEC = 1000;
    static final int INTERVAL_S = 3;
    private boolean stopped = false;
    private final Directory directory;
    private long currentTimeMillis;
    private long dirNextUpdateTimeMillis;

    public DirectoryManagerThread(Directory directory) {
        this.directory = directory;
        this.dirNextUpdateTimeMillis = this.currentTimeMillis;
        this.setName(this.getClass().getName());
        this.setDaemon(true);
        this.start();
    }

    private void updateDirectory() {
        this.currentTimeMillis = System.currentTimeMillis();
        if (this.currentTimeMillis > this.dirNextUpdateTimeMillis || this.directory.getValidRoutersByFingerprint().isEmpty()) {
            LOG.debug("DirectoryManagerThread.updateDirectory: updating directory");
            this.dirNextUpdateTimeMillis = this.currentTimeMillis + (long)(TorConfig.getIntervalDirectoryRefresh() * 60 * 1000);
            this.directory.refreshListOfServers();
        }
    }

    @Override
    public void run() {
        while (!this.stopped) {
            try {
                this.updateDirectory();
                long sleepTime = this.dirNextUpdateTimeMillis - System.currentTimeMillis();
                if (sleepTime <= 0L) {
                    sleepTime = 3000L;
                }
                DirectoryManagerThread.sleep(sleepTime);
            }
            catch (Exception e) {
                this.stopped = true;
                LOG.debug("got Exception : {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public void setStopped(boolean stopped) {
        this.stopped = stopped;
    }
}

