/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tor.directory;

import java.security.KeyPair;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.http.conn.util.InetAddressUtils;
import org.silvertunnel_ng.netlib.api.NetLayer;
import org.silvertunnel_ng.netlib.api.util.IpNetAddress;
import org.silvertunnel_ng.netlib.api.util.TcpipNetAddress;
import org.silvertunnel_ng.netlib.layer.control.ControlNetLayer;
import org.silvertunnel_ng.netlib.layer.control.ControlParameters;
import org.silvertunnel_ng.netlib.layer.tor.api.Fingerprint;
import org.silvertunnel_ng.netlib.layer.tor.api.TorNetLayerStatus;
import org.silvertunnel_ng.netlib.layer.tor.common.TCPStreamProperties;
import org.silvertunnel_ng.netlib.layer.tor.common.TorConfig;
import org.silvertunnel_ng.netlib.layer.tor.directory.AuthorityKeyCertificates;
import org.silvertunnel_ng.netlib.layer.tor.directory.AuthorityServers;
import org.silvertunnel_ng.netlib.layer.tor.directory.DescriptorFetcherThread;
import org.silvertunnel_ng.netlib.layer.tor.directory.DirectoryConsensus;
import org.silvertunnel_ng.netlib.layer.tor.directory.FingerprintImpl;
import org.silvertunnel_ng.netlib.layer.tor.directory.RouterImpl;
import org.silvertunnel_ng.netlib.layer.tor.directory.RouterStatusDescription;
import org.silvertunnel_ng.netlib.layer.tor.util.NetLayerStatusAdmin;
import org.silvertunnel_ng.netlib.layer.tor.util.Parsing;
import org.silvertunnel_ng.netlib.layer.tor.util.TorException;
import org.silvertunnel_ng.netlib.tool.SimpleHttpClientCompressed;
import org.silvertunnel_ng.netlib.util.StringStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Directory {
    private static final Logger LOG = LoggerFactory.getLogger(Directory.class);
    public static final int RETRIES_ON_RECURSIVE_ROUTE_BUILD = 10;
    static final int FETCH_THREAD_QUERY_TIME_MS = 2000;
    private static final String STORAGEKEY_AUTHORITY_KEY_CERTIFICATES_TXT = "authority-key-certificates.txt";
    private static final String STORAGEKEY_DIRECTORY_CACHED_CONSENSUS_TXT = "directory-cached-consensus.txt";
    private static final String STORAGEKEY_DIRECTORY_CACHED_ROUTER_DESCRIPTORS_TXT = "directory-cached-router-descriptors.txt";
    private final StringStorage stringStorage;
    public NetLayer lowerDirConnectionNetLayer;
    private final Map<Fingerprint, RouterImpl> allFingerprintsRouters = Collections.synchronizedMap(new HashMap());
    private DirectoryConsensus directoryConsensus;
    private int numOfRunningRoutersInDirectoryConsensus = 0;
    private Map<Fingerprint, RouterImpl> validRoutersByFingerprint = new HashMap<Fingerprint, RouterImpl>();
    private Map<Fingerprint, RouterImpl> routersWithExit = new HashMap<Fingerprint, RouterImpl>();
    private Map<Fingerprint, RouterImpl> guardRouters = new HashMap<Fingerprint, RouterImpl>();
    private Map<Fingerprint, RouterImpl> fastRouters = new HashMap<Fingerprint, RouterImpl>();
    private Map<Fingerprint, RouterImpl> stableRouters = new HashMap<Fingerprint, RouterImpl>();
    private Map<Fingerprint, RouterImpl> stableAndFastRouters = new HashMap<Fingerprint, RouterImpl>();
    private final Map<String, HashSet<Fingerprint>> addressNeighbours;
    private final Map<String, HashSet<Fingerprint>> countryNeighbours;
    private final HashSet<Fingerprint> excludedNodesByConfig;
    private final SecureRandom rnd;
    private volatile boolean updateRunning = false;
    private int updateCounter = 0;
    private AuthorityKeyCertificates authorityKeyCertificates;
    private final NetLayerStatusAdmin statusAdmin;
    private static final long ONE_DAY_IN_MS = 86400000L;
    private static final Pattern IPCLASSC_PATTERN = Parsing.compileRegexPattern("(.*)\\.");
    private static final int MIN_NUM_OF_DIRS = 5;
    private static final int MIN_NUM_OF_CACHE_DIRS = 5;

    public Directory(StringStorage stringStorage, NetLayer lowerDirConnectionNetLayer, KeyPair dirServerKeys, NetLayerStatusAdmin statusAdmin) {
        this.stringStorage = stringStorage;
        this.lowerDirConnectionNetLayer = lowerDirConnectionNetLayer;
        this.statusAdmin = statusAdmin;
        ControlParameters cp = ControlParameters.createTypicalFileTransferParameters();
        cp.setConnectTimeoutMillis(10000L);
        cp.setOverallTimeoutMillis(30000L);
        cp.setInputMaxBytes(0x3200000L);
        cp.setThroughputTimeframeMinBytes(15360L);
        cp.setThroughputTimeframeMillis(15000L);
        this.lowerDirConnectionNetLayer = new ControlNetLayer(lowerDirConnectionNetLayer, cp);
        this.addressNeighbours = new HashMap<String, HashSet<Fingerprint>>();
        this.countryNeighbours = new HashMap<String, HashSet<Fingerprint>>();
        this.rnd = new SecureRandom();
        this.excludedNodesByConfig = new HashSet();
        Set<byte[]> avoidedNodeFingerprints = TorConfig.getAvoidedNodeFingerprints();
        for (byte[] fingerprint : avoidedNodeFingerprints) {
            this.excludedNodesByConfig.add(new FingerprintImpl(fingerprint));
        }
    }

    private void addToNeighbours(RouterImpl r) {
        String ipClassCString = Parsing.parseStringByRE(r.getAddress().getHostAddress(), IPCLASSC_PATTERN, "");
        HashSet<Fingerprint> neighbours = this.addressNeighbours.get(ipClassCString);
        if (neighbours == null) {
            neighbours = new HashSet();
            this.addressNeighbours.put(ipClassCString, neighbours);
        }
        neighbours.add(r.getFingerprint());
        neighbours = this.countryNeighbours.get(r.getCountryCode());
        if (neighbours == null) {
            neighbours = new HashSet();
            this.countryNeighbours.put(r.getCountryCode(), neighbours);
        }
        neighbours.add(r.getFingerprint());
    }

    public boolean isDirectoryReady() {
        if (this.numOfRunningRoutersInDirectoryConsensus > 0) {
            long minDescriptors = Math.max(Math.round(TorConfig.getMinDescriptorsPercentage() * (double)this.numOfRunningRoutersInDirectoryConsensus), (long)TorConfig.getMinDescriptors());
            return (long)this.validRoutersByFingerprint.size() > Math.max(minDescriptors, (long)TorConfig.getRouteMinLength());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<RouterImpl> getDirRouters() {
        ArrayList<RouterImpl> authorityDirs;
        ArrayList<RouterImpl> cacheDirs;
        Map<Fingerprint, RouterImpl> map = this.allFingerprintsRouters;
        synchronized (map) {
            cacheDirs = new ArrayList<RouterImpl>(this.allFingerprintsRouters.size());
            authorityDirs = new ArrayList<RouterImpl>();
            for (RouterImpl r : this.allFingerprintsRouters.values()) {
                if (!TorConfig.isCountryAllowed(r.getCountryCode()) || !r.isValid()) continue;
                if (r.isDirv2Authority()) {
                    authorityDirs.add(r);
                    continue;
                }
                if (!r.isDirv2V2dir()) continue;
                cacheDirs.add(r);
            }
        }
        if (cacheDirs.size() >= 5) {
            return cacheDirs;
        }
        if (authorityDirs.size() + cacheDirs.size() >= 5) {
            ArrayList<RouterImpl> result = cacheDirs;
            result.addAll(authorityDirs);
            return result;
        }
        return AuthorityServers.getAuthorityRouters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int refreshListOfServers() {
        Directory directory = this;
        synchronized (directory) {
            if (this.updateRunning) {
                LOG.debug("Directory.refreshListOfServers: update already running...");
                return 0;
            }
            this.updateRunning = true;
            try {
                this.updateNetworkStatusNew();
                if (this.isDirectoryReady()) {
                    this.updateRunning = false;
                    int n = 3;
                    return n;
                }
                int n = 0;
                return n;
            }
            catch (Exception e) {
                LOG.warn("Directory.refreshListOfServers", (Throwable)e);
                int n2 = 0;
                return n2;
            }
            finally {
                this.updateRunning = false;
            }
        }
    }

    private synchronized void updateNetworkStatusNew() throws TorException {
        ++this.updateCounter;
        this.statusAdmin.updateStatus(TorNetLayerStatus.CONSENSUS_LOADING);
        Date now = new Date();
        if (this.directoryConsensus != null && !this.directoryConsensus.needsToBeRefreshed(now)) {
            LOG.debug("no consensus update necessary ...");
        } else {
            DirectoryConsensus newDirectoryConsensus;
            AuthorityKeyCertificates authorityKeyCertificates;
            block27: {
                authorityKeyCertificates = this.getAuthorityKeyCertificates();
                LOG.debug("consensus first initialization attempt: try to use document from local cache ...");
                newDirectoryConsensus = null;
                if (this.directoryConsensus == null || this.directoryConsensus.getFingerprintsNetworkStatusDescriptors().size() == 0) {
                    String newDirectoryConsensusStr = this.stringStorage.get(STORAGEKEY_DIRECTORY_CACHED_CONSENSUS_TXT);
                    int MIN_LENGTH_OF_CONSENSUS_STR = 100;
                    if (newDirectoryConsensusStr != null && newDirectoryConsensusStr.length() > 100) {
                        try {
                            newDirectoryConsensus = new DirectoryConsensus(newDirectoryConsensusStr, authorityKeyCertificates, now);
                            if (newDirectoryConsensus == null || !newDirectoryConsensus.isValid(now)) {
                                newDirectoryConsensus = null;
                                LOG.debug("consensus from local cache (is too small and) could not be used");
                                break block27;
                            }
                            LOG.debug("use consensus from local cache");
                        }
                        catch (TorException e) {
                            newDirectoryConsensus = null;
                            LOG.debug("consensus from local cache is not valid (e.g. too old) and could not be used");
                        }
                        catch (Exception e) {
                            newDirectoryConsensus = null;
                            LOG.debug("error while loading consensus from local cache: {}", (Object)e, (Object)e);
                        }
                    } else {
                        newDirectoryConsensus = null;
                        LOG.debug("consensus from local cache (is null or invalid and) could not be used");
                    }
                }
            }
            LOG.debug("load consensus from Tor network");
            if (newDirectoryConsensus == null) {
                ArrayList<RouterImpl> dirRouters = new ArrayList<RouterImpl>(this.getDirRouters());
                while (dirRouters.size() > 0) {
                    int index = this.rnd.nextInt(dirRouters.size());
                    RouterImpl dirRouter = (RouterImpl)dirRouters.get(index);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Directory.updateNetworkStatusNew: Randomly chosen dirRouter to fetch consensus document: " + dirRouter.getFingerprint() + " (" + dirRouter.getNickname() + ")");
                    }
                    try {
                        String path = "/tor/status-vote/current/consensus";
                        String newDirectoryConsensusStr = SimpleHttpClientCompressed.getInstance().get(this.lowerDirConnectionNetLayer, dirRouter.getDirAddress(), "/tor/status-vote/current/consensus");
                        newDirectoryConsensus = new DirectoryConsensus(newDirectoryConsensusStr, authorityKeyCertificates, now);
                        if (!newDirectoryConsensus.needsToBeRefreshed(now)) {
                            LOG.debug("use new consensus");
                            this.stringStorage.put(STORAGEKEY_DIRECTORY_CACHED_CONSENSUS_TXT, newDirectoryConsensusStr);
                            break;
                        }
                        newDirectoryConsensus = null;
                    }
                    catch (Exception e) {
                        LOG.warn("Directory.updateNetworkStatusNew Exception", (Throwable)e);
                        dirRouters.remove(index);
                        newDirectoryConsensus = null;
                    }
                }
            }
            if (newDirectoryConsensus != null) {
                this.directoryConsensus = newDirectoryConsensus;
            }
        }
        if (this.directoryConsensus == null) {
            LOG.error("no old or new directory consensus available");
            return;
        }
        this.statusAdmin.updateStatus(TorNetLayerStatus.ROUTER_DESCRIPTORS_LOADING);
        if (this.directoryConsensus != null) {
            this.fetchDescriptors(this.allFingerprintsRouters, this.directoryConsensus);
            HashMap<Fingerprint, RouterImpl> newValidRoutersByfingerprint = new HashMap<Fingerprint, RouterImpl>();
            HashMap<Fingerprint, RouterImpl> newExitnodeRouters = new HashMap<Fingerprint, RouterImpl>();
            HashMap<Fingerprint, RouterImpl> newFastRouters = new HashMap<Fingerprint, RouterImpl>();
            HashMap<Fingerprint, RouterImpl> newGuardRouters = new HashMap<Fingerprint, RouterImpl>();
            HashMap<Fingerprint, RouterImpl> newStableRouters = new HashMap<Fingerprint, RouterImpl>();
            HashMap<Fingerprint, RouterImpl> newStableAndFastRouters = new HashMap<Fingerprint, RouterImpl>();
            int newNumOfRunningRoutersInDirectoryConsensus = 0;
            for (RouterStatusDescription networkStatusDescription : this.directoryConsensus.getFingerprintsNetworkStatusDescriptors().values()) {
                Fingerprint fingerprint = networkStatusDescription.getFingerprint();
                RouterImpl r = this.allFingerprintsRouters.get(fingerprint);
                if (r != null && r.isValid()) {
                    r.updateServerStatus(networkStatusDescription.getFlags());
                    newValidRoutersByfingerprint.put(fingerprint, r);
                    this.addToNeighbours(r);
                    if (r.isDirv2Exit() || r.isExitNode()) {
                        newExitnodeRouters.put(fingerprint, r);
                    }
                    if (r.isDirv2Fast()) {
                        newFastRouters.put(fingerprint, r);
                    }
                    if (r.isDirv2Guard()) {
                        newGuardRouters.put(fingerprint, r);
                    }
                    if (r.isDirv2Stable()) {
                        newStableRouters.put(fingerprint, r);
                    }
                    if (r.isDirv2Fast() && r.isDirv2Stable()) {
                        newStableAndFastRouters.put(fingerprint, r);
                    }
                }
                if (!networkStatusDescription.getFlags().contains("Running")) continue;
                ++newNumOfRunningRoutersInDirectoryConsensus;
            }
            this.validRoutersByFingerprint = newValidRoutersByfingerprint;
            this.setRoutersWithExit(newExitnodeRouters);
            this.setFastRouters(newFastRouters);
            this.setStableRouters(newStableRouters);
            this.setStableAndFastRouters(newStableAndFastRouters);
            this.setGuardRouters(newGuardRouters);
            this.numOfRunningRoutersInDirectoryConsensus = newNumOfRunningRoutersInDirectoryConsensus;
            if (LOG.isDebugEnabled()) {
                LOG.debug("updated torServers, new size=" + this.validRoutersByFingerprint.size());
                LOG.debug("number of exit routers : " + newExitnodeRouters.size());
                LOG.debug("number of fast routers : " + newFastRouters.size());
                LOG.debug("number of stable routers : " + newStableRouters.size());
                LOG.debug("number of stable&fast routers : " + newStableAndFastRouters.size());
                LOG.debug("number of guard routers : " + newGuardRouters.size());
            }
            StringBuffer allDescriptors = new StringBuffer();
            for (RouterImpl r : this.validRoutersByFingerprint.values()) {
                allDescriptors.append(r.getRouterDescriptor()).append("\n");
            }
            this.stringStorage.put(STORAGEKEY_DIRECTORY_CACHED_ROUTER_DESCRIPTORS_TXT, allDescriptors.toString());
            LOG.debug("wrote router descriptors to local cache");
        }
    }

    private AuthorityKeyCertificates getAuthorityKeyCertificates() {
        Date now = new Date();
        Date minValidUntil = new Date(now.getTime() + 86400000L);
        if (this.authorityKeyCertificates == null) {
            LOG.debug("getAuthorityKeyCertificates(): try to load from local cache ...");
            String authorityKeyCertificatesStr = this.stringStorage.get(STORAGEKEY_AUTHORITY_KEY_CERTIFICATES_TXT);
            int MIN_LENGTH_OF_AUTHORITY_KEY_CERTS_STR = 100;
            if (authorityKeyCertificatesStr != null && authorityKeyCertificatesStr.length() > 100) {
                try {
                    AuthorityKeyCertificates newAuthorityKeyCertificates = new AuthorityKeyCertificates(authorityKeyCertificatesStr, minValidUntil);
                    if (newAuthorityKeyCertificates.isValid(minValidUntil)) {
                        LOG.debug("getAuthorityKeyCertificates(): successfully loaded from local cache");
                        this.authorityKeyCertificates = newAuthorityKeyCertificates;
                        return this.authorityKeyCertificates;
                    }
                    LOG.debug("getAuthorityKeyCertificates(): loaded from local cache - but not valid: try (re)load from remote site now");
                }
                catch (TorException e) {
                    LOG.warn("getAuthorityKeyCertificates(): could not parse from local cache: try (re)load from remote site now", (Throwable)e);
                }
            } else {
                LOG.debug("getAuthorityKeyCertificates(): no data in cache: try (re)load from remote site now");
            }
        }
        if (this.authorityKeyCertificates == null || !this.authorityKeyCertificates.isValid(minValidUntil)) {
            LOG.debug("getAuthorityKeyCertificates(): load and parse authorityKeyCertificates...");
            ArrayList<String> authServerIpAndPorts = new ArrayList<String>(AuthorityServers.getAuthorityIpAndPorts());
            Collections.shuffle(authServerIpAndPorts);
            String httpResponse = null;
            for (String authServerIpAndPort : authServerIpAndPorts) {
                try {
                    TcpipNetAddress hostAndPort = new TcpipNetAddress(authServerIpAndPort);
                    String path = "/tor/keys/all";
                    httpResponse = SimpleHttpClientCompressed.getInstance().get(this.lowerDirConnectionNetLayer, hostAndPort, "/tor/keys/all");
                    AuthorityKeyCertificates newAuthorityKeyCertificates = new AuthorityKeyCertificates(httpResponse, minValidUntil);
                    if (newAuthorityKeyCertificates.isValid(minValidUntil)) {
                        LOG.debug("getAuthorityKeyCertificates(): successfully loaded from {}", (Object)authServerIpAndPort);
                        this.stringStorage.put(STORAGEKEY_AUTHORITY_KEY_CERTIFICATES_TXT, httpResponse);
                        this.authorityKeyCertificates = newAuthorityKeyCertificates;
                        return this.authorityKeyCertificates;
                    }
                    LOG.debug("getAuthorityKeyCertificates(): loaded from {} - but not valid: try next", (Object)authServerIpAndPort);
                }
                catch (TorException e) {
                    LOG.warn("getAuthorityKeyCertificates(): could not parse from " + authServerIpAndPort + " result=" + httpResponse + ", try next", (Throwable)e);
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("getAuthorityKeyCertificates(): error while loading from {}, try next", (Object)authServerIpAndPort, (Object)e);
                }
            }
            LOG.error("getAuthorityKeyCertificates(): could NOT load and parse authorityKeyCertificates");
        }
        return this.authorityKeyCertificates;
    }

    private void fetchDescriptors(Map<Fingerprint, RouterImpl> fingerprintsRouters, DirectoryConsensus directoryConsensus) throws TorException {
        String allDescriptors;
        HashSet<Fingerprint> fingerprintsOfRoutersToLoad = new HashSet<Fingerprint>();
        for (RouterStatusDescription networkStatusDescription : directoryConsensus.getFingerprintsNetworkStatusDescriptors().values()) {
            RouterImpl r = fingerprintsRouters.get(networkStatusDescription.getFingerprint());
            if (r != null && r.isValid()) continue;
            fingerprintsOfRoutersToLoad.add(networkStatusDescription.getFingerprint());
        }
        int ALL_DESCRIPTORS_STR_MIN_LEN = 1000;
        if (fingerprintsRouters.size() == 0) {
            allDescriptors = this.stringStorage.get(STORAGEKEY_DIRECTORY_CACHED_ROUTER_DESCRIPTORS_TXT);
            if (allDescriptors != null && allDescriptors.length() >= 1000) {
                Map<Fingerprint, RouterImpl> parsedServers = RouterImpl.parseRouterDescriptors(allDescriptors);
                HashSet fingerprintsOfRoutersToLoadCopy = new HashSet(fingerprintsOfRoutersToLoad);
                for (Fingerprint fingerprint : fingerprintsOfRoutersToLoadCopy) {
                    RouterImpl r = parsedServers.get(fingerprint);
                    if (r == null || !r.isValid()) continue;
                    fingerprintsRouters.put(fingerprint, r);
                    fingerprintsOfRoutersToLoad.remove(fingerprint);
                }
            }
            LOG.debug("loaded {} routers from local cache", (Object)fingerprintsRouters.size());
        }
        int TRHESHOLD_TO_LOAD_SINGE_ROUTER_DESCRITPIONS = 200;
        LOG.debug("load {} routers from dir server(s) - start", (Object)fingerprintsOfRoutersToLoad.size());
        int successes = 0;
        if (fingerprintsOfRoutersToLoad.size() <= 200) {
            int attempts = fingerprintsOfRoutersToLoad.size();
            LOG.debug("loaded {} of {} missing routers from directory server(s) with multiple requests", (Object)successes, (Object)attempts);
        } else {
            ArrayList<RouterImpl> dirRouters = new ArrayList<RouterImpl>(this.getDirRouters());
            while (dirRouters.size() > 0) {
                int i = this.rnd.nextInt(dirRouters.size());
                RouterImpl directoryServer = (RouterImpl)dirRouters.get(i);
                dirRouters.remove(i);
                if (directoryServer.getDirPort() < 1 || (allDescriptors = DescriptorFetcherThread.downloadAllDescriptors(directoryServer, this.lowerDirConnectionNetLayer)) == null || allDescriptors.length() < 1000) continue;
                Map<Fingerprint, RouterImpl> parsedServers = RouterImpl.parseRouterDescriptors(allDescriptors);
                int attempts = 0;
                for (Fingerprint fingerprint : fingerprintsOfRoutersToLoad) {
                    RouterImpl r = parsedServers.get(fingerprint);
                    ++attempts;
                    if (r == null) continue;
                    fingerprintsRouters.put(fingerprint, r);
                    ++successes;
                }
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("loaded " + successes + " of " + attempts + " missing routers from directory server \"" + directoryServer.getNickname() + "\" with single request");
                break;
            }
        }
        LOG.debug("load routers from dir server(s), loaded {} routers - finished", (Object)successes);
    }

    public boolean isCompatible(RouterImpl[] route, TCPStreamProperties sp, boolean forHiddenService) throws TorException {
        if (route == null) {
            throw new TorException("received NULL-route");
        }
        if (sp == null) {
            throw new TorException("received NULL-sp");
        }
        if (route[route.length - 1] == null) {
            throw new TorException("route contains NULL at position " + (route.length - 1));
        }
        if (route.length < 1) {
            return false;
        }
        if (route.length < sp.getMinRouteLength()) {
            return false;
        }
        if (route.length > sp.getMaxRouteLength()) {
            return false;
        }
        Fingerprint[] proposedRoute = sp.getProposedRouteFingerprints();
        if (proposedRoute != null) {
            for (int i = 0; i < proposedRoute.length && i < route.length; ++i) {
                if (proposedRoute[i] == null || route[i].getFingerprint().equals(proposedRoute[i])) continue;
                return false;
            }
        }
        if (!forHiddenService && sp.isExitPolicyRequired()) {
            return route[route.length - 1].exitPolicyAccepts(sp.getAddr(), sp.getPort());
        }
        return true;
    }

    public Set<Fingerprint> excludeRelatedNodes(RouterImpl r) {
        HashSet<Fingerprint> myCountryNeighbours;
        HashSet<Fingerprint> excludedServerfingerprints = new HashSet<Fingerprint>();
        if (TorConfig.isRouteUniqueClassC()) {
            HashSet<Fingerprint> myAddressNeighbours = this.getAddressNeighbours(r.getAddress().getHostAddress());
            if (myAddressNeighbours != null) {
                excludedServerfingerprints.addAll(myAddressNeighbours);
            }
        } else {
            excludedServerfingerprints.add(r.getFingerprint());
        }
        if (TorConfig.isRouteUniqueCountry() && (myCountryNeighbours = this.countryNeighbours.get(r.getCountryCode())) != null) {
            excludedServerfingerprints.addAll(myCountryNeighbours);
        }
        excludedServerfingerprints.addAll(r.getFamily());
        return excludedServerfingerprints;
    }

    public RouterImpl selectRandomNode(Map<Fingerprint, RouterImpl> torRouters, HashSet<Fingerprint> excludedServerFingerprints, float rankingInfluenceIndex, boolean onlyFast, boolean onlyStable) {
        HashMap<Fingerprint, RouterImpl> routersToChooseFrom = new HashMap<Fingerprint, RouterImpl>(torRouters);
        HashSet<Fingerprint> listOfExcludedRouters = new HashSet<Fingerprint>(excludedServerFingerprints);
        if (onlyFast) {
            for (RouterImpl router : routersToChooseFrom.values()) {
                if (router.isDirv2Fast()) continue;
                listOfExcludedRouters.add(router.getFingerprint());
            }
        }
        if (onlyStable) {
            for (RouterImpl router : routersToChooseFrom.values()) {
                if (router.isDirv2Stable()) continue;
                listOfExcludedRouters.add(router.getFingerprint());
            }
        }
        float rankingSum = 0.0f;
        listOfExcludedRouters.addAll(this.excludedNodesByConfig);
        for (RouterImpl myServer : routersToChooseFrom.values()) {
            if (listOfExcludedRouters.contains(myServer.getNickname()) || !myServer.isDirv2Running()) continue;
            rankingSum += myServer.getRefinedRankingIndex(rankingInfluenceIndex);
        }
        float serverRandom = this.rnd.nextFloat() * rankingSum;
        for (RouterImpl myServer : routersToChooseFrom.values()) {
            if (listOfExcludedRouters.contains(myServer.getNickname()) || !myServer.isDirv2Running() || !((serverRandom -= myServer.getRefinedRankingIndex(rankingInfluenceIndex)) <= 0.0f)) continue;
            return myServer;
        }
        return null;
    }

    public RouterImpl getValidRouterByIpAddressAndOnionPort(IpNetAddress ipNetAddress, int onionPort) {
        TcpipNetAddress check = new TcpipNetAddress(ipNetAddress, onionPort);
        return this.getValidRouterByIpAddressAndOnionPort(check);
    }

    public RouterImpl getValidRouterByIpAddressAndOnionPort(TcpipNetAddress tcpipNetAddress) {
        for (RouterImpl router : this.getValidRoutersByFingerprint().values()) {
            if (!router.getOrAddress().equals(tcpipNetAddress)) continue;
            return router;
        }
        return null;
    }

    public RouterImpl getValidRouterByIpAddressAndDirPort(TcpipNetAddress tcpipNetAddress) {
        for (RouterImpl router : this.getValidRoutersByFingerprint().values()) {
            if (!router.getDirAddress().equals(tcpipNetAddress)) continue;
            return router;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RouterImpl[] getValidHiddenDirectoryServersOrderedByFingerprint() {
        ArrayList<RouterImpl> routersList;
        Map<Fingerprint, RouterImpl> map = this.allFingerprintsRouters;
        synchronized (map) {
            routersList = new ArrayList<RouterImpl>(this.allFingerprintsRouters.values());
        }
        Iterator i = routersList.iterator();
        while (i.hasNext()) {
            RouterImpl r = (RouterImpl)i.next();
            if (r.isDirv2HSDir() && r.getDirPort() >= 1) continue;
            i.remove();
        }
        RouterImpl[] routers = routersList.toArray(new RouterImpl[routersList.size()]);
        Comparator<RouterImpl> comp = new Comparator<RouterImpl>(){

            @Override
            public int compare(RouterImpl o1, RouterImpl o2) {
                return o1.getFingerprint().compareTo(o2.getFingerprint());
            }
        };
        Arrays.sort(routers, comp);
        return routers;
    }

    public Collection<RouterImpl> getThreeHiddenDirectoryServersWithFingerpringGreaterThan(Fingerprint f) {
        RouterImpl[] routers = this.getValidHiddenDirectoryServersOrderedByFingerprint();
        int REQUESTED_NUM_OF_ROUTERS = 3;
        int numOfRoutersToFind = Math.min(3, routers.length);
        ArrayList<RouterImpl> result = new ArrayList<RouterImpl>(numOfRoutersToFind);
        boolean takeNextRouters = false;
        for (int i = 0; i < 2 * routers.length; ++i) {
            RouterImpl r = routers[i % routers.length];
            if (!takeNextRouters && r.getFingerprint().compareTo(f) >= 0) {
                takeNextRouters = true;
            }
            if (!takeNextRouters) continue;
            result.add(r);
            if (--numOfRoutersToFind <= 0) break;
        }
        return result;
    }

    private HashSet<Fingerprint> getAddressNeighbours(String address) {
        String ipClassCString = Parsing.parseStringByRE(address, IPCLASSC_PATTERN, "");
        HashSet<Fingerprint> neighbours = this.addressNeighbours.get(ipClassCString);
        return neighbours;
    }

    public void close() {
    }

    void print() {
        if (LOG.isDebugEnabled()) {
            for (RouterImpl r : this.validRoutersByFingerprint.values()) {
                LOG.debug(r.toString());
            }
        }
    }

    public NetLayer getLowerDirConnectionNetLayer() {
        return this.lowerDirConnectionNetLayer;
    }

    public void setLowerDirConnectionNetLayer(NetLayer lowerDirConnectionNetLayer) {
        this.lowerDirConnectionNetLayer = lowerDirConnectionNetLayer;
    }

    public Map<Fingerprint, RouterImpl> getValidRoutersByFingerprint() {
        HashMap<Fingerprint, RouterImpl> result = new HashMap<Fingerprint, RouterImpl>(this.validRoutersByFingerprint);
        Iterator<Map.Entry<Fingerprint, RouterImpl>> itRouter = result.entrySet().iterator();
        while (itRouter.hasNext()) {
            if (TorConfig.isCountryAllowed(itRouter.next().getValue().getCountryCode())) continue;
            itRouter.remove();
        }
        return result;
    }

    public void setValidRoutersByFingerprint(Map<Fingerprint, RouterImpl> validRoutersByFingerprint) {
        this.validRoutersByFingerprint = validRoutersByFingerprint;
    }

    public Map<Fingerprint, RouterImpl> getRoutersWithExit() {
        HashMap<Fingerprint, RouterImpl> result = new HashMap<Fingerprint, RouterImpl>(this.routersWithExit);
        Iterator<Map.Entry<Fingerprint, RouterImpl>> itRouter = result.entrySet().iterator();
        while (itRouter.hasNext()) {
            if (TorConfig.isCountryAllowed(itRouter.next().getValue().getCountryCode())) continue;
            itRouter.remove();
        }
        return result;
    }

    public void setRoutersWithExit(Map<Fingerprint, RouterImpl> routersWithExit) {
        this.routersWithExit = routersWithExit;
    }

    public Map<Fingerprint, RouterImpl> getFastRouters() {
        return this.fastRouters;
    }

    public void setFastRouters(Map<Fingerprint, RouterImpl> fastRouters) {
        this.fastRouters = fastRouters;
    }

    public Map<Fingerprint, RouterImpl> getStableRouters() {
        return this.stableRouters;
    }

    public void setStableRouters(Map<Fingerprint, RouterImpl> stableRouters) {
        this.stableRouters = stableRouters;
    }

    public Map<Fingerprint, RouterImpl> getStableAndFastRouters() {
        return this.stableAndFastRouters;
    }

    public void setStableAndFastRouters(Map<Fingerprint, RouterImpl> stableAndFastRouters) {
        this.stableAndFastRouters = stableAndFastRouters;
    }

    public Map<Fingerprint, RouterImpl> getGuardRouters() {
        return this.guardRouters;
    }

    public void setGuardRouters(Map<Fingerprint, RouterImpl> guardRouters) {
        this.guardRouters = guardRouters;
    }

    public boolean isDirServer(TCPStreamProperties sp) {
        String[] octets;
        byte[] ip;
        RouterImpl router;
        return sp.getHostname() != null && InetAddressUtils.isIPv4Address((String)sp.getHostname()) && (router = this.getValidRouterByIpAddressAndDirPort(new TcpipNetAddress(ip = new byte[]{(byte)Integer.parseInt((octets = sp.getHostname().split("\\."))[0]), (byte)Integer.parseInt(octets[1]), (byte)Integer.parseInt(octets[2]), (byte)Integer.parseInt(octets[3])}, sp.getPort()))) != null && (router.isDirv2HSDir() || router.isDirv2V2dir());
    }
}

