/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tor.directory;

import org.silvertunnel_ng.netlib.api.NetLayer;
import org.silvertunnel_ng.netlib.api.util.TcpipNetAddress;
import org.silvertunnel_ng.netlib.layer.tor.directory.RouterImpl;
import org.silvertunnel_ng.netlib.layer.tor.directory.RouterStatusDescription;
import org.silvertunnel_ng.netlib.tool.SimpleHttpClient;
import org.silvertunnel_ng.netlib.tool.SimpleHttpClientCompressed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DescriptorFetcherThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(DescriptorFetcherThread.class);
    private boolean stopped = false;
    private boolean resolved = false;
    private boolean failed = false;
    private boolean idle = true;
    private int reloadRetries = 0;
    private String descriptor;
    private StringBuffer nodesDigests;
    private StringBuffer nicks;
    private RouterStatusDescription loadFrom;
    private NetLayer lowerDirConnectionNetLayer;

    DescriptorFetcherThread(NetLayer lowerDirConnectionNetLayer) {
        this.lowerDirConnectionNetLayer = lowerDirConnectionNetLayer;
        this.start();
    }

    private void fetchDescriptor() {
        String newDescriptor = DescriptorFetcherThread.downloadSingleDescriptor(this.nodesDigests.toString(), this.loadFrom, this.lowerDirConnectionNetLayer);
        if (newDescriptor != null) {
            this.resolved = true;
        } else {
            this.failed = true;
            this.descriptor = "error";
        }
    }

    public static String downloadSingleDescriptor(String nodesDigestsToLoad, RouterStatusDescription directoryServer, NetLayer dirConnectionNetLayer) {
        try {
            String path = "/tor/server/d" + nodesDigestsToLoad;
            TcpipNetAddress hostAndPort = new TcpipNetAddress(directoryServer.getIp(), directoryServer.getDirPort());
            String httpResponse = SimpleHttpClient.getInstance().get(dirConnectionNetLayer, hostAndPort, path);
            return httpResponse;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("downloadSingleDescriptor() from " + directoryServer.getNickname() + " failed: " + e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    public static String downloadAllDescriptors(RouterImpl directoryServer, NetLayer dirConnectionNetLayer) {
        try {
            String path = "/tor/server/all";
            String httpResponse = SimpleHttpClientCompressed.getInstance().get(dirConnectionNetLayer, directoryServer.getDirAddress(), "/tor/server/all");
            return httpResponse;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("downloadAllDescriptors() from " + directoryServer.getNickname() + " failed: " + e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.stopped) {
            try {
                DescriptorFetcherThread descriptorFetcherThread = this;
                synchronized (descriptorFetcherThread) {
                    this.wait();
                }
                if (this.idle || this.resolved || this.failed) continue;
                this.fetchDescriptor();
            }
            catch (Exception e) {
                LOG.debug("got Exception : {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void setStopped(boolean stopped) {
        this.stopped = stopped;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public void setResolved(boolean resolved) {
        this.resolved = resolved;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void setFailed(boolean failed) {
        this.failed = failed;
    }

    public boolean isIdle() {
        return this.idle;
    }

    public void setIdle(boolean idle) {
        this.idle = idle;
    }

    public int getReloadRetries() {
        return this.reloadRetries;
    }

    public void setReloadRetries(int reloadRetries) {
        this.reloadRetries = reloadRetries;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(String descriptor) {
        this.descriptor = descriptor;
    }

    public StringBuffer getNodesDigests() {
        return this.nodesDigests;
    }

    public void setNodesDigests(StringBuffer nodesDigests) {
        this.nodesDigests = nodesDigests;
    }

    public StringBuffer getNicks() {
        return this.nicks;
    }

    public void setNicks(StringBuffer nicks) {
        this.nicks = nicks;
    }

    public RouterStatusDescription getLoadFrom() {
        return this.loadFrom;
    }

    public void setLoadFrom(RouterStatusDescription loadFrom) {
        this.loadFrom = loadFrom;
    }

    public NetLayer getLowerDirConnectionNetLayer() {
        return this.lowerDirConnectionNetLayer;
    }

    public void setLowerDirConnectionNetLayer(NetLayer lowerDirConnectionNetLayer) {
        this.lowerDirConnectionNetLayer = lowerDirConnectionNetLayer;
    }
}

