/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tor.common;

import java.util.ArrayList;
import java.util.Collection;
import org.silvertunnel_ng.netlib.layer.tor.common.TorEvent;
import org.silvertunnel_ng.netlib.layer.tor.common.TorEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TorEventService {
    private static final Logger LOG = LoggerFactory.getLogger(TorEventService.class);
    private final Collection<TorEventHandler> eventHandlers = new ArrayList<TorEventHandler>();

    public void registerEventHandler(TorEventHandler eventHandler) {
        this.eventHandlers.add(eventHandler);
    }

    public boolean removeEventHandler(TorEventHandler eventHandler) {
        return this.eventHandlers.remove(eventHandler);
    }

    public void fireEvent(TorEvent event) {
        for (TorEventHandler eventHandler : this.eventHandlers) {
            try {
                eventHandler.fireEvent(event);
            }
            catch (Exception e) {
                LOG.warn("TorEventService.fireEvent()", (Throwable)e);
            }
        }
    }
}

