/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tor.common;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import org.silvertunnel_ng.netlib.layer.tor.util.Encoding;
import org.silvertunnel_ng.netlib.layer.tor.util.Parsing;
import org.silvertunnel_ng.netlib.layer.tor.util.TorException;
import org.silvertunnel_ng.netlib.util.SystemPropertiesHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TorConfig {
    private static final Logger LOG = LoggerFactory.getLogger(TorConfig.class);
    private static TorConfig instance;
    public static final boolean USE_CREATE_FAST_CELLS = true;
    private int startupDelaySeconds = 20;
    public String nickname = "silvertunnel-ng-org-Netlib";
    private int retriesConnect = 5;
    public static int reconnectCircuit;
    public static int retriesStreamBuildup;
    private static final int MAXIMUM_IDLE_CIRCUITS = 20;
    private int minimumIdleCircuits = 3;
    public static final String SYSTEMPROPERTY_TOR_PREFIX = "silvertunnel-ng.tor.";
    public static final String SYSTEMPROPERTY_TOR_MINIMUM_IDLE_CIRCUITS = "silvertunnel-ng.tor.minimumIdleCircuits";
    public static final String SYSTEMPROPERTY_TOR_MINIMUM_ROUTE_LENGTH = "silvertunnel-ng.tor.minimumRouteLength";
    public static final String SYSTEMPROPERTY_TOR_MAXIMUM_ROUTE_LENGTH = "silvertunnel-ng.tor.maximumRouteLength";
    public static final String SYSTEMPROPERTY_TOR_CACHE_HS_DESCRIPTOR = "silvertunnel-ng.tor.cacheHiddenServiceDescriptor";
    public static final String SYSTEMPROPERTY_TOR_MAX_ALLOWED_SETUP_DURATION_MS = "silvertunnel-ng.tor.maxAllowedSetupDurationMs";
    public static int queueTimeoutCircuit;
    public static int queueTimeoutResolve;
    public static int queueTimeoutStreamBuildup;
    private int circuitClosesOnFailures = 3;
    public static int circuitsMaximumNumber;
    public static long maxAllowedSetupDurationMs;
    public static float rankingTransferPerServerUpdate;
    private boolean veryAggressiveStreamBuilding = false;
    private int intervalDirectoryRefresh = 5;
    public static final long DIR_CONNECT_TIMEOUT_MILLIS = 10000L;
    public static final long DIR_OVERALL_TIMEOUT_MILLIS = 30000L;
    public static final long DIR_MAX_FILETRANSFER_BYTES = 0x3200000L;
    public static final long DIR_THROUGPUT_TIMEFRAME_MIN_BYTES = 15360L;
    public static final long DIR_THROUGPUT_TIMEFRAME_MILLIS = 15000L;
    public static final int CIRCUIT_ESTABLISHMENT_TIME_IMPACT = 5;
    private int streamsPerCircuit = 50;
    public static float rankingIndexEffect;
    private static final int MINIMUM_ROUTE_LENGTH = 2;
    private static final int MAXIMUM_ROUTE_LENGTH = 8;
    private int routeMinLength = 3;
    private int routeMaxLength = 5;
    private double minDescriptorsPercentage = 0.1;
    private Integer minDescriptors;
    private boolean routeUniqueClassC = true;
    private boolean routeUniqueCountry = true;
    public static int allowModeMultipleCircuits;
    private Set<String> avoidedCountries;
    private Set<byte[]> avoidedNodeFingerprints;
    private static final String TOR_CONFIG_FILENAME = "torrc";
    public static final String TOR_GEOIPCITY_PATH = "/com/maxmind/geoip/GeoIP.dat";
    public static final int TOR_GEOIPCITY_MAX_FILE_SIZE = 2000000;
    private static String filename;
    private static boolean cacheHiddenServiceDescriptor;
    public static final int MIN_NUMBER_OF_ROUTERS_IN_CONSENSUS = 50;
    public static final long ROUTER_DESCRIPTION_VALID_PERIOD_MS = 86400000L;
    private boolean saveCircuitHistory = true;

    public static synchronized TorConfig getInstance() {
        if (instance == null) {
            instance = new TorConfig();
            instance.init(null);
        }
        return instance;
    }

    public static int getStartupDelay() {
        return TorConfig.getInstance().startupDelaySeconds;
    }

    public static void setStartupDelay(int delay) {
        TorConfig.getInstance().startupDelaySeconds = delay;
    }

    public static int getRetriesConnect() {
        return TorConfig.getInstance().retriesConnect;
    }

    public static void setRetriesConnect(int retries) {
        if (retries <= 0) {
            LOG.warn("setRetriesConnect : wrong value for retriesConnect found!");
            return;
        }
        if (retries > 20) {
            LOG.warn("setRetriesConnect : number of retries could be to high.");
        }
        TorConfig.getInstance().retriesConnect = retries;
    }

    public static int getMinimumIdleCircuits() {
        return TorConfig.getInstance().minimumIdleCircuits;
    }

    public static void setMinimumIdleCircuits(int nrOfCircuits) {
        if (nrOfCircuits < 0) {
            LOG.warn("setMinimumIdleCircuits : value should not be lower than 0. setting minimumIdleCircuits to 0!");
            TorConfig.setMinimumIdleCircuits(0);
        }
        if (nrOfCircuits > 20) {
            LOG.warn("setMinimumIdleCircuits : value should not be greater than 20. setting minimumIdleCircuits to 20!");
            TorConfig.setMinimumIdleCircuits(20);
        }
        TorConfig.getInstance().minimumIdleCircuits = nrOfCircuits;
    }

    public static int getCircuitClosesOnFailures() {
        return TorConfig.getInstance().circuitClosesOnFailures;
    }

    public static void setCircuitClosesOnFailures(int circuitClosesOnFailures) {
        TorConfig.getInstance().circuitClosesOnFailures = circuitClosesOnFailures;
    }

    public static boolean isVeryAggressiveStreamBuilding() {
        return TorConfig.getInstance().veryAggressiveStreamBuilding;
    }

    public static void setVeryAggressiveStreamBuilding(boolean veryAggressiveStreamBuilding) {
        TorConfig.getInstance().veryAggressiveStreamBuilding = veryAggressiveStreamBuilding;
    }

    public static int getIntervalDirectoryRefresh() {
        return TorConfig.getInstance().intervalDirectoryRefresh;
    }

    public static void setIntervalDirectoryRefresh(int intervalDirectoryRefresh) {
        TorConfig.getInstance().intervalDirectoryRefresh = intervalDirectoryRefresh;
    }

    public static int getStreamsPerCircuit() {
        return TorConfig.getInstance().streamsPerCircuit;
    }

    public static void setStreamsPerCircuit(int streams) {
        if (streams <= 0) {
            LOG.error("it is not allowed to set the number of streams in a circuit lower than 1!");
        } else {
            LOG.debug("setting streamsPerCircuit from {} to {}", new Object[]{TorConfig.getInstance().streamsPerCircuit, streams});
            TorConfig.getInstance().streamsPerCircuit = streams;
        }
    }

    public static int getRouteMinLength() {
        return TorConfig.getInstance().routeMinLength;
    }

    public static void setRouteMinLength(int length) {
        if (length < 2) {
            LOG.warn("route length has to be at least 2!");
            return;
        }
        if (length > 8) {
            LOG.warn("route length should not exceed 8");
            return;
        }
        if (length > TorConfig.getInstance().routeMaxLength) {
            LOG.info("setRouteMinLength: length (" + length + ") is smaller than current maxlen. Setting maxlen to given value.");
            TorConfig.getInstance().routeMaxLength = length;
        }
        TorConfig.getInstance().routeMinLength = length;
    }

    public static int getRouteMaxLength() {
        return TorConfig.getInstance().routeMaxLength;
    }

    public static void setRouteMaxLength(int length) {
        if (length < 2) {
            LOG.warn("route length has to be at least 2!");
            return;
        }
        if (length > 8) {
            LOG.warn("route length should not exceed 8");
            return;
        }
        if (length < TorConfig.getInstance().routeMinLength) {
            LOG.info("setRouteMaxLength: length (" + length + ") is smaller than current minlen. Setting minlen to given value.");
            TorConfig.getInstance().routeMinLength = length;
        }
        TorConfig.getInstance().routeMaxLength = length;
    }

    public static double getMinDescriptorsPercentage() {
        return TorConfig.getInstance().minDescriptorsPercentage;
    }

    public static void setMinDescriptorsPercentage(double percent) throws TorException {
        if (percent < 0.0 || percent > 100.0) {
            throw new TorException("invalid value for setMinDescriptorsPercentage");
        }
        if (percent == 0.0) {
            LOG.warn("setMinDescriptorsPercentage: setting this value to 0 is discouraged");
        }
        TorConfig.getInstance().minDescriptorsPercentage = percent;
    }

    public static void setMinDescriptors(Integer minDescriptors) {
        TorConfig.getInstance().minDescriptors = minDescriptors;
    }

    public static int getMinDescriptors() {
        if (TorConfig.getInstance().minDescriptors == null) {
            return 10 * TorConfig.getInstance().routeMinLength;
        }
        return TorConfig.getInstance().minDescriptors;
    }

    public static boolean isRouteUniqueClassC() {
        return TorConfig.getInstance().routeUniqueClassC;
    }

    public static void setRouteUniqueClassC(boolean value) {
        TorConfig.getInstance().routeUniqueClassC = value;
    }

    public static boolean isRouteUniqueCountry() {
        return TorConfig.getInstance().routeUniqueCountry;
    }

    public static void setRouteUniqueCountry(boolean routeUniqueCountry) {
        TorConfig.getInstance().routeUniqueCountry = routeUniqueCountry;
    }

    public static boolean isCountryAllowed(String countryCode) {
        if (TorConfig.getInstance().avoidedCountries == null) {
            return true;
        }
        return !TorConfig.getInstance().avoidedCountries.contains(countryCode);
    }

    public static void setCountryAllowed(Set<String> countryCodes) {
        TorConfig.getInstance().avoidedCountries = countryCodes;
    }

    public static void setCountryAllowed(String countryCode, boolean allowed) {
        if (TorConfig.getInstance().avoidedCountries == null) {
            TorConfig.getInstance().avoidedCountries = new HashSet<String>();
        }
        if (allowed) {
            TorConfig.getInstance().avoidedCountries.remove(countryCode);
        } else {
            TorConfig.getInstance().avoidedCountries.add(countryCode);
        }
    }

    public static Set<byte[]> getAvoidedNodeFingerprints() {
        return TorConfig.getInstance().avoidedNodeFingerprints;
    }

    public static void setAvoidedNodeFingerprints(Set<byte[]> fingerprints) {
        TorConfig.getInstance().avoidedNodeFingerprints = fingerprints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAvoidednodeFingerprint(byte[] fingerprint) {
        Set<byte[]> set = TorConfig.getInstance().avoidedNodeFingerprints;
        synchronized (set) {
            if (TorConfig.getInstance().avoidedNodeFingerprints == null) {
                TorConfig.getInstance().avoidedNodeFingerprints = new HashSet<byte[]>();
            }
        }
        TorConfig.getInstance().avoidedNodeFingerprints.add(fingerprint);
    }

    public static final void reloadConfigFromProperties() {
        try {
            TorConfig.setMinimumIdleCircuits(SystemPropertiesHelper.getSystemProperty(SYSTEMPROPERTY_TOR_MINIMUM_IDLE_CIRCUITS, TorConfig.getInstance().minimumIdleCircuits));
            TorConfig.setRouteMinLength(SystemPropertiesHelper.getSystemProperty(SYSTEMPROPERTY_TOR_MINIMUM_ROUTE_LENGTH, TorConfig.getRouteMinLength()));
            TorConfig.setRouteMaxLength(SystemPropertiesHelper.getSystemProperty(SYSTEMPROPERTY_TOR_MAXIMUM_ROUTE_LENGTH, TorConfig.getRouteMaxLength()));
            TorConfig.setCacheHiddenServiceDescriptor(SystemPropertiesHelper.getSystemProperty(SYSTEMPROPERTY_TOR_CACHE_HS_DESCRIPTOR, TorConfig.isCacheHiddenServiceDescriptor()));
            maxAllowedSetupDurationMs = SystemPropertiesHelper.getSystemProperty(SYSTEMPROPERTY_TOR_MAX_ALLOWED_SETUP_DURATION_MS, (int)maxAllowedSetupDurationMs);
        }
        catch (Exception e) {
            LOG.error("config could not be loaded from properties", (Throwable)e);
        }
    }

    private TorConfig() {
    }

    private TorConfig(boolean readFileName) {
        instance = this;
        if (readFileName) {
            this.init(TorConfig.getConfigDir() + TOR_CONFIG_FILENAME);
        } else {
            this.init(null);
        }
    }

    private TorConfig(String filename) {
        instance = this;
        this.init(filename);
    }

    public void reload() {
        if (filename == null) {
            return;
        }
        LOG.info("TorConfig.reload: reloading config-file " + filename);
        this.init(filename);
    }

    private void init(String filename) {
        this.avoidedCountries = new HashSet<String>();
        this.avoidedNodeFingerprints = new HashSet<byte[]>();
        this.readFromConfig(filename);
        TorConfig.filename = filename;
    }

    public static void close() {
        TorConfig.getInstance().writeToFile("/tmp/torrc.test");
    }

    private String replaceSpaceWithSpaceRegExp(String regexp) {
        return regexp.replaceAll(" ", "\\\\s+");
    }

    private int parseInt(String config, String name, int myDefault) {
        int x = Integer.parseInt(Parsing.parseStringByRE(config, Parsing.compileRegexPattern("^\\s*" + this.replaceSpaceWithSpaceRegExp(name) + "\\s+(\\d+)"), Integer.toString(myDefault)));
        LOG.debug("TorConfig.parseInt: Parsed '{}' as '{}'", (Object)name, (Object)x);
        return x;
    }

    private String writeInt(String name, int value) {
        return name + " " + value + "\n";
    }

    private String writeFloat(String name, float value) {
        return name + " " + value + "\n";
    }

    private String writeDouble(String name, double value) {
        return name + " " + value + "\n";
    }

    private float parseFloat(String config, String name, float myDefault, float lower, float upper) {
        float x = Float.parseFloat(Parsing.parseStringByRE(config, Parsing.compileRegexPattern("^\\s*" + this.replaceSpaceWithSpaceRegExp(name) + "\\s+([0-9.]+)"), Float.toString(myDefault)));
        if (x < lower) {
            x = lower;
        }
        if (x > upper) {
            x = upper;
        }
        LOG.debug("TorConfig.parseFloat: Parsed '{}' as '{}'", (Object)name, (Object)Float.valueOf(x));
        return x;
    }

    private double parseDouble(String config, String name, double myDefault, double lower, double upper) {
        double x = Double.parseDouble(Parsing.parseStringByRE(config, Parsing.compileRegexPattern("^\\s*" + this.replaceSpaceWithSpaceRegExp(name) + "\\s+([0-9.]+)"), Double.toString(myDefault)));
        if (x < lower) {
            x = lower;
        }
        if (x > upper) {
            x = upper;
        }
        LOG.debug("TorConfig.parseDouble: Parsed '{}' as '{}'", (Object)name, (Object)x);
        return x;
    }

    private String parseString(String config, String name, String myDefault) {
        String x = Parsing.parseStringByRE(config, Parsing.compileRegexPattern("^\\s*" + this.replaceSpaceWithSpaceRegExp(name) + "\\s+(\\S.*?)$"), myDefault);
        LOG.debug("TorConfig.parseString: Parsed '{}' as '{}'", (Object)name, (Object)x);
        return x;
    }

    private String writeString(String name, String value) {
        return name + " " + value + "\n";
    }

    private boolean parseBoolean(String config, String name, boolean myDefault) {
        String mydef = "false";
        if (myDefault) {
            mydef = "true";
        }
        String x = Parsing.parseStringByRE(config, Parsing.compileRegexPattern("^\\s*" + this.replaceSpaceWithSpaceRegExp(name) + "\\s+(\\S.*?)$"), mydef).trim();
        boolean ret = false;
        if (x.equals("1") || x.equalsIgnoreCase("true") || x.equalsIgnoreCase("yes")) {
            ret = true;
        }
        LOG.debug("TorConfig.parseBoolean: Parsed '{}' as '{}'", (Object)name, (Object)ret);
        return ret;
    }

    private String writeBoolean(String name, boolean value) {
        if (value) {
            return name + " " + "true" + "\n";
        }
        return name + " " + "false" + "\n";
    }

    private void readFromConfig(String filename) {
        try {
            String config = "";
            if (filename != null) {
                DataInputStream sin = new DataInputStream(new FileInputStream(new File(filename)));
                config = TorConfig.readAllFromStream(sin);
                LOG.debug("TorConfig.readFromConfig(): {}", (Object)config);
            }
            this.streamsPerCircuit = this.parseInt(config, "StreamsPerCircuit", this.streamsPerCircuit);
            rankingIndexEffect = this.parseFloat(config, "RankingIndexEffect", rankingIndexEffect, 0.0f, 1.0f);
            this.routeMinLength = this.parseInt(config, "RouteMinLength", this.routeMinLength);
            this.routeMaxLength = this.parseInt(config, "RouteMaxLength", this.routeMaxLength);
            try {
                TorConfig.setMinDescriptorsPercentage(this.parseDouble(config, "MinPercentage", this.minDescriptorsPercentage, 0.0, 1.0));
            }
            catch (TorException e) {
                LOG.warn("could not load MinPercentage from config file");
            }
            this.routeUniqueClassC = this.parseBoolean(config, "RouteUniqClassC", this.routeUniqueClassC);
            this.routeUniqueCountry = this.parseBoolean(config, "RouteUniqCountry", this.routeUniqueCountry);
            allowModeMultipleCircuits = this.parseInt(config, "AllowNodeMultipleCircuits", allowModeMultipleCircuits);
            Pattern p = Pattern.compile("^\\s*AvoidCountry\\s+(.*?)$", 11);
            Matcher m = p.matcher(config);
            while (m.find()) {
                LOG.debug("TorConfig.readConfig: will avoid country: {}", (Object)m.group(1));
                this.avoidedCountries.add(m.group(1));
            }
            p = Pattern.compile("^\\s*AvoidNode\\s+(.*?)$", 11);
            m = p.matcher(config);
            while (m.find()) {
                LOG.debug("TorConfig.readConfig: will avoid node: {}", (Object)m.group(1));
                this.avoidedNodeFingerprints.add(DatatypeConverter.parseHexBinary((String)m.group(1)));
            }
            TorConfig.setStartupDelay(this.parseInt(config, "startupDelaySeconds", TorConfig.getStartupDelay()));
            this.nickname = this.parseString(config, "nickname", this.nickname);
            this.retriesConnect = this.parseInt(config, "RetriesConnect", this.retriesConnect);
            retriesStreamBuildup = this.parseInt(config, "RetriesStreamBuildup", retriesStreamBuildup);
            reconnectCircuit = this.parseInt(config, "ReconnectCircuit", reconnectCircuit);
            queueTimeoutCircuit = this.parseInt(config, "QueueTimeoutCircuit", queueTimeoutCircuit);
            queueTimeoutResolve = this.parseInt(config, "QueueTimeoutResolve", queueTimeoutResolve);
            queueTimeoutStreamBuildup = this.parseInt(config, "QueueTimeoutStreamBuildup", queueTimeoutStreamBuildup);
            rankingTransferPerServerUpdate = this.parseFloat(config, "RankingTransferPerServerUpdate", rankingTransferPerServerUpdate, 0.0f, 1.0f);
            this.circuitClosesOnFailures = this.parseInt(config, "CircuitClosesOnFailures", this.circuitClosesOnFailures);
            circuitsMaximumNumber = this.parseInt(config, "circuitsMaximumNumber", circuitsMaximumNumber);
            this.veryAggressiveStreamBuilding = this.parseBoolean(config, "veryAggressiveStreamBuilding", this.veryAggressiveStreamBuilding);
            this.intervalDirectoryRefresh = this.parseInt(config, "DirectoryRefresh", this.intervalDirectoryRefresh);
        }
        catch (IOException e) {
            LOG.warn("TorConfig.readFromConfig(): Warning: " + e.getMessage());
        }
    }

    private static String readAllFromStream(InputStream in) {
        BufferedReader sin = new BufferedReader(new InputStreamReader(in));
        StringBuffer buf = new StringBuffer();
        try {
            String str = sin.readLine();
            while (str != null) {
                buf.append(str);
                buf.append("\n");
                str = sin.readLine();
            }
        }
        catch (IOException e) {
            LOG.debug("got IOException : {}", (Object)e.getMessage(), (Object)e);
        }
        return buf.toString();
    }

    private void writeToFile(String filename) {
        if (filename == null) {
            return;
        }
        try {
            StringBuffer config = new StringBuffer();
            LOG.debug("TorConfig.writeToFile(): {}", (Object)config);
            config.append(this.writeInt("StreamsPerCircuit", this.streamsPerCircuit));
            config.append(this.writeFloat("RankingIndexEffect", rankingIndexEffect));
            config.append(this.writeInt("RouteMinLength", TorConfig.getRouteMinLength()));
            config.append(this.writeInt("RouteMaxLength", TorConfig.getRouteMaxLength()));
            config.append(this.writeDouble("MinPercentage", TorConfig.getMinDescriptorsPercentage()));
            config.append(this.writeInt("MinDescriptors", this.minDescriptors));
            config.append(this.writeBoolean("RouteUniqClassC", this.routeUniqueClassC));
            config.append(this.writeBoolean("RouteUniqCountry", this.routeUniqueCountry));
            config.append(this.writeInt("AllowNodeMultipleCircuits", allowModeMultipleCircuits));
            for (String countryName : this.avoidedCountries) {
                config.append(this.writeString("AvoidCountry", countryName));
                LOG.debug("TorConfig.writeToFile: will avoid country {}", (Object)countryName);
            }
            for (byte[] fingerprint : this.avoidedNodeFingerprints) {
                String fingerprintStr = Encoding.toHexString(fingerprint);
                config.append(this.writeString("AvoidNode", fingerprintStr));
                LOG.debug("TorConfig.writeToFile: will avoid node {}", (Object)fingerprintStr);
            }
            config.append(this.writeInt("startupDelaySeconds", TorConfig.getStartupDelay()));
            config.append(this.writeString("nickname", this.nickname));
            config.append(this.writeInt("RetriesConnect", this.retriesConnect));
            config.append(this.writeInt("RetriesStreamBuildup", retriesStreamBuildup));
            config.append(this.writeInt("ReconnectCircuit", reconnectCircuit));
            config.append(this.writeInt("QueueTimeoutCircuit", queueTimeoutCircuit));
            config.append(this.writeInt("QueueTimeoutResolve", queueTimeoutResolve));
            config.append(this.writeInt("QueueTimeoutStreamBuildup", queueTimeoutStreamBuildup));
            config.append(this.writeInt("CircuitClosesOnFailures", this.circuitClosesOnFailures));
            config.append(this.writeInt("circuitsMaximumNumber", circuitsMaximumNumber));
            config.append(this.writeBoolean("veryAggressiveStreamBuilding", this.veryAggressiveStreamBuilding));
            config.append(this.writeFloat("RankingTransferPerServerUpdate", rankingTransferPerServerUpdate));
            config.append(this.writeInt("DirectoryRefresh", this.intervalDirectoryRefresh));
            FileWriter writer = new FileWriter(new File(filename));
            writer.write(config.toString());
            writer.close();
        }
        catch (IOException e) {
            LOG.warn("TorConfig.writeToFile(): Warning: " + e.getMessage());
        }
    }

    private static String getConfigDir() {
        String fileSeparator = System.getProperty("file.separator");
        if ("Linux".equals(TorConfig.operatingSystem())) {
            return System.getProperty("user.home") + fileSeparator + ".TorJava" + fileSeparator;
        }
        return System.getProperty("user.home") + fileSeparator + "TorJava" + fileSeparator;
    }

    public static String operatingSystem() {
        return System.getProperty("os.name");
    }

    public static boolean isCacheHiddenServiceDescriptor() {
        return cacheHiddenServiceDescriptor;
    }

    public static void setCacheHiddenServiceDescriptor(boolean cacheHiddenServiceDescriptor) {
        TorConfig.cacheHiddenServiceDescriptor = cacheHiddenServiceDescriptor;
    }

    public static boolean isSaveCircuitHistory() {
        return TorConfig.getInstance().saveCircuitHistory;
    }

    public void setSaveCircuitHistory(boolean saveCircuitHistory) {
        TorConfig.getInstance().saveCircuitHistory = saveCircuitHistory;
    }

    static {
        reconnectCircuit = 3;
        retriesStreamBuildup = 5;
        queueTimeoutCircuit = 10;
        queueTimeoutResolve = 5;
        queueTimeoutStreamBuildup = 5;
        circuitsMaximumNumber = 30;
        maxAllowedSetupDurationMs = 15000L;
        rankingTransferPerServerUpdate = 0.95f;
        rankingIndexEffect = 0.9f;
        allowModeMultipleCircuits = 3;
        cacheHiddenServiceDescriptor = true;
        TorConfig.reloadConfigFromProperties();
    }
}

