/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tor.common;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.http.conn.util.InetAddressUtils;
import org.silvertunnel_ng.netlib.api.util.TcpipNetAddress;
import org.silvertunnel_ng.netlib.layer.tor.api.Fingerprint;
import org.silvertunnel_ng.netlib.layer.tor.common.TorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TCPStreamProperties {
    private static final Logger LOG = LoggerFactory.getLogger(TCPStreamProperties.class);
    private static final int[] LONG_LIVED_PORTS = new int[]{21, 22, 706, 1863, 5050, 5190, 5222, 5223, 6667, 6697, 8300};
    private String hostname;
    private InetAddress addr;
    private boolean addrResolved;
    private boolean untrustedExitAllowed = true;
    private boolean nonGuardEntryAllowed = true;
    private boolean exitPolicyRequired = true;
    private boolean fastRoute = true;
    private boolean stableRoute = false;
    private int port;
    private int routeMinLength;
    private int routeMaxLength;
    private int connectRetries;
    private boolean connectToDirServer = false;
    private float rankingInfluenceIndex;
    private Fingerprint[] route;
    private Fingerprint customExitpoint;

    public TCPStreamProperties(String host, int port) {
        this.hostname = host;
        this.port = port;
        this.addrResolved = false;
        this.init();
    }

    public TCPStreamProperties(InetAddress addr, int port) {
        this.hostname = addr.getHostAddress();
        this.addr = addr;
        this.port = port;
        this.addrResolved = true;
        this.init();
    }

    public TCPStreamProperties(TcpipNetAddress address) {
        if (address.getIpaddress() != null) {
            this.hostname = null;
            try {
                this.addr = InetAddress.getByAddress(address.getIpaddress());
            }
            catch (UnknownHostException e) {
                LOG.warn("invalid address=" + address, (Throwable)e);
            }
            this.port = address.getPort();
            this.addrResolved = true;
        } else {
            this.hostname = address.getHostname();
            this.addr = null;
            this.port = address.getPort();
            this.addrResolved = false;
        }
        this.init();
    }

    public TCPStreamProperties() {
        this.hostname = null;
        this.addr = null;
        this.port = 0;
        this.addrResolved = false;
        this.init();
    }

    private void init() {
        this.routeMinLength = TorConfig.getRouteMinLength();
        this.routeMaxLength = TorConfig.getRouteMaxLength();
        this.rankingInfluenceIndex = 1.0f;
        this.connectRetries = TorConfig.retriesStreamBuildup;
    }

    public void setCustomRoute(Fingerprint[] route) {
        this.route = route;
    }

    public Fingerprint getCustomExitpoint() {
        return this.customExitpoint;
    }

    public void setCustomExitpoint(Fingerprint node) {
        this.customExitpoint = node;
        if (this.route == null) {
            this.routeMinLength = this.routeMaxLength;
            this.route = new Fingerprint[this.routeMaxLength];
        }
        this.route[this.route.length - 1] = node;
    }

    public Fingerprint[] getProposedRouteFingerprints() {
        return this.route;
    }

    public String getDestination() {
        if (this.hostname.length() > 0) {
            return this.hostname;
        }
        return this.addr.getHostAddress();
    }

    public float getRankingInfluenceIndex() {
        return this.rankingInfluenceIndex;
    }

    public void setRankingInfluenceIndex(float rankingInfluenceIndex) {
        this.rankingInfluenceIndex = rankingInfluenceIndex;
    }

    public void setMinRouteLength(int min) {
        if (min >= 0) {
            this.routeMinLength = min;
        }
    }

    public void setMaxRouteLength(int max) {
        if (max >= 0) {
            this.routeMaxLength = max;
        }
    }

    public int getMinRouteLength() {
        return this.routeMinLength;
    }

    public int getMaxRouteLength() {
        return this.routeMaxLength;
    }

    public String getHostname() {
        if (this.hostname == null && this.addr != null) {
            return this.addr.getHostAddress();
        }
        return this.hostname;
    }

    public void setAddr(InetAddress addr) {
        this.addr = addr;
    }

    public InetAddress getAddr() {
        if (this.addr == null && this.hostname != null && !this.hostname.isEmpty() && InetAddressUtils.isIPv4Address((String)this.hostname)) {
            try {
                String[] octets = this.hostname.split("\\.");
                byte[] ip = new byte[]{(byte)Integer.parseInt(octets[0]), (byte)Integer.parseInt(octets[1]), (byte)Integer.parseInt(octets[2]), (byte)Integer.parseInt(octets[3])};
                return InetAddress.getByAddress(ip);
            }
            catch (UnknownHostException e) {
                return this.addr;
            }
        }
        return this.addr;
    }

    public boolean isAddrResolved() {
        return this.addrResolved;
    }

    public void setAddrResolved(boolean addrResolved) {
        this.addrResolved = addrResolved;
    }

    public boolean isUntrustedExitAllowed() {
        return this.untrustedExitAllowed;
    }

    public void setUntrustedExitAllowed(boolean untrustedExitAllowed) {
        this.untrustedExitAllowed = untrustedExitAllowed;
    }

    public boolean isNonGuardEntryAllowed() {
        return this.nonGuardEntryAllowed;
    }

    public void setNonGuardEntryAllowed(boolean nonGuardEntryAllowed) {
        this.nonGuardEntryAllowed = nonGuardEntryAllowed;
    }

    public boolean isExitPolicyRequired() {
        return this.exitPolicyRequired;
    }

    public void setExitPolicyRequired(boolean exitPolicyRequired) {
        this.exitPolicyRequired = exitPolicyRequired;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getConnectRetries() {
        return this.connectRetries;
    }

    public void setConnectRetries(int connectRetries) {
        this.connectRetries = connectRetries;
    }

    public Fingerprint[] getRouteFingerprints() {
        return this.route;
    }

    public boolean isFastRoute() {
        return this.fastRoute;
    }

    public void setFastRoute(boolean fastRoute) {
        this.fastRoute = fastRoute;
    }

    public boolean isStableRoute() {
        if (this.stableRoute) {
            return true;
        }
        if (this.getPort() > 0) {
            for (int tmpPort : LONG_LIVED_PORTS) {
                if (this.getPort() != tmpPort) continue;
                return true;
            }
        }
        return false;
    }

    public void setStableRoute(boolean stableRoute) {
        this.stableRoute = stableRoute;
    }

    public boolean isConnectToDirServer() {
        return this.connectToDirServer;
    }

    public void setConnectToDirServer(boolean connectToDirServer) {
        this.connectToDirServer = connectToDirServer;
    }
}

