/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tor.common;

import com.maxmind.geoip.LookupService;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookupServiceUtil {
    private static final Logger LOG = LoggerFactory.getLogger(LookupServiceUtil.class);
    private static LookupService lookupService;

    public static String getCountryCodeOfIpAddress(InetAddress address) {
        String countryCode = null;
        if (lookupService != null) {
            countryCode = lookupService.getCountry(address.getAddress()).getCode();
        }
        if (countryCode == null || countryCode.length() < 1) {
            return "??";
        }
        return countryCode;
    }

    static {
        try {
            lookupService = new LookupService(LookupServiceUtil.class.getResourceAsStream("/com/maxmind/geoip/GeoIP.dat"), 2000000);
        }
        catch (Exception e) {
            LOG.error("LookupService could not be initialized", (Throwable)e);
        }
    }
}

