/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tor.clientimpl;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.silvertunnel_ng.netlib.api.NetLayerStatus;
import org.silvertunnel_ng.netlib.layer.tor.api.TorNetLayerStatus;
import org.silvertunnel_ng.netlib.layer.tor.circuit.Circuit;
import org.silvertunnel_ng.netlib.layer.tor.circuit.CircuitsStatus;
import org.silvertunnel_ng.netlib.layer.tor.circuit.Stream;
import org.silvertunnel_ng.netlib.layer.tor.circuit.TLSConnection;
import org.silvertunnel_ng.netlib.layer.tor.clientimpl.Tor;
import org.silvertunnel_ng.netlib.layer.tor.common.TCPStreamProperties;
import org.silvertunnel_ng.netlib.layer.tor.common.TorConfig;
import org.silvertunnel_ng.netlib.layer.tor.directory.DirectoryManagerThread;
import org.silvertunnel_ng.netlib.layer.tor.stream.TCPStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TorBackgroundMgmtThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(TorBackgroundMgmtThread.class);
    private static final int MILLISEC = 1000;
    private static final int INITIAL_INTERVAL_S = 3;
    protected static final int INTERVAL_S = 3;
    private static final int CIRCUITS_KEEP_ALIVE_INTERVAL_S = 30;
    private static final int STREAMS_KEEP_ALIVE_INTERVAL_S = 30;
    private static long idleThreadCounter = 0L;
    private final Tor tor;
    private long currentTimeMillis;
    private final List<Thread> backgroundThreads = new ArrayList<Thread>(TorConfig.getMinimumIdleCircuits());
    private boolean stopped = false;
    private final DirectoryManagerThread directoryManagerThread;

    TorBackgroundMgmtThread(Tor tor) {
        this.tor = tor;
        this.currentTimeMillis = System.currentTimeMillis();
        this.spawnIdleCircuits(TorConfig.getMinimumIdleCircuits());
        this.directoryManagerThread = new DirectoryManagerThread(tor.getDirectory());
        this.setName(this.getClass().getName());
        this.setDaemon(true);
        this.start();
    }

    private void spawnIdleCircuits(int amount) {
        if (this.tor.getDirectory().isDirectoryReady()) {
            if (amount > 0) {
                LOG.info("TorBackgroundMgmtThread.spawnIdleCircuits: Spawn {} new circuits", (Object)amount);
            }
        } else {
            LOG.debug("Not yet spawning circuits (too few routers known until now)");
            return;
        }
        ListIterator<Thread> brtIterator = this.backgroundThreads.listIterator();
        while (brtIterator.hasNext()) {
            Thread brt = brtIterator.next();
            if (brt.isAlive()) continue;
            brtIterator.remove();
        }
        if (amount > 0) {
            this.tor.updateStatus(TorNetLayerStatus.INITIAL_CIRCUITES_ESTABLISHING);
        }
        for (int i = 0; i < amount; ++i) {
            Thread brt = new Thread(){

                @Override
                public void run() {
                    try {
                        TCPStreamProperties sp = new TCPStreamProperties();
                        sp.setFastRoute(true);
                        sp.setPort(80);
                        new Circuit(TorBackgroundMgmtThread.this.tor.getTlsConnectionAdmin(), TorBackgroundMgmtThread.this.tor.getDirectory(), sp, TorBackgroundMgmtThread.this.tor.getTorEventService(), null);
                    }
                    catch (Exception e) {
                        LOG.debug("TorBackgroundMgmtThread.spawnIdleCircuits got Exception: {}", (Object)e.getMessage(), (Object)e);
                    }
                }
            };
            LOG.debug("TorBackgroundMgmtThread.spawnIdleCircuits: Circuit-Spawning thread started.");
            brt.setName("Idle Thread " + idleThreadCounter++);
            brt.start();
            this.backgroundThreads.add(brt);
        }
    }

    private void sendKeepAlivePackets() {
        for (TLSConnection tls : this.tor.getTlsConnectionAdmin().getConnections()) {
            for (Circuit c : tls.getCircuits()) {
                if (c.isEstablished() && this.currentTimeMillis - c.getLastCell() > 30000L) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("TorBackgroundMgmtThread.sendKeepAlivePackets(): Circuit " + c.toString());
                    }
                    c.sendKeepAlive();
                }
                for (Stream streamX : c.getStreams().values()) {
                    TCPStream stream = (TCPStream)streamX;
                    if (!stream.isEstablished() || stream.isClosed() || this.currentTimeMillis - stream.getLastCellSentDate() <= 30000L) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("TorBackgroundMgmt.sendKeepAlivePackets(): Stream " + stream.toString());
                    }
                    stream.sendKeepAlive();
                }
            }
        }
    }

    private void manageIdleCircuits() {
        CircuitsStatus circuitsStatus = this.tor.getCircuitsStatus();
        if (LOG.isDebugEnabled()) {
            LOG.debug("TorBackgroundMgmt.manageIdleCircuits(): circuit counts: " + (circuitsStatus.getCircuitsAlive() - circuitsStatus.getCircuitsEstablished()) + " building, " + circuitsStatus.getCircuitsEstablished() + " established + " + circuitsStatus.getCircuitsClosed() + " closed = " + circuitsStatus.getCircuitsTotal());
        }
        if (circuitsStatus.getCircuitsAlive() + Circuit.numberOfCircuitsInConstructor < TorConfig.getMinimumIdleCircuits()) {
            this.spawnIdleCircuits((TorConfig.getMinimumIdleCircuits() - circuitsStatus.getCircuitsAlive()) * 3 / 2);
        } else if (circuitsStatus.getCircuitsEstablished() > TorConfig.getMinimumIdleCircuits() + TorConfig.circuitsMaximumNumber && LOG.isDebugEnabled()) {
            LOG.debug("TorBackgroundMgmtThread.manageIdleCircuits(): kill " + (TorConfig.getMinimumIdleCircuits() + TorConfig.circuitsMaximumNumber - circuitsStatus.getCircuitsAlive()) + "new circuits (FIXME)");
        }
    }

    private void tearDownClosedCircuits() {
        for (TLSConnection tls : this.tor.getTlsConnectionAdmin().getConnections()) {
            LOG.debug("check tls={}", (Object)tls);
            if (tls.isClosed()) {
                LOG.debug("remove tls={}", (Object)tls);
                this.tor.getTlsConnectionAdmin().removeConnection(tls);
            }
            for (Circuit c : tls.getCircuitMap().values()) {
                for (Stream streamX : c.getStreams().values()) {
                    TCPStream s = (TCPStream)streamX;
                    long diff = (this.currentTimeMillis - s.getLastAction()) / 1000L;
                    if (!s.isEstablished() || s.isClosed()) {
                        if (diff > (long)(2 * TorConfig.queueTimeoutStreamBuildup)) {
                            LOG.debug("TorBackgroundMgmtThread.tearDownClosedCircuits(): closing stream (too long building) " + s.toString());
                            s.close(true);
                            continue;
                        }
                        LOG.debug("Checked {} {}", (Object)diff, (Object)s.getRoute());
                        continue;
                    }
                    LOG.debug("OK {} {}", (Object)diff, (Object)s.getRoute());
                }
                if (!c.isEstablished() && !c.isClosed() && (this.currentTimeMillis - c.getLastAction()) / 1000L > (long)(2 * TorConfig.queueTimeoutCircuit)) {
                    LOG.debug("TorBackgroundMgmtThread.tearDownClosedCircuits(): closing (too long building) " + c.toString());
                    c.close(false);
                }
                if (c.getEstablishedStreams() > TorConfig.getStreamsPerCircuit()) {
                    LOG.debug("TorBackgroundMgmtThread.tearDownClosedCircuits(): closing (maximum streams) " + c.toString());
                    c.close(false);
                }
                if (c.isClosed()) {
                    c.close(false);
                }
                if (!c.isDestruct()) continue;
                LOG.debug("TorBackgroundMgmtThread.tearDownClosedCircuits(): destructing circuit " + c.toString());
                tls.removeCircuit(c.getId());
            }
        }
    }

    public void close() {
        this.directoryManagerThread.setStopped(true);
        this.directoryManagerThread.interrupt();
        this.stopped = true;
        this.interrupt();
    }

    public void cleanup() {
        ListIterator<Thread> brtIterator = this.backgroundThreads.listIterator();
        while (brtIterator.hasNext()) {
            Thread brt = brtIterator.next();
            if (brt.isAlive()) {
                brt.interrupt();
            }
            brtIterator.remove();
        }
    }

    @Override
    public void run() {
        try {
            TorBackgroundMgmtThread.sleep(3000L);
        }
        catch (InterruptedException e) {
            LOG.debug("got IterruptedException : {}", (Object)e.getMessage(), (Object)e);
        }
        while (!this.stopped) {
            try {
                this.currentTimeMillis = System.currentTimeMillis();
                this.manageIdleCircuits();
                this.tearDownClosedCircuits();
                this.sendKeepAlivePackets();
                if (this.tor.getCircuitsStatus().getCircuitsEstablished() >= TorConfig.getMinimumIdleCircuits()) {
                    this.tor.updateStatus(NetLayerStatus.READY);
                }
                TorBackgroundMgmtThread.sleep(3000L);
            }
            catch (InterruptedException e) {
                LOG.error("stop thread1", (Throwable)e);
                break;
            }
            catch (Exception e) {
                LOG.error("stop thread2", (Throwable)e);
                break;
            }
        }
        this.cleanup();
    }
}

