/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tor.clientimpl;

import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.silvertunnel_ng.netlib.api.NetLayer;
import org.silvertunnel_ng.netlib.api.NetLayerStatus;
import org.silvertunnel_ng.netlib.api.util.IpNetAddress;
import org.silvertunnel_ng.netlib.layer.tor.api.Router;
import org.silvertunnel_ng.netlib.layer.tor.api.TorNetLayerStatus;
import org.silvertunnel_ng.netlib.layer.tor.circuit.Circuit;
import org.silvertunnel_ng.netlib.layer.tor.circuit.CircuitAdmin;
import org.silvertunnel_ng.netlib.layer.tor.circuit.CircuitsStatus;
import org.silvertunnel_ng.netlib.layer.tor.circuit.HiddenServicePortInstance;
import org.silvertunnel_ng.netlib.layer.tor.circuit.TLSConnection;
import org.silvertunnel_ng.netlib.layer.tor.circuit.TLSConnectionAdmin;
import org.silvertunnel_ng.netlib.layer.tor.clientimpl.HiddenServiceClient;
import org.silvertunnel_ng.netlib.layer.tor.clientimpl.HiddenServiceServer;
import org.silvertunnel_ng.netlib.layer.tor.clientimpl.TorBackgroundMgmtThread;
import org.silvertunnel_ng.netlib.layer.tor.common.TCPStreamProperties;
import org.silvertunnel_ng.netlib.layer.tor.common.TorConfig;
import org.silvertunnel_ng.netlib.layer.tor.common.TorEventService;
import org.silvertunnel_ng.netlib.layer.tor.directory.Directory;
import org.silvertunnel_ng.netlib.layer.tor.directory.RouterImpl;
import org.silvertunnel_ng.netlib.layer.tor.hiddenservice.HiddenServiceProperties;
import org.silvertunnel_ng.netlib.layer.tor.stream.ClosingThread;
import org.silvertunnel_ng.netlib.layer.tor.stream.ResolveStream;
import org.silvertunnel_ng.netlib.layer.tor.stream.StreamThread;
import org.silvertunnel_ng.netlib.layer.tor.stream.TCPStream;
import org.silvertunnel_ng.netlib.layer.tor.util.NetLayerStatusAdmin;
import org.silvertunnel_ng.netlib.layer.tor.util.PrivateKeyHandler;
import org.silvertunnel_ng.netlib.layer.tor.util.TorException;
import org.silvertunnel_ng.netlib.layer.tor.util.TorNoAnswerException;
import org.silvertunnel_ng.netlib.util.StringStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tor
implements NetLayerStatusAdmin {
    private static final Logger LOG = LoggerFactory.getLogger(Tor.class);
    private static final int TOR_CONNECT_MAX_RETRIES = 10;
    private static final long TOR_CONNECT_MILLISECONDS_BETWEEN_RETRIES = 10L;
    private Directory directory;
    private TLSConnectionAdmin tlsConnectionAdmin;
    private TorBackgroundMgmtThread torBackgroundMgmtThread;
    private PrivateKeyHandler privateKeyHandler;
    private long startupPhaseWithoutConnects;
    private final NetLayer lowerTlsConnectionNetLayer;
    private final NetLayer lowerDirConnectionNetLayer;
    private final StringStorage stringStorage;
    private final TorEventService torEventService = new TorEventService();
    private boolean gaveMessage = false;
    private boolean startUpInProgress = true;
    private NetLayerStatus status = TorNetLayerStatus.NEW;

    public Tor(NetLayer lowerTlsConnectionNetLayer, NetLayer lowerDirConnectionNetLayer, StringStorage stringStorage) throws IOException {
        this.lowerTlsConnectionNetLayer = lowerTlsConnectionNetLayer;
        this.lowerDirConnectionNetLayer = lowerDirConnectionNetLayer;
        this.stringStorage = stringStorage;
        this.initLocalSystem(false);
        this.initDirectory();
        this.initRemoteAccess();
    }

    private void initLocalSystem(boolean noLocalFileSystemAccess) throws IOException {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        LOG.info("Tor implementation of silvertunnel-ng.org is starting up");
        this.privateKeyHandler = new PrivateKeyHandler();
        this.startupPhaseWithoutConnects = System.currentTimeMillis() + (long)TorConfig.getStartupDelay() * 1000L;
    }

    private void initDirectory() throws IOException {
        this.directory = new Directory(this.stringStorage, this.lowerDirConnectionNetLayer, this.privateKeyHandler.getIdentity(), this);
    }

    private void initRemoteAccess() throws IOException {
        this.tlsConnectionAdmin = new TLSConnectionAdmin(this.lowerTlsConnectionNetLayer, this.privateKeyHandler);
        this.torBackgroundMgmtThread = new TorBackgroundMgmtThread(this);
    }

    public Collection<Router> getValidTorRouters() {
        Collection<RouterImpl> resultBase = this.directory.getValidRoutersByFingerprint().values();
        ArrayList<Router> result = new ArrayList<Router>(resultBase.size());
        for (RouterImpl r : resultBase) {
            result.add(r.cloneReliable());
        }
        return result;
    }

    public TCPStream connect(TCPStreamProperties sp, NetLayer torNetLayer) throws IOException {
        int retry;
        if (sp.getHostname() == null && sp.getAddr() == null) {
            throw new IOException("Tor: no hostname and no address provided");
        }
        this.checkStartup();
        if (sp.getHostname() != null && sp.getHostname().endsWith(".onion")) {
            return HiddenServiceClient.connectToHiddenService(this.directory, this.torEventService, this.tlsConnectionAdmin, torNetLayer, sp);
        }
        String hostnameAddress = null;
        int minIdleCircuits = Math.min(2, TorConfig.getMinimumIdleCircuits());
        for (retry = 0; retry <= 10; ++retry) {
            this.waitForIdleCircuits(minIdleCircuits);
            Circuit[] circuits = CircuitAdmin.provideSuitableCircuits(this.tlsConnectionAdmin, this.directory, sp, this.torEventService, false);
            if (circuits == null || circuits.length < 1) {
                LOG.debug("no valid circuit found: wait for new one created by the TorBackgroundMgmtThread");
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    LOG.debug("got IterruptedException : {}", (Object)e.getMessage(), (Object)e);
                }
                continue;
            }
            if (TorConfig.isVeryAggressiveStreamBuilding()) {
                for (int j = 0; j < circuits.length; ++j) {
                    try {
                        StreamThread[] streamThreads = new StreamThread[circuits.length];
                        for (int i = 0; i < circuits.length; ++i) {
                            streamThreads[i] = new StreamThread(circuits[i], sp);
                        }
                        int chosenStream = -1;
                        for (int waitingCounter = TorConfig.queueTimeoutStreamBuildup * 1000 / 10; chosenStream < 0 && waitingCounter >= 0; --waitingCounter) {
                            boolean atLeastOneAlive = false;
                            for (int i = 0; i < circuits.length && chosenStream < 0; ++i) {
                                if (!streamThreads[i].isAlive()) {
                                    if (streamThreads[i].getStream() == null || !streamThreads[i].getStream().isEstablished()) continue;
                                    chosenStream = i;
                                    continue;
                                }
                                atLeastOneAlive = true;
                            }
                            if (!atLeastOneAlive) break;
                            long SLEEPING_MS = 10L;
                            try {
                                Thread.sleep(10L);
                                continue;
                            }
                            catch (InterruptedException e) {
                                LOG.debug("got IterruptedException : {}", (Object)e.getMessage(), (Object)e);
                            }
                        }
                        if (chosenStream < 0) continue;
                        TCPStream returnValue = streamThreads[chosenStream].getStream();
                        new ClosingThread(streamThreads, chosenStream);
                        return returnValue;
                    }
                    catch (Exception e) {
                        LOG.warn("Tor.connect(): " + e.getMessage());
                        return null;
                    }
                }
            } else {
                for (int i = 0; i < circuits.length; ++i) {
                    try {
                        return new TCPStream(circuits[i], sp);
                    }
                    catch (TorNoAnswerException e) {
                        LOG.warn("Tor.connect: Timeout on circuit:" + e.getMessage());
                        continue;
                    }
                    catch (TorException e) {
                        LOG.warn("Tor.connect: TorException trying to reuse existing circuit:" + e.getMessage(), (Throwable)e);
                        continue;
                    }
                    catch (IOException e) {
                        LOG.warn("Tor.connect: IOException " + e.getMessage());
                    }
                }
            }
            hostnameAddress = sp.getAddr() != null ? "" + sp.getAddr() : sp.getHostname();
            LOG.info("Tor.connect: not (yet) connected to " + hostnameAddress + ":" + sp.getPort() + ", full retry count=" + retry);
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException e) {
                LOG.debug("got IterruptedException : {}", (Object)e.getMessage(), (Object)e);
            }
        }
        hostnameAddress = sp.getAddr() != null ? "" + sp.getAddr() : sp.getHostname();
        throw new IOException("Tor.connect: unable to connect to " + hostnameAddress + ":" + sp.getPort() + " after " + retry + " full retries with " + sp.getConnectRetries() + " sub retries");
    }

    public void provideHiddenService(NetLayer torNetLayerToConnectToDirectoryService, HiddenServiceProperties service, HiddenServicePortInstance hiddenServicePortInstance) throws IOException, TorException {
        this.checkStartup();
        HiddenServiceServer.getInstance().provideHiddenService(this.directory, this.torEventService, this.tlsConnectionAdmin, torNetLayerToConnectToDirectoryService, service, hiddenServicePortInstance);
    }

    public void close(boolean force) {
        LOG.info("TorJava ist closing down");
        this.torBackgroundMgmtThread.close();
        this.tlsConnectionAdmin.close(force);
        this.directory.close();
        TorConfig.close();
        LOG.info("Tor.close(): CLOSED");
    }

    public void close() {
        this.close(false);
    }

    public IpNetAddress resolve(String hostname) throws IOException {
        Object o = this.resolveInternal(hostname);
        if (o instanceof IpNetAddress) {
            return (IpNetAddress)o;
        }
        return null;
    }

    public String resolve(IpNetAddress addr) throws IOException {
        byte[] a = addr.getIpaddress();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            sb.append(a[3 - i] & 0xFF);
            sb.append('.');
        }
        sb.append("in-addr.arpa");
        Object o = this.resolveInternal(sb.toString());
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    private Object resolveInternal(String query) throws IOException {
        try {
            this.checkStartup();
            for (TLSConnection tls : this.tlsConnectionAdmin.getConnections()) {
                for (Circuit circuit : tls.getCircuits()) {
                    try {
                        if (!circuit.isEstablished()) continue;
                        ResolveStream rs = new ResolveStream(circuit);
                        Object o = rs.resolve(query);
                        rs.close();
                        return o;
                    }
                    catch (Exception e) {
                        LOG.debug("got Exception : {}", (Object)e.getMessage(), (Object)e);
                    }
                }
            }
            TCPStreamProperties streamProperties = new TCPStreamProperties();
            Circuit[] rsCircuit = CircuitAdmin.provideSuitableCircuits(this.tlsConnectionAdmin, this.directory, streamProperties, this.torEventService, false);
            ResolveStream rs = new ResolveStream(rsCircuit[0]);
            Object o = rs.resolve(query);
            rs.close();
            return o;
        }
        catch (TorException e) {
            throw new IOException("Error in Tor: " + e.getMessage());
        }
    }

    @Override
    public void setStatus(NetLayerStatus newStatus) {
        LOG.debug("TorNetLayer old status: {}", (Object)this.status);
        this.status = newStatus;
        LOG.info("TorNetLayer new status: {}", (Object)this.status);
    }

    @Override
    public void updateStatus(NetLayerStatus newStatus) {
        if (this.getStatus().getReadyIndicator() < newStatus.getReadyIndicator()) {
            this.setStatus(newStatus);
        }
    }

    @Override
    public NetLayerStatus getStatus() {
        return this.status;
    }

    public void checkStartup() {
        if (!this.startUpInProgress) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now >= this.startupPhaseWithoutConnects) {
            this.startUpInProgress = false;
            return;
        }
        long sleep = this.startupPhaseWithoutConnects - System.currentTimeMillis();
        if (!this.gaveMessage) {
            this.gaveMessage = true;
            LOG.debug("Tor.checkStartup(): Tor is still in startup phase, sleeping for max. {} seconds", (Object)(sleep / 1000L));
            LOG.debug("Tor not yet started - wait until torServers available");
        }
        this.waitForIdleCircuits(TorConfig.getMinimumIdleCircuits());
        try {
            Thread.sleep(500L);
        }
        catch (Exception e) {
            LOG.debug("got Exception : {}", (Object)e.getMessage(), (Object)e);
        }
        LOG.info("Tor start completed!!!");
        this.startUpInProgress = false;
    }

    private void waitForIdleCircuits(int minExpectedIdleCircuits) {
        while (!this.directory.isDirectoryReady() || this.getCircuitsStatus().getCircuitsEstablished() < minExpectedIdleCircuits) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                LOG.debug("got Exception : {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public HashSet<Circuit> getCurrentCircuits() {
        HashSet<Circuit> allCircs = new HashSet<Circuit>();
        for (TLSConnection tls : this.tlsConnectionAdmin.getConnections()) {
            for (Circuit circuit : tls.getCircuits()) {
                allCircs.add(circuit);
            }
        }
        return allCircs;
    }

    public CircuitsStatus getCircuitsStatus() {
        int circuitsTotal = 0;
        int circuitsAlive = 0;
        int circuitsEstablished = 0;
        int circuitsClosed = 0;
        for (TLSConnection tls : this.tlsConnectionAdmin.getConnections()) {
            for (Circuit c : tls.getCircuits()) {
                String flag = "";
                ++circuitsTotal;
                if (c.isClosed()) {
                    flag = "C";
                    ++circuitsClosed;
                    continue;
                }
                flag = "B";
                ++circuitsAlive;
                if (!c.isEstablished()) continue;
                flag = "E";
                ++circuitsEstablished;
            }
        }
        CircuitsStatus result = new CircuitsStatus();
        result.setCircuitsTotal(circuitsTotal);
        result.setCircuitsAlive(circuitsAlive);
        result.setCircuitsEstablished(circuitsEstablished);
        result.setCircuitsClosed(circuitsClosed);
        return result;
    }

    public void clear() {
        CircuitAdmin.clear(this.tlsConnectionAdmin);
    }

    public TorEventService getTorEventService() {
        return this.torEventService;
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public TLSConnectionAdmin getTlsConnectionAdmin() {
        return this.tlsConnectionAdmin;
    }

    public NetLayer getLowerTlsConnectionNetLayer() {
        return this.lowerTlsConnectionNetLayer;
    }

    public NetLayer getLowerDirConnectionNetLayer() {
        return this.lowerDirConnectionNetLayer;
    }

    public PrivateKeyHandler getPrivateKeyHandler() {
        return this.privateKeyHandler;
    }
}

