/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tor.clientimpl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.silvertunnel_ng.netlib.api.NetLayer;
import org.silvertunnel_ng.netlib.api.util.TcpipNetAddress;
import org.silvertunnel_ng.netlib.layer.tor.circuit.Circuit;
import org.silvertunnel_ng.netlib.layer.tor.circuit.CircuitAdmin;
import org.silvertunnel_ng.netlib.layer.tor.circuit.HiddenServiceInstance;
import org.silvertunnel_ng.netlib.layer.tor.circuit.HiddenServicePortInstance;
import org.silvertunnel_ng.netlib.layer.tor.circuit.TLSConnectionAdmin;
import org.silvertunnel_ng.netlib.layer.tor.circuit.cells.CellRelayEstablishIntro;
import org.silvertunnel_ng.netlib.layer.tor.common.TCPStreamProperties;
import org.silvertunnel_ng.netlib.layer.tor.common.TorEventService;
import org.silvertunnel_ng.netlib.layer.tor.directory.Directory;
import org.silvertunnel_ng.netlib.layer.tor.directory.RendezvousServiceDescriptorService;
import org.silvertunnel_ng.netlib.layer.tor.directory.RendezvousServiceDescriptorUtil;
import org.silvertunnel_ng.netlib.layer.tor.directory.RouterImpl;
import org.silvertunnel_ng.netlib.layer.tor.directory.SDIntroductionPoint;
import org.silvertunnel_ng.netlib.layer.tor.hiddenservice.HiddenServiceProperties;
import org.silvertunnel_ng.netlib.layer.tor.util.Encoding;
import org.silvertunnel_ng.netlib.layer.tor.util.TorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiddenServiceServer {
    private static final Logger LOG = LoggerFactory.getLogger(HiddenServiceServer.class);
    private static Map<String, HiddenServiceInstance> allHiddenServices = new HashMap<String, HiddenServiceInstance>();
    private static HiddenServiceServer instance = new HiddenServiceServer();

    public static HiddenServiceServer getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void provideHiddenService(final Directory directory, final TorEventService torEventService, final TLSConnectionAdmin tlsConnectionAdmin, NetLayer torNetLayerToConnectToDirectoryService, final HiddenServiceProperties hiddenServiceProps, HiddenServicePortInstance hiddenServicePortInstance) throws IOException, TorException {
        HiddenServiceInstance hiddenServiceInstance = null;
        String hiddenServicePermanentIdBase32 = RendezvousServiceDescriptorUtil.calculateZFromPublicKey(hiddenServiceProps.getPublicKey());
        Map<String, HiddenServiceInstance> map = allHiddenServices;
        synchronized (map) {
            hiddenServiceInstance = allHiddenServices.get(hiddenServicePermanentIdBase32);
            if (hiddenServiceInstance == null) {
                hiddenServiceInstance = new HiddenServiceInstance(hiddenServiceProps);
                allHiddenServices.put(hiddenServicePermanentIdBase32, hiddenServiceInstance);
                hiddenServiceInstance.putHiddenServicePortInstance(hiddenServicePortInstance);
            } else {
                hiddenServiceInstance.putHiddenServicePortInstance(hiddenServicePortInstance);
            }
        }
        ExecutorService executor = Executors.newCachedThreadPool();
        while (hiddenServiceProps.getNumberOfIntroPoints() < hiddenServiceProps.getMinimumNumberOfIntroPoints()) {
            LOG.debug("establish circuits to (randomly chosen) introduction points for {}", (Object)hiddenServicePortInstance);
            ArrayList<1> allTasks = new ArrayList<1>();
            int TRY_MORE_NUMBER_OF_INTRO_POINTS = 2;
            for (int i = hiddenServiceProps.getNumberOfIntroPoints(); i < hiddenServiceProps.getMinimumNumberOfIntroPoints() + 2; ++i) {
                final HiddenServiceInstance hiddenServiceInstanceFinal = hiddenServiceInstance;
                Callable<Circuit> callable = new Callable<Circuit>(){

                    @Override
                    public Circuit call() throws Exception {
                        LOG.debug("Callable Started..");
                        TCPStreamProperties spIntro = new TCPStreamProperties();
                        spIntro.setExitPolicyRequired(false);
                        Circuit result = HiddenServiceServer.this.establishIntroductionPoint(directory, torEventService, tlsConnectionAdmin, hiddenServiceProps, spIntro, hiddenServiceInstanceFinal);
                        LOG.debug("Callable Finished!");
                        return result;
                    }
                };
                allTasks.add(callable);
            }
            LOG.debug("start to execute the tasks in parallel");
            int TIMEOUT_SECONDS = 120;
            List allTaskResults = null;
            try {
                allTaskResults = executor.invokeAll(allTasks, 120L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                LOG.info("Exception in background task", (Throwable)e);
            }
            for (Future future : allTaskResults) {
                try {
                    LOG.debug("analyse taskResult={}", (Object)future);
                    Circuit c = (Circuit)future.get();
                    if (c == null) continue;
                    RouterImpl introPointRouter = c.getRouteNodes()[c.getRouteEstablished() - 1].getRouter();
                    LOG.info("Tor.provideHiddenService: establish introduction point at " + introPointRouter.getNickname());
                    hiddenServiceProps.addIntroPoint(new SDIntroductionPoint(Encoding.toBase32(introPointRouter.getFingerprint().getBytes()), new TcpipNetAddress(introPointRouter.getAddress().getAddress(), introPointRouter.getOrPort()), introPointRouter.getOnionKey(), hiddenServiceProps.getPublicKey()));
                }
                catch (InterruptedException e) {
                    LOG.debug("task interruped");
                }
                catch (Exception e) {
                    LOG.info("in background task", (Throwable)e);
                }
            }
            LOG.info("(server side) circuit(s) to hidden service introduction point(s)==" + hiddenServiceProps.getIntroPoints() + " established for " + hiddenServicePortInstance);
        }
        executor.shutdown();
        LOG.debug("establish circuits finished introduction points for {}", (Object)hiddenServicePortInstance);
        RendezvousServiceDescriptorService.getInstance().putRendezvousServiceDescriptorToDirectory(directory, torNetLayerToConnectToDirectoryService, hiddenServiceProps);
    }

    private Circuit establishIntroductionPoint(Directory directory, TorEventService torEventService, TLSConnectionAdmin tlsConnectionAdmin, HiddenServiceProperties service, TCPStreamProperties spIntro, HiddenServiceInstance hiddenServiceInstance) {
        Circuit circuit = null;
        for (int i = 0; i < spIntro.getConnectRetries(); ++i) {
            try {
                circuit = CircuitAdmin.provideSuitableExclusiveCircuit(tlsConnectionAdmin, directory, spIntro, torEventService);
                if (circuit != null && circuit.isEstablished()) {
                    circuit.setHiddenServiceInstanceForIntroduction(hiddenServiceInstance);
                    LOG.debug("Tor.provideHiddenService: send relay_establish_intro-Cell over {}", (Object)circuit.toString());
                    circuit.sendCell(new CellRelayEstablishIntro(circuit, service));
                    circuit.receiveRelayCell(38);
                    return circuit;
                }
                LOG.warn("could not establish Circuit to introduction point with spIntro=" + spIntro);
                Thread.sleep(5000L);
                continue;
            }
            catch (Exception e) {
                LOG.warn("Tor.provideHiddenService: " + e.getMessage(), (Throwable)e);
                if (circuit == null) continue;
                circuit.close(true);
            }
        }
        return null;
    }
}

