/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tor.circuit.cells;

import java.io.IOException;
import java.io.InputStream;
import org.silvertunnel_ng.netlib.layer.tor.circuit.Circuit;
import org.silvertunnel_ng.netlib.layer.tor.util.Encoding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cell {
    private static final Logger LOG = LoggerFactory.getLogger(Cell.class);
    public static final int CELL_PADDING = 0;
    public static final int CELL_CREATE = 1;
    public static final int CELL_CREATED = 2;
    public static final int CELL_RELAY = 3;
    public static final int CELL_DESTROY = 4;
    public static final int CELL_CREATE_FAST = 5;
    public static final int CELL_CREATED_FAST = 6;
    public static final int CELL_RELAY_EARLY = 9;
    static final int CELL_TOTAL_SIZE = 512;
    static final int CELL_CIRCID_SIZE = 2;
    static final int CELL_COMMAND_SIZE = 1;
    static final int CELL_PAYLOAD_SIZE = 509;
    static final int CELL_CIRCID_POS = 0;
    static final int CELL_COMMAND_POS = 2;
    static final int CELL_PAYLOAD_POS = 3;
    private static final String[] TYPE_TO_STRING = new String[]{"padding", "create", "created", "relay", "destroy", "create-fast", "created-fast", "", "", "relay-early"};
    private int circuitId;
    private byte command;
    protected byte[] payload;
    protected Circuit outCircuit;

    Cell(Circuit outCircuit, int command) {
        this.payload = new byte[509];
        this.circuitId = outCircuit.getId();
        this.command = Encoding.intToNByteArray(command, 1)[0];
        this.outCircuit = outCircuit;
    }

    Cell(byte[] data) throws NullPointerException {
        this.initFromData(data);
    }

    public Cell(InputStream in) throws IOException {
        int n;
        if (in == null) {
            throw new IOException("null as input stream given");
        }
        byte[] data = new byte[512];
        for (int filled = 0; filled < data.length; filled += n) {
            n = in.read(data, filled, data.length - filled);
            if (n < 0) {
                throw new IOException("Cell.<init>: reached EOF");
            }
            Thread.yield();
        }
        this.initFromData(data);
    }

    private void initFromData(byte[] data) throws NullPointerException {
        if (data == null) {
            throw new NullPointerException("no data given");
        }
        this.payload = new byte[509];
        this.circuitId = Encoding.byteArrayToInt(data, 0, 2);
        this.command = data[2];
        System.arraycopy(data, 3, this.payload, 0, this.payload.length);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cell.initFromData: " + this.toString("Received "));
        }
    }

    public byte[] toByteArray() {
        byte[] buff = new byte[512];
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cell.toByteArray(): " + this.toString("Sending "));
        }
        System.arraycopy(Encoding.intToNByteArray(this.circuitId, 2), 0, buff, 0, 2);
        buff[2] = this.command;
        System.arraycopy(this.payload, 0, buff, 3, this.payload.length);
        return buff;
    }

    public String toString() {
        return this.toString("");
    }

    private String toString(String description) {
        return description + "cell for circuit " + this.getCircuitId() + " with command " + this.type() + ". Payload:\n" + Encoding.toHexString(this.payload, 100);
    }

    public static String type(int t) {
        if (t >= 0 && t < TYPE_TO_STRING.length) {
            return TYPE_TO_STRING[t];
        }
        return "[" + t + "]";
    }

    public String type() {
        return Cell.type(this.command);
    }

    public final boolean isTypePadding() {
        return this.command == 0;
    }

    public final boolean isTypeCreated() {
        return this.command == 2;
    }

    public final boolean isTypeRelay() {
        return this.command == 3;
    }

    public final boolean isTypeDestroy() {
        return this.command == 4;
    }

    public int getCircuitId() {
        return this.circuitId;
    }

    public byte getCommand() {
        return this.command;
    }

    public void setCommand(byte command) {
        this.command = command;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    public Circuit getOutCircuit() {
        return this.outCircuit;
    }

    public void setOutCircuit(Circuit outCircuit) {
        this.outCircuit = outCircuit;
    }
}

