/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tor.circuit;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.SocketTimeoutException;
import org.silvertunnel_ng.netlib.layer.tor.circuit.Circuit;
import org.silvertunnel_ng.netlib.layer.tor.circuit.Stream;
import org.silvertunnel_ng.netlib.layer.tor.circuit.TLSConnection;
import org.silvertunnel_ng.netlib.layer.tor.circuit.cells.Cell;
import org.silvertunnel_ng.netlib.layer.tor.circuit.cells.CellDestroy;
import org.silvertunnel_ng.netlib.layer.tor.circuit.cells.CellRelay;
import org.silvertunnel_ng.netlib.layer.tor.util.TorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TLSDispatcherThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(TLSDispatcherThread.class);
    private final DataInputStream sin;
    private final TLSConnection tls;
    private boolean stopped;

    TLSDispatcherThread(TLSConnection tls, DataInputStream sin) {
        this.tls = tls;
        this.sin = sin;
        this.setName("TLSDispatcher for " + tls.getRouter().getNickname());
        this.start();
    }

    public void close() {
        this.stopped = true;
        this.interrupt();
    }

    @Override
    public void run() {
        boolean dispatched = false;
        while (!this.stopped) {
            Cell cell;
            block41: {
                cell = null;
                try {
                    cell = new Cell(this.sin);
                }
                catch (IOException e) {
                    if (e instanceof SocketTimeoutException) {
                        LOG.debug("TLSDispatcher.run: {} connection error: socket timeout", (Object)this.getName(), (Object)e);
                        continue;
                    }
                    LOG.info("TLSDispatcher.run: connection error: " + e.getMessage(), (Throwable)e);
                    this.stopped = true;
                    break;
                }
                if (cell.isTypePadding()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("TLSDispatcher.run: padding cell from {}", (Object)this.tls.getRouter().getNickname());
                    }
                } else {
                    dispatched = false;
                    int cellCircId = cell.getCircuitId();
                    Circuit circ = this.tls.getCircuit(cellCircId);
                    if (circ != null) {
                        if (cell.isTypeRelay()) {
                            CellRelay relay = null;
                            try {
                                int streamId;
                                relay = new CellRelay(circ, cell);
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("relay.getRelayCommandAsString()=" + relay.getRelayCommandAsString());
                                }
                                if ((streamId = relay.getStreamId()) != 0) {
                                    Stream stream = circ.getStreams().get(streamId);
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug("dispatch to stream with streamId=" + streamId + ", stream=" + stream);
                                    }
                                    if (stream != null) {
                                        dispatched = true;
                                        if (LOG.isDebugEnabled()) {
                                            LOG.debug("TLSDispatcher.run: data from " + this.tls.getRouter().getNickname() + " dispatched to circuit " + circ.getId() + "/stream " + streamId);
                                        }
                                        stream.processCell(relay);
                                    } else if (circ.isUsedByHiddenServiceToConnectToRendezvousPoint() && relay.isTypeBegin()) {
                                        circ.handleHiddenServiceStreamBegin(relay, streamId);
                                    } else if (LOG.isDebugEnabled()) {
                                        LOG.debug("else: circ.isUsedByHiddenServiceToConnectToRendezvousPoint()=" + circ.isUsedByHiddenServiceToConnectToRendezvousPoint() + ", relay.getRelayCommand()=" + relay.getRelayCommand());
                                    }
                                    break block41;
                                }
                                if (relay.isTypeIntroduce2()) {
                                    if (circ.isUsedByHiddenServiceToConnectToIntroductionPoint()) {
                                        if (LOG.isDebugEnabled()) {
                                            LOG.debug("TLSDispatcher.run: introduce2 from " + this.tls.getRouter().getNickname() + " dispatched to circuit " + circ.getId() + " (stream ID=0)");
                                        }
                                        try {
                                            dispatched = circ.handleIntroduce2(relay);
                                        }
                                        catch (IOException e) {
                                            LOG.info("TLSDispatcher.run: error handling intro2-cell: " + e.getMessage());
                                        }
                                    } else if (LOG.isDebugEnabled()) {
                                        LOG.debug("else isTypeIntroduce2: from " + this.tls.getRouter().getNickname() + " dispatched to circuit " + circ.getId() + " (stream ID=0)");
                                    }
                                    break block41;
                                }
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("TLSDispatcher.run: data from " + this.tls.getRouter().getNickname() + " dispatched to circuit " + circ.getId() + " (stream ID=0)");
                                }
                                dispatched = true;
                                circ.processCell(relay);
                            }
                            catch (TorException e) {
                                LOG.warn("TLSDispatcher.run: TorException " + e.getMessage() + " during dispatching cell");
                            }
                            catch (Exception e) {
                                LOG.warn("TLSDispatcher.run: Exception " + e.getMessage() + " during dispatching cell", (Throwable)e);
                            }
                        } else if (cell.isTypeDestroy()) {
                            if (LOG.isDebugEnabled()) {
                                try {
                                    LOG.debug("TLSDispatcher.run: received DESTROY-cell from " + this.tls.getRouter().getNickname() + " for circuit " + circ.getId() + " reason : " + ((CellDestroy)cell).getReason());
                                }
                                catch (ClassCastException exception) {
                                    LOG.debug("TLSDispatcher.run: received DESTROY-cell from " + this.tls.getRouter().getNickname() + " for circuit " + circ.getId() + " reason : " + CellDestroy.getReason(cell.getPayload()[0]));
                                }
                            }
                            if (cell.getPayload()[0] == 1) {
                                LOG.warn("got a DestroyCell with Reason protocol violation from " + circ);
                            }
                            dispatched = true;
                            circ.close(true);
                        } else {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("TLSDispatcher.run: data from " + this.tls.getRouter().getNickname() + " dispatched to circuit " + circ.getId());
                            }
                            dispatched = true;
                            try {
                                circ.processCell(cell);
                            }
                            catch (TorException exception) {
                                LOG.warn("got Exception while processing cell", (Throwable)exception);
                            }
                        }
                    } else {
                        LOG.info("TLSDispatcher.run: received cell for circuit " + cellCircId + " from " + this.tls.getRouter().getNickname() + ". But no such circuit exists.");
                    }
                }
            }
            if (dispatched) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("TLSDispatcher.run: data from " + this.tls.getRouter().getNickname() + " could not get dispatched");
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("TLSDispatcher.run: " + cell.toString());
        }
    }
}

