/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tor.circuit;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.silvertunnel_ng.netlib.api.NetLayer;
import org.silvertunnel_ng.netlib.layer.tor.api.Fingerprint;
import org.silvertunnel_ng.netlib.layer.tor.circuit.TLSConnection;
import org.silvertunnel_ng.netlib.layer.tor.directory.RouterImpl;
import org.silvertunnel_ng.netlib.layer.tor.util.PrivateKeyHandler;
import org.silvertunnel_ng.netlib.layer.tor.util.TorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TLSConnectionAdmin {
    private static final Logger LOG = LoggerFactory.getLogger(TLSConnectionAdmin.class);
    static final SecureRandom rnd = new SecureRandom();
    private final Map<Fingerprint, WeakReference<TLSConnection>> connectionMap = Collections.synchronizedMap(new HashMap());
    private static Map<Fingerprint, WeakReference<TLSConnection>> connectionMapAll = Collections.synchronizedMap(new HashMap());
    private final NetLayer lowerTlsConnectionNetLayer;
    private final PrivateKeyHandler privateKeyHandler;

    public TLSConnectionAdmin(NetLayer lowerTlsConnectionNetLayer, PrivateKeyHandler privateKeyHandler) throws IOException {
        this.lowerTlsConnectionNetLayer = lowerTlsConnectionNetLayer;
        this.privateKeyHandler = privateKeyHandler;
    }

    TLSConnection getConnection(RouterImpl router) throws IOException, TorException {
        if (router == null) {
            throw new TorException("TLSConnectionAdmin: server is NULL");
        }
        WeakReference<TLSConnection> weakConn = this.connectionMap.get(router.getFingerprint());
        TLSConnection conn = null;
        if (weakConn != null) {
            conn = (TLSConnection)weakConn.get();
        }
        if (conn == null) {
            LOG.debug("TLSConnectionAdmin: TLS connection to {}", (Object)router.getNickname());
            conn = new TLSConnection(router, this.lowerTlsConnectionNetLayer, this.privateKeyHandler);
            weakConn = new WeakReference<TLSConnection>(conn);
            this.connectionMap.put(router.getFingerprint(), weakConn);
            connectionMapAll.put(router.getFingerprint(), weakConn);
        }
        return conn;
    }

    public void removeConnection(TLSConnection conn) {
        this.connectionMap.remove(conn.getRouter().getFingerprint());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void closeAllTlsConnections() {
        Map<Fingerprint, WeakReference<TLSConnection>> map = connectionMapAll;
        synchronized (map) {
            for (WeakReference<TLSConnection> w : connectionMapAll.values()) {
                TLSConnection t = (TLSConnection)w.get();
                if (t == null) continue;
                t.close(true);
            }
            connectionMapAll.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean force) {
        Map<Fingerprint, WeakReference<TLSConnection>> map = this.connectionMap;
        synchronized (map) {
            for (WeakReference<TLSConnection> w : this.connectionMap.values()) {
                TLSConnection t = (TLSConnection)w.get();
                if (t == null) continue;
                t.close(force);
            }
            this.connectionMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TLSConnection> getConnections() {
        ArrayList<Fingerprint> entriesToRemove = new ArrayList<Fingerprint>(this.connectionMap.size());
        ArrayList<TLSConnection> result = new ArrayList<TLSConnection>(this.connectionMap.size());
        Map<Fingerprint, WeakReference<TLSConnection>> map = this.connectionMap;
        synchronized (map) {
            for (Fingerprint fingerprint : this.connectionMap.keySet()) {
                WeakReference<TLSConnection> weakReference = this.connectionMap.get(fingerprint);
                if (weakReference == null) continue;
                TLSConnection tlsConnection = (TLSConnection)weakReference.get();
                if (tlsConnection != null) {
                    result.add(tlsConnection);
                    continue;
                }
                entriesToRemove.add(fingerprint);
            }
            for (Fingerprint f : entriesToRemove) {
                this.connectionMap.remove(f);
            }
        }
        map = connectionMapAll;
        synchronized (map) {
            for (Fingerprint f : entriesToRemove) {
                connectionMapAll.remove(f);
            }
        }
        return result;
    }
}

