/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tor.circuit;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.TrustManager;
import org.silvertunnel_ng.netlib.api.NetAddress;
import org.silvertunnel_ng.netlib.api.NetLayer;
import org.silvertunnel_ng.netlib.api.NetSocket;
import org.silvertunnel_ng.netlib.api.util.TcpipNetAddress;
import org.silvertunnel_ng.netlib.layer.tor.circuit.Circuit;
import org.silvertunnel_ng.netlib.layer.tor.circuit.TLSConnectionAdmin;
import org.silvertunnel_ng.netlib.layer.tor.circuit.TLSDispatcherThread;
import org.silvertunnel_ng.netlib.layer.tor.circuit.cells.Cell;
import org.silvertunnel_ng.netlib.layer.tor.common.TorX509TrustManager;
import org.silvertunnel_ng.netlib.layer.tor.directory.RouterImpl;
import org.silvertunnel_ng.netlib.layer.tor.util.PrivateKeyHandler;
import org.silvertunnel_ng.netlib.layer.tor.util.TorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLSConnection {
    private static final Logger LOG = LoggerFactory.getLogger(TLSConnection.class);
    private static final String enabledSuitesStr = "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA,TLS_DHE_RSA_WITH_AES_128_CBC_SHA";
    private RouterImpl router;
    private final NetSocket tls;
    private boolean closed = false;
    private final TLSDispatcherThread dispatcher;
    private final DataOutputStream sout;
    private final Map<Integer, Circuit> circuitMap = Collections.synchronizedMap(new HashMap());

    TLSConnection(RouterImpl server, NetLayer lowerNetLayer, PrivateKeyHandler pkh) throws IOException, SSLPeerUnverifiedException, SSLException {
        if (server == null) {
            throw new IOException("TLSConnection: server variable is NULL");
        }
        this.router = server;
        TrustManager[] tms = new TrustManager[]{new TorX509TrustManager()};
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("TLSNetLayer.enabledCipherSuites", enabledSuitesStr);
        props.put("TLSNetLayer.TrustManagers", tms);
        TcpipNetAddress remoteAddress = new TcpipNetAddress(server.getHostname(), server.getOrPort());
        NetAddress localAddress = null;
        this.tls = lowerNetLayer.createNetSocket(props, localAddress, remoteAddress);
        this.sout = new DataOutputStream(this.tls.getOutputStream());
        this.dispatcher = new TLSDispatcherThread(this, new DataInputStream(this.tls.getInputStream()));
    }

    synchronized void sendCell(Cell cell) throws IOException {
        try {
            this.sout.write(cell.toByteArray());
        }
        catch (IOException exception) {
            LOG.debug("error while sending data Exception : {}", (Object)exception, (Object)exception);
            this.close(true);
            throw exception;
        }
    }

    synchronized int assignCircuitId(Circuit circuit) throws TorException {
        if (this.closed) {
            throw new TorException("TLSConnection.assignCircuitId(): Connection to " + this.router.getNickname() + " is closed for new circuits");
        }
        int newId = 0;
        int j = 0;
        while (newId == 0) {
            if (++j > 1000) {
                throw new TorException("TLSConnection.assignCircuitId(): no more free IDs");
            }
            newId = TLSConnectionAdmin.rnd.nextInt() & 0xFFFF;
            if (!this.circuitMap.containsKey(newId)) continue;
            newId = 0;
        }
        this.circuitMap.put(newId, circuit);
        return newId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(boolean force) {
        ArrayList<Circuit> circuits;
        LOG.debug("Closing TLS to {}", (Object)this.router.getNickname());
        this.closed = true;
        Map<Integer, Circuit> map = this.circuitMap;
        synchronized (map) {
            circuits = new ArrayList<Circuit>(this.circuitMap.values());
        }
        for (Circuit circuit : circuits) {
            if (!circuit.close(force)) continue;
            this.removeCircuit(circuit.getId());
        }
        LOG.debug("Fast exit while closing TLS to {}?", (Object)this.router.getNickname());
        if (!force && !this.circuitMap.isEmpty()) {
            LOG.debug("Fast exit while closing TLS to {}!", (Object)this.router.getNickname());
            return;
        }
        LOG.debug("Closing dispatcher of TLS to {}", (Object)this.router.getNickname());
        this.dispatcher.close();
        LOG.debug("Closing TLS connection to {}", (Object)this.router.getNickname());
        try {
            this.sout.close();
            this.tls.close();
        }
        catch (IOException e) {
            LOG.debug("got IOException : {}", (Object)e.getMessage(), (Object)e);
        }
        LOG.debug("Closing TLS to {} done", (Object)this.router.getNickname());
    }

    public String toString() {
        return "TLS to " + this.router.getNickname();
    }

    public RouterImpl getRouter() {
        return this.router;
    }

    public void setRouter(RouterImpl router) {
        this.router = router;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Circuit> getCircuits() {
        Map<Integer, Circuit> map = this.circuitMap;
        synchronized (map) {
            return new ArrayList<Circuit>(this.circuitMap.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, Circuit> getCircuitMap() {
        Map<Integer, Circuit> map = this.circuitMap;
        synchronized (map) {
            return new HashMap<Integer, Circuit>(this.circuitMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Circuit getCircuit(Integer circuitId) {
        Map<Integer, Circuit> map = this.circuitMap;
        synchronized (map) {
            return this.circuitMap.get(circuitId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCircuit(Integer circuitId) {
        boolean doClose;
        boolean result;
        LOG.debug("remove circuit with circuitId={} from {}", (Object)circuitId, (Object)this.toString());
        Map<Integer, Circuit> map = this.circuitMap;
        synchronized (map) {
            result = this.circuitMap.remove(circuitId) != null;
            doClose = this.circuitMap.size() == 0;
        }
        if (doClose) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("close TLSConnection from {} because last Circuit is removed", (Object)this.toString());
            }
            this.close(true);
        } else {
            map = this.circuitMap;
            synchronized (map) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("cannot close TLSConnection from " + this.toString() + " because of additional circuits: " + this.circuitMap);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("remove circuit from " + this.toString() + " done with result=" + result);
        }
        return result;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

