/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tor.circuit;

import java.io.IOException;
import java.util.Vector;
import org.silvertunnel_ng.netlib.layer.tor.circuit.QueueHandler;
import org.silvertunnel_ng.netlib.layer.tor.circuit.cells.Cell;
import org.silvertunnel_ng.netlib.layer.tor.circuit.cells.CellRelay;
import org.silvertunnel_ng.netlib.layer.tor.util.TorException;
import org.silvertunnel_ng.netlib.layer.tor.util.TorNoAnswerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Queue {
    private static final Logger LOG = LoggerFactory.getLogger(Queue.class);
    private static final int WAIT = 100;
    private volatile boolean closed = false;
    private volatile boolean addClosed = false;
    private int timeoutMs = 1000;
    private final Vector<Cell> queue = new Vector();
    private final Vector<QueueHandler> handler = new Vector();

    public Queue(int timeoutS) {
        this.timeoutMs = timeoutS * 1000;
    }

    public Queue() {
        this(1000);
    }

    public synchronized void addHandler(QueueHandler qh) {
        this.handler.add(qh);
    }

    public synchronized boolean removeHandler(QueueHandler qh) {
        return this.handler.remove(qh);
    }

    public synchronized void add(Cell cell) {
        if (this.addClosed) {
            return;
        }
        try {
            for (QueueHandler qh : this.handler) {
                try {
                    if (!qh.handleCell(cell)) continue;
                    return;
                }
                catch (TorException te) {
                    LOG.debug("got TorException : {}", (Object)te.getMessage(), (Object)te);
                }
            }
        }
        catch (ClassCastException e) {
            LOG.debug("got ClassCastException : {}", (Object)e.getMessage(), (Object)e);
        }
        this.queue.add(cell);
        this.notify();
    }

    public synchronized void close() {
        this.addClosed = true;
        this.closed = true;
        for (QueueHandler qh : this.handler) {
            qh.close();
        }
        this.queue.clear();
        this.notify();
    }

    public synchronized void closeAdd() {
        this.addClosed = true;
        this.notify();
    }

    boolean isEmpty() {
        if (this.closed) {
            return true;
        }
        return this.queue.size() == 0;
    }

    public Cell get() {
        return this.get(this.timeoutMs);
    }

    public synchronized Cell get(int timeout) {
        boolean forever = false;
        if (timeout == -1) {
            forever = true;
        }
        int retries = timeout / 100;
        do {
            if (this.closed) {
                return null;
            }
            if (this.queue.size() > 0) {
                Cell cell = this.queue.get(0);
                this.queue.remove(0);
                return cell;
            }
            if (this.addClosed) {
                this.closed = true;
                return null;
            }
            try {
                this.wait(100L);
            }
            catch (InterruptedException e) {
                LOG.debug("got InterruptedException : {}", (Object)e.getMessage(), (Object)e);
            }
        } while (forever || --retries > 0 || this.queue.size() > 0);
        return null;
    }

    public Cell receiveCell(int type) throws IOException, TorException, TorNoAnswerException {
        Cell cell = this.get();
        if (cell == null) {
            throw new TorNoAnswerException("Queue.receiveCell: connection closed or no answer after " + this.timeoutMs / 1000 + " s");
        }
        if (cell.getCommand() != type) {
            throw new TorException("Queue.receiveCell: expected cell of type " + Cell.type(type) + " received type " + cell.type());
        }
        return cell;
    }

    public CellRelay receiveRelayCell(int type) throws IOException, TorException, TorNoAnswerException {
        CellRelay relay = (CellRelay)this.receiveCell(3);
        if (relay.getRelayCommand() != type) {
            if (relay.getRelayCommand() == 3 && relay.getData() != null) {
                throw new TorException("Queue.receiveRelayCell: expected relay-cell of type " + CellRelay.getRelayCommandAsString(type) + ", received END-CELL for reason: " + relay.getReasonForClosing());
            }
            if (relay.isTypeTruncated()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Queue.receiveRelayCell: expected relay-cell of type " + CellRelay.getRelayCommandAsString(type) + " received type " + relay.getRelayCommandAsString() + " reason : " + relay.getReasonForTruncated());
                }
                throw new TorException("Queue.receiveRelayCell: expected relay-cell of type " + CellRelay.getRelayCommandAsString(type) + " received type " + relay.getRelayCommandAsString() + " reason : " + relay.getReasonForTruncated());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Queue.receiveRelayCell: expected relay-cell of type " + CellRelay.getRelayCommandAsString(type) + " received type " + relay.getRelayCommandAsString());
            }
            throw new TorException("Queue.receiveRelayCell: expected relay-cell of type " + CellRelay.getRelayCommandAsString(type) + " received type " + relay.getRelayCommandAsString());
        }
        LOG.debug("got correct type.");
        return relay;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public int getTimeoutMs() {
        return this.timeoutMs;
    }

    public void setTimeoutMs(int timeoutMs) {
        this.timeoutMs = timeoutMs;
    }
}

