/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tor.circuit;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.SecureRandom;
import org.silvertunnel_ng.netlib.layer.tor.common.TorKeyAgreement;
import org.silvertunnel_ng.netlib.layer.tor.directory.RouterImpl;
import org.silvertunnel_ng.netlib.layer.tor.util.AESCounterMode;
import org.silvertunnel_ng.netlib.layer.tor.util.Encoding;
import org.silvertunnel_ng.netlib.layer.tor.util.Encryption;
import org.silvertunnel_ng.netlib.layer.tor.util.TorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Node {
    private static final Logger LOG = LoggerFactory.getLogger(Node.class);
    private static final int DIGEST_LEN = 20;
    private final RouterImpl router;
    private byte[] symmetricKeyForCreate;
    private TorKeyAgreement dhKeyAgreement;
    private byte[] dhXBytes;
    private byte[] dhYBytes;
    private byte[] keyHandshake;
    private byte[] forwardDigest;
    private byte[] backwardDigest;
    private byte[] keyForward;
    private byte[] keyBackward;
    private AESCounterMode aesEncrypt;
    private AESCounterMode aesDecrypt;
    private MessageDigest sha1Forward;
    private MessageDigest sha1Backward;

    Node(RouterImpl init, byte[] dhXBytes) throws TorException {
        if (init == null) {
            throw new NullPointerException("can't init node on NULL server");
        }
        this.router = init;
        SecureRandom rnd = new SecureRandom();
        this.dhKeyAgreement = new TorKeyAgreement();
        BigInteger dhX = new BigInteger(1, dhXBytes);
        BigInteger dhPrivate = new BigInteger(TorKeyAgreement.P1024.bitLength() - 1, rnd);
        BigInteger dhXY = dhX.modPow(dhPrivate, TorKeyAgreement.P1024);
        byte[] dhXYBytes = this.convertBigIntegerTo128Bytes(dhXY);
        BigInteger dhY = TorKeyAgreement.G.modPow(dhPrivate, TorKeyAgreement.P1024);
        this.dhYBytes = this.convertBigIntegerTo128Bytes(dhY);
        int NUM_OF_DIGESTS = 5;
        byte[] k = new byte[100];
        byte[] sha1Input = new byte[dhXYBytes.length + 1];
        System.arraycopy(dhXYBytes, 0, sha1Input, 0, dhXYBytes.length);
        for (int i = 0; i < 5; ++i) {
            sha1Input[sha1Input.length - 1] = (byte)i;
            byte[] singleDigest = Encryption.getDigest(sha1Input);
            System.arraycopy(singleDigest, 0, k, i * 20, 20);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Node.<init>: dhX = \n" + Encoding.toHexString(dhXBytes, 100) + "\n" + "dhY = \n" + Encoding.toHexString(this.dhYBytes, 100) + "\n" + "dhXY = keymaterial:\n" + Encoding.toHexString(dhXYBytes, 100) + "\n" + "Key Data:\n" + Encoding.toHexString(k, 100));
        }
        this.keyHandshake = new byte[20];
        System.arraycopy(k, 0, this.keyHandshake, 0, 20);
        this.backwardDigest = new byte[20];
        System.arraycopy(k, 20, this.backwardDigest, 0, 20);
        this.sha1Backward = Encryption.getMessagesDigest();
        this.sha1Backward.update(this.backwardDigest, 0, 20);
        this.forwardDigest = new byte[20];
        System.arraycopy(k, 40, this.forwardDigest, 0, 20);
        this.sha1Forward = Encryption.getMessagesDigest();
        this.sha1Forward.update(this.forwardDigest, 0, 20);
        this.keyForward = new byte[16];
        System.arraycopy(k, 60, this.keyForward, 0, 16);
        this.aesDecrypt = new AESCounterMode(this.keyForward);
        this.keyBackward = new byte[16];
        System.arraycopy(k, 76, this.keyBackward, 0, 16);
        this.aesEncrypt = new AESCounterMode(this.keyBackward);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Node.<init>: dhX = \n" + Encoding.toHexString(dhXBytes, 100) + "\n" + "dhY = \n" + Encoding.toHexString(this.dhYBytes, 100) + "\n" + "dhXY = keymaterial:\n" + Encoding.toHexString(dhXYBytes, 100) + "\n" + "Key Data:\n" + Encoding.toHexString(k, 100) + "\n" + "Key Data kf:\n" + Encoding.toHexString(this.keyForward, 100) + "\n" + "Key Data kb:\n" + Encoding.toHexString(this.keyBackward, 100));
        }
    }

    public Node(RouterImpl init) throws TorException {
        this(init, false);
    }

    public Node(RouterImpl init, boolean createFast) throws TorException {
        if (init == null) {
            throw new NullPointerException("can't init node on NULL server");
        }
        this.router = init;
        SecureRandom secureRandom = new SecureRandom();
        if (createFast) {
            this.dhXBytes = new byte[20];
            secureRandom.nextBytes(this.dhXBytes);
        } else {
            try {
                this.dhKeyAgreement = new TorKeyAgreement();
            }
            catch (TorException e) {
                LOG.error("Error while doing dh! Exception : ", (Throwable)e);
                throw e;
            }
            this.dhXBytes = this.dhKeyAgreement.getPublicKeyBytes();
            this.symmetricKeyForCreate = new byte[16];
            secureRandom.nextBytes(this.symmetricKeyForCreate);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Node.<init client>: dhX = \n" + Encoding.toHexString(this.dhXBytes, 100) + "\n" + "dhY = \n" + Encoding.toHexString(this.dhYBytes, 100));
        }
    }

    public final byte[] asymEncrypt(byte[] data) throws TorException {
        return Encryption.asymEncrypt(this.router.getOnionKey(), this.getSymmetricKeyForCreate(), data);
    }

    public void finishDh(byte[] data) throws TorException {
        byte[] dhXYBytes;
        if (this.dhKeyAgreement == null) {
            dhXYBytes = new byte[40];
            this.dhYBytes = new byte[20];
            System.arraycopy(data, 0, this.dhYBytes, 0, 20);
            System.arraycopy(this.dhXBytes, 0, dhXYBytes, 0, 20);
            System.arraycopy(this.dhYBytes, 0, dhXYBytes, 20, 20);
        } else {
            this.dhYBytes = new byte[128];
            System.arraycopy(data, 0, this.dhYBytes, 0, 128);
            BigInteger otherPublicSecret = new BigInteger(1, this.dhYBytes);
            if (!TorKeyAgreement.isValidPublicValue(otherPublicSecret)) {
                LOG.warn("other DH public value is invalid!");
                throw new TorException("other DH public value is invalid!");
            }
            dhXYBytes = this.dhKeyAgreement.getSharedSecret(otherPublicSecret);
        }
        int NUM_OF_DIGESTS = 5;
        byte[] keyData = new byte[100];
        byte[] sha1Input = new byte[dhXYBytes.length + 1];
        System.arraycopy(dhXYBytes, 0, sha1Input, 0, dhXYBytes.length);
        for (int i = 0; i < 5; ++i) {
            sha1Input[sha1Input.length - 1] = (byte)i;
            byte[] singleDigest = Encryption.getDigest(sha1Input);
            System.arraycopy(singleDigest, 0, keyData, i * 20, 20);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Node.finishDh: dhX = \n" + Encoding.toHexString(this.dhXBytes, 100) + "\n" + "dhY = \n" + Encoding.toHexString(this.dhYBytes, 100) + "\n" + "dhXY = keymaterial:\n" + Encoding.toHexString(dhXYBytes, 100) + "\n" + "Key Data:\n" + Encoding.toHexString(keyData, 100));
        }
        boolean equal = true;
        for (int i = 0; equal && i < 20; ++i) {
            equal = keyData[i] == data[this.dhYBytes.length + i];
        }
        if (!equal) {
            throw new TorException("derived key material is wrong!");
        }
        this.keyHandshake = new byte[20];
        System.arraycopy(keyData, 0, this.keyHandshake, 0, 20);
        this.forwardDigest = new byte[20];
        System.arraycopy(keyData, 20, this.forwardDigest, 0, 20);
        this.sha1Forward = Encryption.getMessagesDigest();
        this.sha1Forward.update(this.forwardDigest);
        this.backwardDigest = new byte[20];
        System.arraycopy(keyData, 40, this.backwardDigest, 0, 20);
        this.sha1Backward = Encryption.getMessagesDigest();
        this.sha1Backward.update(this.backwardDigest);
        this.keyForward = new byte[16];
        System.arraycopy(keyData, 60, this.keyForward, 0, 16);
        this.aesEncrypt = new AESCounterMode(this.keyForward);
        this.keyBackward = new byte[16];
        System.arraycopy(keyData, 76, this.keyBackward, 0, 16);
        this.aesDecrypt = new AESCounterMode(this.keyBackward);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Node.finishDh: dhX = \n" + Encoding.toHexString(this.dhXBytes, 100) + "\n" + "dhY = \n" + Encoding.toHexString(this.dhYBytes, 100) + "\n" + "dhXY = keymaterial:\n" + Encoding.toHexString(dhXYBytes, 100) + "\n" + "Key Data:\n" + Encoding.toHexString(keyData, 100) + "\n" + "Key Data keyForward:\n" + Encoding.toHexString(this.keyForward, 100) + "\n" + "Key Data keyBackward:\n" + Encoding.toHexString(this.keyBackward, 100));
        }
    }

    public byte[] calcForwardDigest(byte[] data) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Node.calcForwardDigest() on:\n" + Encoding.toHexString(data, 100));
        }
        this.sha1Forward.update(data, 0, data.length);
        byte[] digest = Encryption.intermediateDigest(this.sha1Forward);
        if (LOG.isDebugEnabled()) {
            LOG.debug(" result:\n" + Encoding.toHexString(digest, 100));
        }
        byte[] fourBytes = new byte[4];
        System.arraycopy(digest, 0, fourBytes, 0, 4);
        return fourBytes;
    }

    public byte[] calcBackwardDigest(byte[] data) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Node.calcBackwardDigest() on:\n" + Encoding.toHexString(data, 100));
        }
        this.sha1Backward.update(data, 0, data.length);
        byte[] digest = Encryption.intermediateDigest(this.sha1Backward);
        if (LOG.isDebugEnabled()) {
            LOG.debug(" result:\n" + Encoding.toHexString(digest, 100));
        }
        byte[] fourBytes = new byte[4];
        System.arraycopy(digest, 0, fourBytes, 0, 4);
        return fourBytes;
    }

    public void symEncrypt(byte[] data) {
        byte[] encrypted;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Node.symEncrypt for node " + this.router.getNickname());
        }
        if ((encrypted = this.aesEncrypt.processStream(data)).length > data.length) {
            System.arraycopy(encrypted, 0, data, 0, data.length);
        } else {
            System.arraycopy(encrypted, 0, data, 0, encrypted.length);
        }
    }

    public void symDecrypt(byte[] data) {
        byte[] decrypted;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Node.symDecrypt for node " + this.router.getNickname());
        }
        if ((decrypted = this.aesDecrypt.processStream(data)).length > data.length) {
            System.arraycopy(decrypted, 0, data, 0, data.length);
        } else {
            System.arraycopy(decrypted, 0, data, 0, decrypted.length);
        }
    }

    private byte[] convertBigIntegerTo128Bytes(BigInteger a) {
        byte[] temp = a.toByteArray();
        byte[] result = new byte[128];
        if (temp.length > 128) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("convertBigIntegerTo128Bytes temp longer than 128!");
                LOG.debug("Big Integer a = " + a);
                LOG.debug("temp.length = " + temp.length);
                LOG.debug("temp data :\n" + Encoding.toHexString(temp, 100));
            }
            System.arraycopy(temp, temp.length - 128, result, 0, 128);
        } else {
            System.arraycopy(temp, 0, result, 128 - temp.length, temp.length);
        }
        return result;
    }

    public RouterImpl getRouter() {
        return this.router;
    }

    public byte[] getSymmetricKeyForCreate() {
        return this.symmetricKeyForCreate;
    }

    public byte[] getDhXBytes() {
        return this.dhXBytes;
    }

    public byte[] getDhYBytes() {
        return this.dhYBytes;
    }

    public byte[] getKeyHandshake() {
        return this.keyHandshake;
    }

    public byte[] getForwardDigest() {
        return this.forwardDigest;
    }

    public byte[] getBackwardDigest() {
        return this.backwardDigest;
    }

    public byte[] getKf() {
        return this.keyForward;
    }

    public byte[] getKb() {
        return this.keyBackward;
    }

    public AESCounterMode getAesEncrypt() {
        return this.aesEncrypt;
    }

    public AESCounterMode getAesDecrypt() {
        return this.aesDecrypt;
    }
}

