/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tor.circuit;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.silvertunnel_ng.netlib.layer.tor.common.TCPStreamProperties;

public final class CircuitHistory {
    private int countInternal = 0;
    private int countExternal = 0;
    private final Map<Long, Integer> mapCountInternal = new HashMap<Long, Integer>();
    private final Map<Long, Integer> mapCountExternal = new HashMap<Long, Integer>();
    private static final long MAX_TIMEFRAME_IN_MINUTES = 10L;
    private final Map<Integer, Integer> mapHistoricPorts = new HashMap<Integer, Integer>();
    private final Map<Long, Map<Integer, Integer>> mapCurrentHistoricPorts = new HashMap<Long, Map<Integer, Integer>>();
    private long minTSInternal = 0L;
    private long minTSExternal = 0L;
    private long minTSPorts = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCircuit(TCPStreamProperties streamProperties) {
        this.checkTimeframe();
        Long crrTime = System.currentTimeMillis() / 60000L;
        if (streamProperties != null) {
            if (streamProperties.isExitPolicyRequired()) {
                Integer n;
                Map<Long, Object> map = this.mapCountExternal;
                synchronized (map) {
                    ++this.countExternal;
                    Integer count = this.mapCountExternal.get(crrTime);
                    if (count == null) {
                        count = 0;
                    }
                    Integer n2 = count;
                    n = count = Integer.valueOf(count + 1);
                    this.mapCountExternal.put(crrTime, count);
                }
                map = this.mapCurrentHistoricPorts;
                synchronized (map) {
                    Integer port = streamProperties.getPort();
                    Integer count = this.mapHistoricPorts.get(port);
                    if (count == null) {
                        count = 0;
                    }
                    n = count;
                    Integer n3 = count = Integer.valueOf(count + 1);
                    this.mapHistoricPorts.put(port, count);
                    Map<Integer, Integer> ports = this.mapCurrentHistoricPorts.get(crrTime);
                    if (ports == null) {
                        ports = new HashMap<Integer, Integer>();
                        this.mapCurrentHistoricPorts.put(crrTime, ports);
                    }
                    if ((count = ports.get(port)) == null) {
                        count = 0;
                    }
                    n3 = count;
                    Integer n4 = count = Integer.valueOf(count + 1);
                    ports.put(port, count);
                }
            }
            Map<Long, Integer> map = this.mapCountInternal;
            synchronized (map) {
                ++this.countInternal;
                Integer count = this.mapCountInternal.get(crrTime);
                if (count == null) {
                    count = 0;
                }
                Integer n = count;
                Integer n5 = count = Integer.valueOf(count + 1);
                this.mapCountInternal.put(crrTime, count);
            }
        }
    }

    public int getCountInternal() {
        this.checkTimeframe();
        return this.countInternal;
    }

    public int getCountExternal() {
        this.checkTimeframe();
        return this.countExternal;
    }

    public Map<Long, Integer> getMapCountInternal() {
        this.checkTimeframe();
        return this.mapCountInternal;
    }

    public Map<Long, Integer> getMapCountExternal() {
        this.checkTimeframe();
        return this.mapCountExternal;
    }

    public Map<Integer, Integer> getMapHistoricPorts() {
        this.checkTimeframe();
        return this.mapHistoricPorts;
    }

    public Map<Long, Map<Integer, Integer>> getMapCurrentHistoricPorts() {
        this.checkTimeframe();
        return this.mapCurrentHistoricPorts;
    }

    private void checkTimeframe() {
        Map.Entry<Long, Object> entry;
        Iterator<Map.Entry<Long, Integer>> itEntry;
        long crrTime = System.currentTimeMillis() / 60000L;
        if (this.minTSInternal + 10L < crrTime) {
            this.minTSInternal = crrTime;
            itEntry = this.mapCountInternal.entrySet().iterator();
            while (itEntry.hasNext()) {
                entry = itEntry.next();
                if (entry.getKey() + 10L < crrTime) {
                    itEntry.remove();
                    continue;
                }
                if (entry.getKey() >= this.minTSInternal) continue;
                this.minTSInternal = entry.getKey();
            }
            if (this.mapCountInternal.isEmpty()) {
                this.minTSInternal = 0x7FFFFFFFFFFFFFF5L;
            }
        }
        if (this.minTSExternal + 10L < crrTime) {
            this.minTSExternal = crrTime;
            itEntry = this.mapCountExternal.entrySet().iterator();
            while (itEntry.hasNext()) {
                entry = itEntry.next();
                if (entry.getKey() + 10L < crrTime) {
                    itEntry.remove();
                    continue;
                }
                if (entry.getKey() >= this.minTSExternal) continue;
                this.minTSExternal = entry.getKey();
            }
            if (this.mapCountExternal.isEmpty()) {
                this.minTSExternal = 0x7FFFFFFFFFFFFFF5L;
            }
        }
        if (this.minTSPorts + 10L < crrTime) {
            this.minTSPorts = crrTime;
            Iterator<Map.Entry<Long, Map<Integer, Integer>>> itEntryPorts = this.mapCurrentHistoricPorts.entrySet().iterator();
            while (itEntryPorts.hasNext()) {
                entry = itEntryPorts.next();
                if (entry.getKey() + 10L < crrTime) {
                    itEntryPorts.remove();
                    continue;
                }
                if (entry.getKey() >= this.minTSPorts) continue;
                this.minTSPorts = entry.getKey();
            }
            if (this.mapCurrentHistoricPorts.isEmpty()) {
                this.minTSPorts = 0x7FFFFFFFFFFFFFF5L;
            }
        }
    }
}

