/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tor.circuit;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import org.silvertunnel_ng.netlib.layer.tor.api.Fingerprint;
import org.silvertunnel_ng.netlib.layer.tor.circuit.Circuit;
import org.silvertunnel_ng.netlib.layer.tor.circuit.CircuitHistory;
import org.silvertunnel_ng.netlib.layer.tor.circuit.DirectoryService;
import org.silvertunnel_ng.netlib.layer.tor.circuit.NewCircuitThread;
import org.silvertunnel_ng.netlib.layer.tor.circuit.TLSConnection;
import org.silvertunnel_ng.netlib.layer.tor.circuit.TLSConnectionAdmin;
import org.silvertunnel_ng.netlib.layer.tor.common.TCPStreamProperties;
import org.silvertunnel_ng.netlib.layer.tor.common.TorConfig;
import org.silvertunnel_ng.netlib.layer.tor.common.TorEventService;
import org.silvertunnel_ng.netlib.layer.tor.directory.Directory;
import org.silvertunnel_ng.netlib.layer.tor.directory.RouterImpl;
import org.silvertunnel_ng.netlib.layer.tor.util.TorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CircuitAdmin {
    private static final Logger LOG = LoggerFactory.getLogger(CircuitAdmin.class);
    static Map<String, Circuit[]> suitableCircuitsCache = Collections.synchronizedMap(new HashMap());
    private static CircuitHistory circuitHistory = new CircuitHistory();
    private static Map<Fingerprint, Integer> currentlyUsedNodes = Collections.synchronizedMap(new HashMap());
    private static SecureRandom rnd = new SecureRandom();

    static Circuit provideSuitableNewCircuit(TLSConnectionAdmin tlsConnectionAdmin, Directory dir, TCPStreamProperties sp, TorEventService torEventService) {
        for (int retries = 0; retries < TorConfig.getRetriesConnect(); ++retries) {
            try {
                return new Circuit(tlsConnectionAdmin, dir, sp, torEventService, circuitHistory);
            }
            catch (InterruptedException e) {
                LOG.debug("got InterruptedException : {}", (Object)e.getMessage(), (Object)e);
                continue;
            }
            catch (TorException e) {
                LOG.debug("got TorException : {}", (Object)e.getMessage(), (Object)e);
                continue;
            }
            catch (IOException e) {
                LOG.debug("got IOException : {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return null;
    }

    public static Circuit provideSuitableExclusiveCircuit(TLSConnectionAdmin tlsConnectionAdmin, Directory dir, TCPStreamProperties sp, TorEventService torEventService) {
        try {
            for (TLSConnection tls : tlsConnectionAdmin.getConnections()) {
                for (Circuit circuit : tls.getCircuits()) {
                    if (!circuit.isUnused()) continue;
                    if (sp.getCustomExitpoint() == null) {
                        circuit.setUnused(false);
                        LOG.debug("we successfully used an unused Circuit! Id : {}", (Object)circuit.getId());
                        return circuit;
                    }
                    if (circuit.getRelayEarlyCellsRemaining() <= 0) continue;
                    circuit.extend(sp.getCustomExitpoint());
                    circuit.setUnused(false);
                    LOG.debug("we successfully extended and used an unused Circuit! Id : {}", (Object)circuit.getId());
                    return circuit;
                }
            }
        }
        catch (Exception exception) {
            LOG.debug("we got an exception while finding a already established Circuit. using new one.", (Throwable)exception);
        }
        Circuit result = CircuitAdmin.provideSuitableNewCircuit(tlsConnectionAdmin, dir, sp, torEventService);
        result.setUnused(false);
        return result;
    }

    public static Circuit[] provideSuitableCircuits(TLSConnectionAdmin tlsConnectionAdmin, Directory dir, TCPStreamProperties sp, TorEventService torEventService, boolean forHiddenService) throws IOException {
        LOG.debug("TLSConnectionAdmin.provideSuitableCircuits: called for {}", (Object)sp.getHostname());
        Circuit[] cachedResults = suitableCircuitsCache.get(sp.getHostname());
        if (cachedResults != null) {
            LOG.debug("return chachedResults");
        }
        int numberOfExistingCircuits = 0;
        Vector<Circuit> allCircs = new Vector<Circuit>(10, 10);
        int rankingSum = 0;
        for (TLSConnection tls : tlsConnectionAdmin.getConnections()) {
            for (Circuit circuit : tls.getCircuits()) {
                try {
                    ++numberOfExistingCircuits;
                    if (!circuit.isEstablished() || circuit.isClosed() || !DirectoryService.isCompatible(dir, circuit, sp, forHiddenService)) continue;
                    allCircs.add(circuit);
                    rankingSum += circuit.getRanking();
                }
                catch (TorException e) {
                    LOG.debug("got TorException : {}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
        for (int i = 0; i < allCircs.size() - 1; ++i) {
            Circuit c1 = (Circuit)allCircs.get(i);
            int min = i;
            int minRanking = c1.getRanking();
            if (minRanking == 0) {
                minRanking = 1;
            }
            boolean minPointsToAddr = c1.getStreamHistory().contains(sp.getHostname());
            for (int j = i + 1; j < allCircs.size(); ++j) {
                Circuit thisCirc = (Circuit)allCircs.get(j);
                int thisRanking = thisCirc.getRanking();
                if (thisRanking == 0) {
                    thisRanking = 1;
                }
                boolean thisPointsToAddr = thisCirc.getStreamHistory().contains(sp.getHostname());
                float rankingQuota = thisRanking / minRanking;
                if ((!thisPointsToAddr || minPointsToAddr) && !((double)rnd.nextFloat() > Math.exp(-rankingQuota))) continue;
                min = j;
                minRanking = thisRanking;
            }
            if (min <= i) continue;
            Circuit temp = (Circuit)allCircs.set(i, (Circuit)allCircs.get(min));
            allCircs.set(min, temp);
        }
        int returnValues = sp.getConnectRetries();
        if (allCircs.size() < returnValues) {
            returnValues = allCircs.size();
        }
        if (returnValues == 1 && numberOfExistingCircuits < TorConfig.circuitsMaximumNumber) {
            LOG.debug("TLSConnectionAdmin.provideSuitableCircuits: spawning circuit to {} in background", (Object)sp.getHostname());
            NewCircuitThread spawnInBackground = new NewCircuitThread(tlsConnectionAdmin, dir, sp, torEventService);
            spawnInBackground.setName("CuircuitAdmin.provideSuitableCircuits");
            spawnInBackground.start();
        } else if (returnValues == 0 && numberOfExistingCircuits < TorConfig.circuitsMaximumNumber) {
            LOG.debug("TLSConnectionAdmin.provideSuitableCircuits: spawning circuit to {}", (Object)sp.getHostname());
            Circuit single = CircuitAdmin.provideSuitableNewCircuit(tlsConnectionAdmin, dir, sp, torEventService);
            if (single != null) {
                returnValues = 1;
                allCircs.add(single);
            }
        }
        Circuit[] results = new Circuit[returnValues];
        for (int i = 0; i < returnValues; ++i) {
            results[i] = (Circuit)allCircs.get(i);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("TLSConnectionAdmin.provideSuitableCircuits: Choose Circuit ranking " + results[i].getRanking() + ":" + results[i].toString());
        }
        suitableCircuitsCache.put(sp.getHostname(), results);
        return results;
    }

    private static synchronized RouterImpl[] createNewRoute(Directory directory, TCPStreamProperties sp, Fingerprint[] proposedRoute, HashSet<Fingerprint> excludedServerFingerprints, RouterImpl[] route, int i, int maxIterations) throws TorException {
        float rankingInfluenceIndex = sp.getRankingInfluenceIndex();
        HashSet<Fingerprint> previousExcludedServerFingerprints = new HashSet<Fingerprint>();
        Map<Fingerprint, RouterImpl> validRoutersByFingerprint = directory.getValidRoutersByFingerprint();
        for (RouterImpl r : validRoutersByFingerprint.values()) {
            Integer allowedCircuitsWithNode = currentlyUsedNodes.get(r.getFingerprint());
            if (allowedCircuitsWithNode == null || allowedCircuitsWithNode <= TorConfig.allowModeMultipleCircuits) continue;
            excludedServerFingerprints.add(r.getFingerprint());
        }
        if (proposedRoute != null && i < proposedRoute.length && proposedRoute[i] != null) {
            route[i] = validRoutersByFingerprint.get(proposedRoute[i]);
            if (route[i] == null) {
                throw new TorException("couldn't find server " + proposedRoute[i] + " for position " + i);
            }
        } else {
            HashSet<Fingerprint> x;
            Cloneable suitableServerFingerprints;
            if (i == route.length - 1) {
                suitableServerFingerprints = new HashMap();
                for (RouterImpl r : directory.getRoutersWithExit().values()) {
                    if (!r.exitPolicyAccepts(sp.getAddr(), sp.getPort()) || !sp.isUntrustedExitAllowed() && !r.isDirv2Exit()) continue;
                    suitableServerFingerprints.put(r.getFingerprint(), r);
                }
                x = new HashSet<Fingerprint>(excludedServerFingerprints);
                route[i] = directory.selectRandomNode((Map<Fingerprint, RouterImpl>)((Object)suitableServerFingerprints), x, rankingInfluenceIndex, sp.isFastRoute(), sp.isStableRoute());
            } else if (i == 0 && !sp.isNonGuardEntryAllowed()) {
                suitableServerFingerprints = new HashSet();
                for (RouterImpl r : validRoutersByFingerprint.values()) {
                    if (!r.isDirv2Guard()) continue;
                    ((HashSet)suitableServerFingerprints).add(r.getFingerprint());
                }
                x = new HashSet<Fingerprint>(validRoutersByFingerprint.keySet());
                x.removeAll((Collection<?>)((Object)suitableServerFingerprints));
                x.addAll(excludedServerFingerprints);
                route[i] = directory.selectRandomNode(validRoutersByFingerprint, x, rankingInfluenceIndex, sp.isFastRoute(), sp.isStableRoute());
            } else {
                route[i] = directory.selectRandomNode(validRoutersByFingerprint, excludedServerFingerprints, rankingInfluenceIndex, sp.isFastRoute(), sp.isStableRoute());
            }
            if (route[i] == null) {
                return null;
            }
            previousExcludedServerFingerprints.addAll(excludedServerFingerprints);
            excludedServerFingerprints.addAll(directory.excludeRelatedNodes(route[i]));
            Integer allowedCircuitsWithNode = currentlyUsedNodes.get(route[i].getNickname());
            int numberOfNodeOccurances = allowedCircuitsWithNode != null ? allowedCircuitsWithNode + 1 : 0;
            currentlyUsedNodes.put(route[i].getFingerprint(), numberOfNodeOccurances);
        }
        if (i > 0) {
            RouterImpl[] aRoute = CircuitAdmin.createNewRoute(directory, sp, proposedRoute, excludedServerFingerprints, route, i - 1, -1);
            if (aRoute == null) {
                previousExcludedServerFingerprints.add(route[i - 1].getFingerprint());
                maxIterations = maxIterations > -1 ? Math.min(maxIterations, 10) - 1 : 9;
                if (maxIterations < 0) {
                    return null;
                }
                route = CircuitAdmin.createNewRoute(directory, sp, proposedRoute, previousExcludedServerFingerprints, route, i, maxIterations);
            } else {
                route = aRoute;
            }
        }
        return route;
    }

    public static RouterImpl[] createNewRoute(Directory directory, TCPStreamProperties sp) throws TorException {
        RouterImpl[] result;
        if (directory.getValidRoutersByFingerprint().size() < 1) {
            throw new TorException("directory is empty");
        }
        int len = sp.getMinRouteLength() == sp.getMinRouteLength() ? sp.getMaxRouteLength() : sp.getMinRouteLength() + rnd.nextInt(sp.getMaxRouteLength() - sp.getMinRouteLength() + 1);
        RouterImpl[] route = new RouterImpl[len];
        HashSet<Fingerprint> excludedServerFingerprints = new HashSet<Fingerprint>();
        Fingerprint[] proposedRoute = sp.getProposedRouteFingerprints();
        if (proposedRoute != null) {
            for (int j = 0; j < proposedRoute.length; ++j) {
                RouterImpl s;
                if (proposedRoute[j] == null || (s = directory.getValidRoutersByFingerprint().get(proposedRoute[j])) == null) continue;
                excludedServerFingerprints.addAll(directory.excludeRelatedNodes(s));
            }
        }
        if ((result = CircuitAdmin.createNewRoute(directory, sp, proposedRoute, excludedServerFingerprints, route, len - 1, -1)) == null) {
            LOG.warn("result new route is null");
        } else if (LOG.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer(50);
            for (RouterImpl server : result) {
                sb.append("server(or=" + server.getHostname() + ":" + server.getOrPort() + "(" + server.getNickname() + "), fp=" + server.getFingerprint() + ") ");
            }
            LOG.debug("result new route: {}", (Object)sb.toString());
        }
        return result;
    }

    public static RouterImpl[] restoreCircuit(Directory directory, TCPStreamProperties sp, RouterImpl[] route, int failedNode) throws TorException {
        int i;
        Fingerprint[] customRoute = new Fingerprint[route.length];
        if (sp == null) {
            sp = new TCPStreamProperties();
        }
        sp.setMinRouteLength(route.length);
        sp.setMaxRouteLength(route.length);
        sp.setRankingInfluenceIndex(1.0f);
        route[failedNode].punishRanking();
        if (sp.getRouteFingerprints() != null) {
            for (i = 0; i < sp.getRouteFingerprints().length && i < customRoute.length; ++i) {
                customRoute[i] = sp.getRouteFingerprints()[i];
            }
        }
        for (i = 0; i < failedNode; ++i) {
            customRoute[i] = route[i].getFingerprint();
        }
        sp.setCustomRoute(customRoute);
        try {
            route = CircuitAdmin.createNewRoute(directory, sp);
        }
        catch (TorException te) {
            LOG.warn("Directory.restoreCircuit: failed");
        }
        return route;
    }

    public static Integer getCurrentlyUsedNode(Fingerprint fingerprint) {
        return currentlyUsedNodes.get(fingerprint);
    }

    public static void putCurrentlyUsedNodeNumber(Fingerprint fingerprint, Integer value) {
        currentlyUsedNodes.put(fingerprint, value);
    }

    public static void clear(TLSConnectionAdmin tlsConnectionAdmin) {
        suitableCircuitsCache.clear();
        for (TLSConnection tls : tlsConnectionAdmin.getConnections()) {
            for (Circuit circuit : tls.getCircuits()) {
                if (!circuit.isEstablished() && circuit.getStreamHistory().size() <= 0) continue;
                circuit.close(true);
            }
        }
    }
}

