/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tor.circuit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.silvertunnel_ng.netlib.api.util.TcpipNetAddress;
import org.silvertunnel_ng.netlib.layer.tor.api.Fingerprint;
import org.silvertunnel_ng.netlib.layer.tor.circuit.CircuitAdmin;
import org.silvertunnel_ng.netlib.layer.tor.circuit.CircuitHistory;
import org.silvertunnel_ng.netlib.layer.tor.circuit.HiddenServiceInstance;
import org.silvertunnel_ng.netlib.layer.tor.circuit.HiddenServicePortInstance;
import org.silvertunnel_ng.netlib.layer.tor.circuit.Node;
import org.silvertunnel_ng.netlib.layer.tor.circuit.Queue;
import org.silvertunnel_ng.netlib.layer.tor.circuit.Stream;
import org.silvertunnel_ng.netlib.layer.tor.circuit.TLSConnection;
import org.silvertunnel_ng.netlib.layer.tor.circuit.TLSConnectionAdmin;
import org.silvertunnel_ng.netlib.layer.tor.circuit.cells.Cell;
import org.silvertunnel_ng.netlib.layer.tor.circuit.cells.CellCreate;
import org.silvertunnel_ng.netlib.layer.tor.circuit.cells.CellCreateFast;
import org.silvertunnel_ng.netlib.layer.tor.circuit.cells.CellDestroy;
import org.silvertunnel_ng.netlib.layer.tor.circuit.cells.CellPadding;
import org.silvertunnel_ng.netlib.layer.tor.circuit.cells.CellRelay;
import org.silvertunnel_ng.netlib.layer.tor.circuit.cells.CellRelayData;
import org.silvertunnel_ng.netlib.layer.tor.circuit.cells.CellRelayExtend;
import org.silvertunnel_ng.netlib.layer.tor.circuit.cells.CellRelayRendezvous1;
import org.silvertunnel_ng.netlib.layer.tor.circuit.cells.CellRelaySendme;
import org.silvertunnel_ng.netlib.layer.tor.common.TCPStreamProperties;
import org.silvertunnel_ng.netlib.layer.tor.common.TorConfig;
import org.silvertunnel_ng.netlib.layer.tor.common.TorEvent;
import org.silvertunnel_ng.netlib.layer.tor.common.TorEventService;
import org.silvertunnel_ng.netlib.layer.tor.directory.Directory;
import org.silvertunnel_ng.netlib.layer.tor.directory.RendezvousServiceDescriptor;
import org.silvertunnel_ng.netlib.layer.tor.directory.RouterImpl;
import org.silvertunnel_ng.netlib.layer.tor.hiddenservice.HiddenServiceProperties;
import org.silvertunnel_ng.netlib.layer.tor.util.Encoding;
import org.silvertunnel_ng.netlib.layer.tor.util.Encryption;
import org.silvertunnel_ng.netlib.layer.tor.util.TorException;
import org.silvertunnel_ng.netlib.layer.tor.util.TorNoAnswerException;
import org.silvertunnel_ng.netlib.util.ByteArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Circuit {
    private static final Logger LOG = LoggerFactory.getLogger(Circuit.class);
    private static final int CIRCUIT_LEVEL_FLOW_RECV = 1000;
    private int circuitFlowRecv = 1000;
    private int circuitFlowSend = 1000;
    private static final int CIRCUIT_LEVEL_FLOW_RECV_INC = 100;
    public static volatile int numberOfCircuitsInConstructor = 0;
    private transient TLSConnection tls;
    private Node[] routeNodes;
    private int routeEstablished;
    private Queue queue;
    private boolean unused = true;
    private int relayEarlyCellsRemaining = 8;
    private final transient Map<Integer, Stream> streams = Collections.synchronizedMap(new HashMap());
    private final transient Set<Object> streamHistory = new HashSet<Object>();
    private int establishedStreams = 0;
    private RendezvousServiceDescriptor serviceDescriptor;
    private transient int circuitId;
    private boolean established;
    private boolean closed;
    private boolean destruct;
    private long createdTime;
    private long lastAction;
    private long lastCell;
    private int setupDurationMs;
    private int ranking;
    private int sumStreamsSetupDelays;
    private int streamCounter;
    private int streamFails;
    private Directory directory;
    private TLSConnectionAdmin tlsConnectionAdmin;
    private TorEventService torEventService;
    private boolean closeCircuitIfLastStreamIsClosed;
    private HiddenServiceInstance hiddenServiceInstanceForIntroduction;
    private HiddenServiceInstance hiddenServiceInstanceForRendezvous;
    private TCPStreamProperties streamProperties;
    private CircuitHistory circuitHistory;
    private final transient Object waitForSendMe = new Object();
    private Boolean isFast = null;
    private Boolean isStable = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Circuit(TLSConnectionAdmin fnh, Directory dir, TCPStreamProperties sp, TorEventService torEventService, CircuitHistory circuitHistory) throws IOException, TorException, InterruptedException {
        ++numberOfCircuitsInConstructor;
        boolean successful = false;
        try {
            this.directory = dir;
            this.tlsConnectionAdmin = fnh;
            this.torEventService = torEventService;
            this.circuitHistory = circuitHistory;
            this.streamProperties = sp;
            this.closed = false;
            this.established = false;
            this.destruct = false;
            this.sumStreamsSetupDelays = 0;
            this.streamCounter = 0;
            this.streamFails = 0;
            this.ranking = -1;
            this.lastAction = this.createdTime = System.currentTimeMillis();
            this.lastCell = this.createdTime;
            Thread currentThread = Thread.currentThread();
            String originalThreadName = currentThread.getName();
            RouterImpl[] routeServers = CircuitAdmin.createNewRoute(dir, sp);
            if (routeServers == null || routeServers.length < 1) {
                throw new TorException("Circuit: could not build route");
            }
            long startSetupTime = System.currentTimeMillis();
            int misses = 1;
            while (true) {
                long currentSetupDuration;
                if ((currentSetupDuration = System.currentTimeMillis() - startSetupTime) >= TorConfig.maxAllowedSetupDurationMs) {
                    String msg = "Circuit: close-during-create " + this.toString() + ", because current duration of " + currentSetupDuration + " ms is already too long";
                    LOG.info(msg);
                    throw new IOException(msg);
                }
                if (originalThreadName != null && originalThreadName.startsWith("Idle Thread")) {
                    currentThread.setName(originalThreadName + " - Circuit to " + routeServers[routeServers.length - 1].getNickname());
                }
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                RouterImpl lastTarget = null;
                try {
                    lastTarget = routeServers[0];
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Circuit: connecting to " + routeServers[0].getNickname() + " (" + routeServers[0].getCountryCode() + ")" + " [" + routeServers[0].getPlatform() + "] over tls");
                    }
                    this.tls = fnh.getConnection(routeServers[0]);
                    this.queue = new Queue(TorConfig.queueTimeoutCircuit);
                    this.circuitId = this.tls.assignCircuitId(this);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Circuit: assigned to tls " + routeServers[0].getNickname() + " (" + routeServers[0].getCountryCode() + ")" + " [" + routeServers[0].getPlatform() + "]");
                    }
                    this.routeEstablished = 0;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Circuit: sending create cell to " + routeServers[0].getNickname());
                    }
                    this.routeNodes = new Node[routeServers.length];
                    this.createFast(routeServers[0]);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Circuit: connected to entry point " + routeServers[0].getNickname() + " (" + routeServers[0].getCountryCode() + ")" + " [" + routeServers[0].getPlatform() + "]");
                    }
                    this.routeEstablished = 1;
                    for (int i = 1; i < routeServers.length; ++i) {
                        lastTarget = routeServers[i];
                        this.extend(i, routeServers[i]);
                        ++this.routeEstablished;
                    }
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug("Circuit: " + this.toString() + " successfully established");
                }
                catch (Exception e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Circuit: " + this.toString() + " Exception " + misses + " :" + e, (Throwable)e);
                    }
                    if (lastTarget != null && LOG.isDebugEnabled()) {
                        LOG.debug("Circuit: " + this.toString() + "\nlastTarget\n" + lastTarget.toLongString());
                    }
                    if (this.circuitId != 0) {
                        this.tls.removeCircuit(this.circuitId);
                    }
                    if (this.closed) {
                        throw new IOException("Circuit: " + this.toString() + " closing during buildup");
                    }
                    if (misses >= TorConfig.reconnectCircuit) {
                        if (e instanceof IOException) {
                            throw (IOException)e;
                        }
                        throw new TorException(e.toString());
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Circuit: " + this.toString() + " build a new route over the hosts that are known to be working, punish failing host");
                    }
                    routeServers = CircuitAdmin.restoreCircuit(dir, sp, routeServers, this.routeEstablished);
                    ++misses;
                    continue;
                }
                break;
            }
            this.setupDurationMs = (int)(System.currentTimeMillis() - startSetupTime);
            if ((long)this.setupDurationMs < TorConfig.maxAllowedSetupDurationMs) {
                this.established = true;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Circuit: " + this.toString() + " established within " + this.setupDurationMs + " ms - OK");
                }
                torEventService.fireEvent(new TorEvent(10, this, "Circuit build " + this.toString()));
                successful = true;
            } else {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Circuit: close-after-create " + this.toString() + ", because established within " + this.setupDurationMs + " ms was too long");
                }
                this.close(true);
            }
        }
        catch (Exception exception) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("got Exception while constructing circuit : " + exception, (Throwable)exception);
            }
        }
        finally {
            --numberOfCircuitsInConstructor;
            if (!successful) {
                this.circuitHistory = null;
                this.close(true);
            }
        }
    }

    boolean handleIntroduce2(CellRelay cell) throws TorException, IOException {
        RouterImpl rendezvousServer;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Circuit.handleIntroduce2: received Intro2-Cell of length=" + cell.getLength());
        }
        if (cell.getLength() < 20) {
            throw new TorException("Circuit.handleIntroduce2: cannot parse content, cell is too short");
        }
        byte[] identifier = new byte[20];
        System.arraycopy(cell.getData(), 0, identifier, 0, 20);
        HiddenServiceProperties introProps = this.getHiddenServiceInstanceForIntroduction().getHiddenServiceProperties();
        if (!Arrays.equals(identifier, introProps.getPubKeyHash())) {
            throw new TorException("Circuit.handleIntroduce2: onion is for unknown key-pair");
        }
        byte[] onionData = new byte[cell.getLength() - 20];
        System.arraycopy(cell.getData(), 20, onionData, 0, cell.getLength() - 20);
        byte[] plainIntro2 = Encryption.asymDecrypt(introProps.getPrivateKey(), onionData);
        if (LOG.isDebugEnabled()) {
            LOG.debug("   Intro2-Cell with plainIntro of lenght=" + plainIntro2.length);
        }
        byte[] version = new byte[1];
        byte[] rendezvousPointAddress = new byte[4];
        byte[] rendezvousPointIdentityID = new byte[20];
        final byte[] cookie = new byte[20];
        final byte[] dhX = new byte[128];
        int i = 0;
        System.arraycopy(plainIntro2, i, version, 0, version.length);
        i += version.length;
        if (LOG.isDebugEnabled()) {
            LOG.debug("version=" + version[0]);
        }
        System.arraycopy(plainIntro2, i, rendezvousPointAddress, 0, rendezvousPointAddress.length);
        int rendezvousPointPort = Encoding.byteArrayToInt(plainIntro2, i += rendezvousPointAddress.length, 2);
        System.arraycopy(plainIntro2, i += 2, rendezvousPointIdentityID, 0, rendezvousPointIdentityID.length);
        int rendezvousPointOnionKeyLength = Encoding.byteArrayToInt(plainIntro2, i += rendezvousPointIdentityID.length, 2);
        byte[] rendezvousPointOnionKey = new byte[rendezvousPointOnionKeyLength];
        System.arraycopy(plainIntro2, i += 2, rendezvousPointOnionKey, 0, rendezvousPointOnionKey.length);
        System.arraycopy(plainIntro2, i += rendezvousPointOnionKey.length, cookie, 0, cookie.length);
        System.arraycopy(plainIntro2, i += cookie.length, dhX, 0, dhX.length);
        i += dhX.length;
        TcpipNetAddress rendezvousPointTcpipNetAddress1 = new TcpipNetAddress(rendezvousPointAddress, rendezvousPointPort);
        RouterImpl rendezvousServer1 = this.directory.getValidRouterByIpAddressAndOnionPort(rendezvousPointTcpipNetAddress1.getIpNetAddress(), rendezvousPointTcpipNetAddress1.getPort());
        if (LOG.isDebugEnabled()) {
            LOG.debug("rendezvousServer1=" + rendezvousServer1);
        }
        byte[] rendezvousPointAddress2 = new byte[]{rendezvousPointAddress[3], rendezvousPointAddress[2], rendezvousPointAddress[1], rendezvousPointAddress[0]};
        TcpipNetAddress rendezvousPointTcpipNetAddress2 = new TcpipNetAddress(rendezvousPointAddress2, rendezvousPointPort);
        RouterImpl rendezvousServer2 = this.directory.getValidRouterByIpAddressAndOnionPort(rendezvousPointTcpipNetAddress2.getIpNetAddress(), rendezvousPointTcpipNetAddress2.getPort());
        if (LOG.isDebugEnabled()) {
            LOG.debug("rendezvousServer2=" + rendezvousServer2);
        }
        RouterImpl routerImpl = rendezvousServer = rendezvousServer1 != null ? rendezvousServer1 : rendezvousServer2;
        if (LOG.isDebugEnabled()) {
            LOG.debug("rendezvousServer=" + rendezvousServer);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("received Introduce2 cell with rendevouz point server=" + rendezvousServer);
        }
        if (version[0] != 2) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Intro2-Cell not supported with version=" + version[0]);
            }
            return false;
        }
        new Thread(){

            @Override
            public void run() {
                TCPStreamProperties sp = new TCPStreamProperties();
                sp.setExitPolicyRequired(false);
                sp.setCustomExitpoint(rendezvousServer.getFingerprint());
                for (int j = 0; j < sp.getConnectRetries(); ++j) {
                    try {
                        Circuit c2rendezvous = CircuitAdmin.provideSuitableNewCircuit(Circuit.this.tlsConnectionAdmin, Circuit.this.directory, sp, Circuit.this.torEventService);
                        if (c2rendezvous == null) continue;
                        Node virtualNode = new Node(rendezvousServer, dhX);
                        c2rendezvous.sendCell(new CellRelayRendezvous1(c2rendezvous, cookie, virtualNode.getDhYBytes(), virtualNode.getKeyHandshake()));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Circuit.handleIntroduce2: connected to rendezvous '" + rendezvousServer + "' over " + c2rendezvous.toString());
                        }
                        c2rendezvous.addNode(virtualNode);
                        c2rendezvous.setHiddenServiceInstanceForRendezvous(Circuit.this.hiddenServiceInstanceForIntroduction);
                        break;
                    }
                    catch (Exception e) {
                        LOG.warn("Exception in handleIntroduce2", (Throwable)e);
                    }
                }
            }
        }.start();
        return false;
    }

    void handleHiddenServiceStreamBegin(CellRelay cell, int streamId) throws TorException, IOException {
        HiddenServiceInstance hiddenServiceInstance;
        HiddenServicePortInstance hiddenServicePortInstance;
        LOG.info("new stream requested on a circuit that was already established to the rendezvous point");
        byte[] cellData = cell.getData();
        if (LOG.isDebugEnabled()) {
            LOG.debug("handleHiddenServiceStreamBegin with data=" + ByteArrayUtil.showAsStringDetails(cellData));
        }
        int DEFAULT_PORT = -1;
        int MAX_PORTSTR_LEN = 5;
        int port = -1;
        if (cellData[0] == 58) {
            char c;
            boolean startIndex = true;
            int portNum = 0;
            for (int i = 0; i < 5 && Character.isDigit(c = (char)cellData[1 + i]); ++i) {
                portNum = 10 * portNum + (c - 48);
            }
            port = portNum;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("new stream on port=" + port);
        }
        if ((hiddenServicePortInstance = (hiddenServiceInstance = this.getHiddenServiceInstanceForRendezvous()).getHiddenServicePortInstance(port)) != null) {
            hiddenServicePortInstance.createStream(this, streamId);
            if (LOG.isDebugEnabled()) {
                LOG.debug("added new TCPStream to NetServerSocket/hiddenServicePortInstance=" + hiddenServicePortInstance);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("rejected stream because nobody is listen on port=" + port + " of hiddenServiceInstance=" + hiddenServiceInstance);
        }
    }

    public final void sendCell(Cell cell) throws IOException {
        this.lastCell = System.currentTimeMillis();
        if (!cell.isTypePadding()) {
            this.lastAction = this.lastCell;
            if (cell.isTypeRelay() && cell instanceof CellRelayData) {
                --this.circuitFlowSend;
                LOG.debug("CIRCUIT_FLOW_CONTROL_SEND = {}", (Object)this.circuitFlowRecv);
                if (this.circuitFlowSend == 0) {
                    LOG.debug("waiting for SENDME cell");
                    try {
                        this.waitForSendMe.wait();
                    }
                    catch (InterruptedException exception) {
                        LOG.warn("got Exception while waiting for SENDME cell.", (Throwable)exception);
                    }
                }
            }
        }
        try {
            this.tls.sendCell(cell);
        }
        catch (IOException e) {
            LOG.debug("error in tls.sendCell Exception : {}", (Object)e, (Object)e);
            if (!this.closed) {
                this.close(false);
            }
            throw e;
        }
    }

    public void sendKeepAlive() {
        try {
            this.sendCell(new CellPadding(this));
        }
        catch (IOException e) {
            LOG.debug("got IOException : {}" + e.getMessage(), (Throwable)e);
        }
    }

    private void create(RouterImpl init) throws IOException, TorException {
        this.routeNodes[0] = new Node(init);
        this.sendCell(new CellCreate(this));
        Cell created = this.queue.receiveCell(2);
        this.routeNodes[0].finishDh(created.getPayload());
    }

    private void createFast(RouterImpl init) throws IOException, TorException {
        LOG.debug("preparing CREATE-FAST cell");
        this.routeNodes[0] = new Node(init, true);
        LOG.debug("Sending CREATE-FAST cell");
        this.sendCell(new CellCreateFast(this));
        Cell createdFast = this.queue.receiveCell(6);
        this.routeNodes[0].finishDh(createdFast.getPayload());
    }

    private void extend(int i, RouterImpl next) throws IOException, TorException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Circuit: " + this.toString() + " extending to " + next.getNickname() + " (" + next.getCountryCode() + ")" + " [" + next.getPlatform() + "]");
        }
        this.routeNodes[i] = new Node(next);
        this.sendCell(new CellRelayExtend(this, this.routeNodes[i]));
        CellRelay relay = this.queue.receiveRelayCell(7);
        this.routeNodes[i].finishDh(relay.getData());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Circuit: " + this.toString() + " successfully extended to " + next.getNickname() + " (" + next.getCountryCode() + ")" + " [" + next.getPlatform() + "]");
        }
    }

    public void extend(Fingerprint routerFingerprint) throws TorException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("extending Circuit with id {} to {}", new Object[]{this.getId(), routerFingerprint});
        }
        for (Node node : this.routeNodes) {
            if (node.getRouter().getFingerprint() != routerFingerprint) continue;
            throw new TorException("Circuit cant be extended to given fingerprint as this router is already a node");
        }
        RouterImpl router = this.directory.getValidRoutersByFingerprint().get(routerFingerprint);
        if (router == null) {
            throw new TorException("Router with fingerprint " + routerFingerprint + " not found.");
        }
        Node[] newRoute = new Node[this.routeEstablished + 1];
        System.arraycopy(this.routeNodes, 0, newRoute, 0, this.routeEstablished);
        this.routeNodes = newRoute;
        this.extend(this.routeEstablished, router);
    }

    public void addNode(Node n) {
        Node[] newRoute = new Node[this.routeEstablished + 1];
        System.arraycopy(this.routeNodes, 0, newRoute, 0, this.routeEstablished);
        newRoute[this.routeEstablished] = n;
        ++this.routeEstablished;
        this.routeNodes = newRoute;
    }

    public void reportStreamFailure(Stream stream) {
        ++this.streamFails;
        if (this.streamFails > TorConfig.getCircuitClosesOnFailures() && this.streamFails > this.streamCounter * 3 / 2) {
            if (!this.closed) {
                LOG.info("Circuit.reportStreamFailure: closing due to failures {}", (Object)this.toString());
            }
            this.close(false);
        }
        this.updateRanking();
    }

    private synchronized int getFreeStreamID() throws TorException {
        for (int nr = 1; nr < 65536; ++nr) {
            int newId = nr + this.streamCounter & 0xFFFF;
            if (newId == 0 || this.streams.containsKey(newId)) continue;
            return newId;
        }
        throw new TorException("Circuit.getFreeStreamID: " + this.toString() + " has no free stream-IDs");
    }

    public int assignStreamId(Stream stream) throws TorException {
        int streamId = this.getFreeStreamID();
        if (!this.assignStreamId(stream, streamId)) {
            throw new TorException("streamId=" + streamId + " could not be set");
        }
        return streamId;
    }

    public boolean assignStreamId(Stream stream, int streamId) throws TorException {
        if (this.closed) {
            throw new TorException("Circuit.assignStreamId: " + this.toString() + " is closed");
        }
        stream.setId(streamId);
        Stream oldStream = this.streams.put(streamId, stream);
        if (oldStream == null) {
            return true;
        }
        this.streams.put(streamId, oldStream);
        return false;
    }

    final void registerStream(TCPStreamProperties sp) throws TorException {
        ++this.establishedStreams;
        if (sp.getAddr() != null) {
            this.streamHistory.add(sp.getAddr());
        }
        if (sp.getHostname() != null) {
            this.streamHistory.add(sp.getHostname());
        }
    }

    public void registerStream(TCPStreamProperties sp, long streamSetupDuration) throws TorException {
        this.sumStreamsSetupDelays = (int)((long)this.sumStreamsSetupDelays + streamSetupDuration);
        ++this.streamCounter;
        this.updateRanking();
        this.registerStream(sp);
    }

    private void updateRanking() {
        this.ranking = (5 * this.setupDurationMs + this.sumStreamsSetupDelays) / (this.streamCounter + 5);
        this.ranking = (int)((double)this.ranking * Math.exp(this.streamFails));
    }

    public boolean close(boolean force) {
        if (!this.closed) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Circuit.close(): closing " + this.toString());
            }
            for (int i = 0; i < this.routeEstablished; ++i) {
                Fingerprint f = this.routeNodes[i].getRouter().getFingerprint();
                Integer numberOfNodeOccurances = CircuitAdmin.getCurrentlyUsedNode(f);
                if (numberOfNodeOccurances == null) continue;
                numberOfNodeOccurances = numberOfNodeOccurances - 1;
                CircuitAdmin.putCurrentlyUsedNodeNumber(f, Math.max(0, numberOfNodeOccurances));
            }
        }
        this.torEventService.fireEvent(new TorEvent(11, this, "Circuit: closing " + this.toString()));
        this.closed = true;
        this.established = false;
        for (Stream stream : new ArrayList<Stream>(this.streams.values())) {
            try {
                if (!stream.isClosed()) {
                    if (force) {
                        stream.close(force);
                    } else if (System.currentTimeMillis() - stream.getLastCellSentDate() > (long)(10 * TorConfig.queueTimeoutStreamBuildup * 1000)) {
                        LOG.info("Circuit.close(): forcing timeout on stream");
                        stream.close(true);
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Circuit.close(): can't close due to " + stream.toString());
                    }
                }
                if (!stream.isClosed()) continue;
                this.streams.remove(stream.getId());
            }
            catch (Exception e) {
                LOG.warn("unexpected " + e, (Throwable)e);
            }
        }
        if (!force && !this.streams.isEmpty()) {
            return false;
        }
        if (!force && this.routeEstablished > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Circuit.close(): destroying " + this.toString());
            }
            this.routeEstablished = 1;
            try {
                this.sendCell(new CellDestroy(this));
            }
            catch (IOException e) {
                LOG.debug("Exception while destroying circuit: {}", (Object)e, (Object)e);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Circuit.close(): close queue? " + this.toString());
        }
        if (this.queue != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Circuit.close(): close queue! " + this.toString());
            }
            this.queue.close();
        }
        this.destruct = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Circuit.close(): remove from tls? " + this.toString());
        }
        if (this.tls != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Circuit.close(): remove from tls! " + this.toString());
            }
            this.tls.removeCircuit(this.getId());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Circuit.close(): done " + this.toString());
        }
        return true;
    }

    public RouterImpl[] getRoute() {
        RouterImpl[] s = new RouterImpl[this.routeEstablished];
        for (int i = 0; i < this.routeEstablished; ++i) {
            s[i] = this.routeNodes[i].getRouter();
        }
        return s;
    }

    public String toString() {
        if (this.tls != null && this.tls.getRouter() != null) {
            RouterImpl r1 = this.tls.getRouter();
            StringBuffer sb = new StringBuffer(this.circuitId + " [" + r1.getNickname() + "/" + r1.getFingerprint() + " (" + r1.getCountryCode() + ") (" + r1.getPlatform() + ")" + (this.isFast() ? "[fast]" : "") + (this.isStable() ? "[stable]" : ""));
            for (int i = 1; i < this.routeEstablished; ++i) {
                RouterImpl r = this.routeNodes[i].getRouter();
                sb.append(" " + r.getNickname() + "/" + r.getHostname() + ":" + r.getOrPort() + "/" + r.getFingerprint() + " (" + r.getCountryCode() + ") (" + r.getPlatform() + ")");
            }
            sb.append("]");
            if (this.closed) {
                sb.append(" (closed)");
            } else if (!this.established) {
                sb.append(" (establishing)");
            }
            return sb.toString();
        }
        return "<empty>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeStream(Integer streamId) {
        Map<Integer, Stream> map = this.streams;
        synchronized (map) {
            boolean result;
            boolean bl = result = this.streams.remove(streamId) != null;
            if (this.closeCircuitIfLastStreamIsClosed && this.streams.size() == 0) {
                this.close(true);
            }
            return result;
        }
    }

    public void setHiddenServiceInstanceForIntroduction(HiddenServiceInstance hiddenServiceInstanceForIntroduction) {
        this.hiddenServiceInstanceForIntroduction = hiddenServiceInstanceForIntroduction;
    }

    HiddenServiceInstance getHiddenServiceInstanceForIntroduction() {
        return this.hiddenServiceInstanceForIntroduction;
    }

    public boolean isUsedByHiddenServiceToConnectToIntroductionPoint() {
        return this.hiddenServiceInstanceForIntroduction != null;
    }

    private void setHiddenServiceInstanceForRendezvous(HiddenServiceInstance hiddenServiceInstanceForRendezvous) {
        this.hiddenServiceInstanceForRendezvous = hiddenServiceInstanceForRendezvous;
    }

    HiddenServiceInstance getHiddenServiceInstanceForRendezvous() {
        return this.hiddenServiceInstanceForRendezvous;
    }

    boolean isUsedByHiddenServiceToConnectToRendezvousPoint() {
        return this.hiddenServiceInstanceForRendezvous != null;
    }

    public TorEventService getTorEventService() {
        return this.torEventService;
    }

    public Node[] getRouteNodes() {
        return this.routeNodes;
    }

    public void setRouteNodes(Node[] routeNodes) {
        this.routeNodes = routeNodes;
    }

    public int getRouteEstablished() {
        return this.routeEstablished;
    }

    public void setRouteEstablished(int routeEstablished) {
        this.routeEstablished = routeEstablished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, Stream> getStreams() {
        Map<Integer, Stream> map = this.streams;
        synchronized (map) {
            return new HashMap<Integer, Stream>(this.streams);
        }
    }

    public final CellRelay receiveRelayCell(int type) throws TorNoAnswerException, IOException, TorException {
        return this.queue.receiveRelayCell(type);
    }

    public final void processCell(Cell cell) throws TorException {
        if (cell.isTypeRelay() && cell instanceof CellRelay) {
            CellRelay relay = (CellRelay)cell;
            if (relay.isTypeData()) {
                this.reduceCircWindowRecv();
            } else if (relay.isTypeSendme()) {
                this.circuitFlowSend += 100;
                this.waitForSendMe.notifyAll();
                LOG.debug("got RELAY_SENDME cell, increasing circuit flow send window to {}", (Object)this.circuitFlowSend);
            }
        }
        this.queue.add(cell);
    }

    public final synchronized void reduceCircWindowRecv() throws TorException {
        --this.circuitFlowRecv;
        LOG.debug("CIRCUIT_FLOW_CONTROL_RECV = {}", (Object)this.circuitFlowRecv);
        if (this.circuitFlowRecv <= 900) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("sending RELAY_SENDME cell to router {}", (Object)this.getRoute()[this.getRouteEstablished() - 1]);
                }
                this.sendCell(new CellRelaySendme(this, this.getRouteEstablished() - 1));
                this.circuitFlowRecv += 100;
            }
            catch (IOException exception) {
                LOG.warn("problems with sending RELAY_SENDME cell to router {}", (Object)this.getRoute()[this.getRouteEstablished() - 1], (Object)exception);
                throw new TorException("problems with sending RELAY_SENDME cell to router " + this.getRoute()[this.getRouteEstablished() - 1], exception);
            }
        }
    }

    public final Set<Object> getStreamHistory() {
        return this.streamHistory;
    }

    public int getEstablishedStreams() {
        return this.establishedStreams;
    }

    public void setEstablishedStreams(int establishedStreams) {
        this.establishedStreams = establishedStreams;
    }

    public int getId() {
        return this.circuitId;
    }

    public boolean isEstablished() {
        return this.established;
    }

    public void setEstablished(boolean established) {
        this.established = established;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isDestruct() {
        return this.destruct;
    }

    public long getCreated() {
        return this.createdTime;
    }

    public void setCreated(long created) {
        this.createdTime = created;
    }

    public long getLastAction() {
        return this.lastAction;
    }

    public void setLastAction(long lastAction) {
        this.lastAction = lastAction;
    }

    public long getLastCell() {
        return this.lastCell;
    }

    public void setLastCell(long lastCell) {
        this.lastCell = lastCell;
    }

    public int getSetupDurationMs() {
        return this.setupDurationMs;
    }

    public void setSetupDurationMs(int setupDurationMs) {
        this.setupDurationMs = setupDurationMs;
    }

    public int getRanking() {
        return this.ranking;
    }

    public void setRanking(int ranking) {
        this.ranking = ranking;
    }

    public int getSumStreamsSetupDelays() {
        return this.sumStreamsSetupDelays;
    }

    public void setSumStreamsSetupDelays(int sumStreamsSetupDelays) {
        this.sumStreamsSetupDelays = sumStreamsSetupDelays;
    }

    public int getStreamCounter() {
        return this.streamCounter;
    }

    public void setStreamCounter(int streamCounter) {
        this.streamCounter = streamCounter;
    }

    public int getStreamFails() {
        return this.streamFails;
    }

    public void setStreamFails(int streamFails) {
        this.streamFails = streamFails;
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public void setDirectory(Directory directory) {
        this.directory = directory;
    }

    public TLSConnectionAdmin getTlsConnectionAdmin() {
        return this.tlsConnectionAdmin;
    }

    public void setTlsConnectionAdmin(TLSConnectionAdmin tlsConnectionAdmin) {
        this.tlsConnectionAdmin = tlsConnectionAdmin;
    }

    public RendezvousServiceDescriptor getServiceDescriptor() {
        return this.serviceDescriptor;
    }

    public void setServiceDescriptor(RendezvousServiceDescriptor serviceDescriptor) {
        this.serviceDescriptor = serviceDescriptor;
    }

    public boolean isCloseCircuitIfLastStreamIsClosed() {
        return this.closeCircuitIfLastStreamIsClosed;
    }

    public void setCloseCircuitIfLastStreamIsClosed(boolean closeCircuitIfLastStreamIsClosed) {
        this.closeCircuitIfLastStreamIsClosed = closeCircuitIfLastStreamIsClosed;
    }

    public synchronized boolean isFast() {
        boolean circuitComplete = true;
        boolean tmpValue = true;
        if (this.isFast == null) {
            if (this.routeNodes == null) {
                return false;
            }
            for (Node routerNode : this.routeNodes) {
                if (routerNode == null) {
                    circuitComplete = false;
                    return false;
                }
                if (routerNode.getRouter().isDirv2Fast()) continue;
                tmpValue = false;
            }
            if (circuitComplete) {
                this.isFast = tmpValue;
            }
        }
        return this.isFast;
    }

    public synchronized boolean isStable() {
        boolean circuitComplete = true;
        boolean tmpValue = true;
        if (this.isStable == null) {
            if (this.routeNodes == null) {
                return false;
            }
            for (Node routerNode : this.routeNodes) {
                if (routerNode == null) {
                    circuitComplete = false;
                    return false;
                }
                if (routerNode.getRouter().isDirv2Stable()) continue;
                tmpValue = false;
            }
            if (circuitComplete) {
                this.isStable = tmpValue;
            }
        }
        return this.isStable;
    }

    public int getRelayEarlyCellsRemaining() {
        return this.relayEarlyCellsRemaining;
    }

    public void decrementRelayEarlyCellsRemaining() {
        --this.relayEarlyCellsRemaining;
    }

    public TCPStreamProperties getTcpStreamProperties() {
        return this.streamProperties;
    }

    public boolean isUnused() {
        return this.unused && this.establishedStreams == 0 && !this.isUsedByHiddenServiceToConnectToIntroductionPoint() && !this.isUsedByHiddenServiceToConnectToRendezvousPoint();
    }

    public void setUnused(boolean unused) {
        this.unused = unused;
    }
}

