/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tor;

import org.silvertunnel_ng.netlib.api.NetFactory;
import org.silvertunnel_ng.netlib.api.NetLayer;
import org.silvertunnel_ng.netlib.api.NetLayerFactory;
import org.silvertunnel_ng.netlib.api.NetLayerIDs;
import org.silvertunnel_ng.netlib.layer.socks.SocksServerNetLayer;
import org.silvertunnel_ng.netlib.layer.tor.TorNetLayer;
import org.silvertunnel_ng.netlib.util.TempfileStringStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TorNetLayerFactory
implements NetLayerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TorNetLayerFactory.class);
    private NetLayer torNetLayer;
    private NetLayer socksOverTorNetLayer;

    @Override
    public NetLayer getNetLayerById(NetLayerIDs netLayerId) {
        try {
            if (netLayerId == NetLayerIDs.TOR_OVER_TLS_OVER_TCPIP || netLayerId == NetLayerIDs.TOR) {
                if (this.torNetLayer == null) {
                    NetLayer tcpipNetLayer = NetFactory.getInstance().getNetLayerById(NetLayerIDs.TCPIP);
                    NetLayer tlsNetLayer = NetFactory.getInstance().getNetLayerById(NetLayerIDs.TLS_OVER_TCPIP);
                    this.torNetLayer = new TorNetLayer(tlsNetLayer, tcpipNetLayer, TempfileStringStorage.getInstance());
                }
                return this.torNetLayer;
            }
            if (netLayerId == NetLayerIDs.SOCKS_OVER_TOR_OVER_TLS_OVER_TCPIP || netLayerId == NetLayerIDs.SOCKS_OVER_TOR) {
                if (this.socksOverTorNetLayer == null) {
                    if (this.torNetLayer == null) {
                        this.torNetLayer = this.getNetLayerById(NetLayerIDs.TOR_OVER_TLS_OVER_TCPIP);
                    }
                    this.socksOverTorNetLayer = new SocksServerNetLayer(this.torNetLayer);
                }
                return this.socksOverTorNetLayer;
            }
            return null;
        }
        catch (Exception e) {
            LOG.error("could not create " + (Object)((Object)netLayerId), (Throwable)e);
            return null;
        }
    }
}

