/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tor;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import org.silvertunnel_ng.netlib.api.NetAddress;
import org.silvertunnel_ng.netlib.api.NetAddressNameService;
import org.silvertunnel_ng.netlib.api.NetLayer;
import org.silvertunnel_ng.netlib.api.NetLayerStatus;
import org.silvertunnel_ng.netlib.api.NetServerSocket;
import org.silvertunnel_ng.netlib.api.NetSocket;
import org.silvertunnel_ng.netlib.api.util.TcpipNetAddress;
import org.silvertunnel_ng.netlib.layer.control.ControlNetLayer;
import org.silvertunnel_ng.netlib.layer.control.ControlParameters;
import org.silvertunnel_ng.netlib.layer.tor.TorHiddenServicePortPrivateNetAddress;
import org.silvertunnel_ng.netlib.layer.tor.TorNetServerSocket;
import org.silvertunnel_ng.netlib.layer.tor.TorNetSocket;
import org.silvertunnel_ng.netlib.layer.tor.api.Router;
import org.silvertunnel_ng.netlib.layer.tor.clientimpl.Tor;
import org.silvertunnel_ng.netlib.layer.tor.common.TCPStreamProperties;
import org.silvertunnel_ng.netlib.layer.tor.directory.FingerprintImpl;
import org.silvertunnel_ng.netlib.layer.tor.hiddenservice.HiddenServiceProperties;
import org.silvertunnel_ng.netlib.layer.tor.stream.TCPStream;
import org.silvertunnel_ng.netlib.nameservice.cache.CachingNetAddressNameService;
import org.silvertunnel_ng.netlib.nameservice.tor.TorNetAddressNameService;
import org.silvertunnel_ng.netlib.util.StringStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TorNetLayer
implements NetLayer {
    private static final Logger LOG = LoggerFactory.getLogger(TorNetLayer.class);
    private final transient Tor tor;
    private transient NetAddressNameService netAddressNameService;
    private static final String EXIT = "exit";
    private static final Pattern EXIT_PATTERN = Pattern.compile("(.*)\\.([^\\.]+)\\.exit");
    private final NetLayer thisTorNetLayerWithTimeoutControl;

    public TorNetLayer(NetLayer lowerTlsConnectionNetLayer, NetLayer lowerDirConnectionNetLayer, StringStorage stringStorage) throws IOException {
        this(new Tor(lowerTlsConnectionNetLayer, lowerDirConnectionNetLayer, stringStorage));
    }

    public TorNetLayer(Tor tor) throws IOException {
        this.tor = tor;
        ControlParameters cp = ControlParameters.createTypicalFileTransferParameters();
        cp.setConnectTimeoutMillis(10000L);
        cp.setOverallTimeoutMillis(30000L);
        cp.setInputMaxBytes(0x3200000L);
        cp.setThroughputTimeframeMinBytes(15360L);
        cp.setThroughputTimeframeMillis(15000L);
        this.thisTorNetLayerWithTimeoutControl = new ControlNetLayer(this, cp);
    }

    @Override
    public NetSocket createNetSocket(Map<String, Object> localProperties, NetAddress localAddress, NetAddress remoteAddress) throws IOException {
        TcpipNetAddress ra = (TcpipNetAddress)remoteAddress;
        TCPStreamProperties sp = this.convertTcpipNetAddress2TCPStreamProperties(ra);
        if (this.tor.getDirectory().isDirServer(sp)) {
            sp.setExitPolicyRequired(false);
            sp.setConnectToDirServer(true);
            String[] octets = sp.getHostname().split("\\.");
            byte[] ip = new byte[]{(byte)Integer.parseInt(octets[0]), (byte)Integer.parseInt(octets[1]), (byte)Integer.parseInt(octets[2]), (byte)Integer.parseInt(octets[3])};
            sp.setCustomExitpoint(this.tor.getDirectory().getValidRouterByIpAddressAndDirPort(new TcpipNetAddress(ip, sp.getPort())).getFingerprint());
        }
        TCPStream remote = this.tor.connect(sp, this.thisTorNetLayerWithTimeoutControl);
        return new TorNetSocket(remote, "TorNetLayer connection to " + ra);
    }

    private TCPStreamProperties convertTcpipNetAddress2TCPStreamProperties(TcpipNetAddress ra) {
        Matcher m;
        TCPStreamProperties sp = new TCPStreamProperties(ra);
        String hostname = ra.getHostname();
        if (hostname != null && (m = EXIT_PATTERN.matcher(hostname = hostname.toLowerCase())).find()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("hostname with .exit pattern={}", (Object)hostname);
            }
            String originalHostname = m.group(1);
            String exitNodeNameOrDigest = m.group(2);
            if (LOG.isDebugEnabled()) {
                LOG.debug("originalHostname=" + originalHostname);
                LOG.debug("exitNodeNameOrDigest=" + exitNodeNameOrDigest);
            }
            TcpipNetAddress raNew = new TcpipNetAddress(originalHostname, ra.getPort());
            sp = new TCPStreamProperties(raNew);
            sp.setCustomExitpoint(new FingerprintImpl(DatatypeConverter.parseHexBinary((String)exitNodeNameOrDigest)));
        }
        return sp;
    }

    @Override
    public NetServerSocket createNetServerSocket(Map<String, Object> properties, NetAddress localListenAddress) throws IOException {
        try {
            TorHiddenServicePortPrivateNetAddress netAddress = (TorHiddenServicePortPrivateNetAddress)localListenAddress;
            TorNetServerSocket torNetServerSocket = new TorNetServerSocket(netAddress.getPublicOnionHostname(), netAddress.getPort());
            TorNetLayer torNetLayerToConnectToDirectoryService = this;
            HiddenServiceProperties hiddenServiceProps = new HiddenServiceProperties(netAddress.getPort(), netAddress.getTorHiddenServicePrivateNetAddress().getKeyPair());
            this.tor.provideHiddenService(torNetLayerToConnectToDirectoryService, hiddenServiceProps, torNetServerSocket);
            return torNetServerSocket;
        }
        catch (Exception e) {
            String msg = "could not create NetServerSocket for localListenAddress=" + localListenAddress;
            LOG.error("could not create NetServerSocket", (Throwable)e);
            throw new IOException(msg);
        }
    }

    @Override
    public NetLayerStatus getStatus() {
        return this.tor.getStatus();
    }

    @Override
    public void waitUntilReady() {
        this.tor.checkStartup();
    }

    @Override
    public void clear() throws IOException {
        LOG.info("clear() started");
        this.tor.clear();
        LOG.info("clear() finished");
    }

    @Override
    public NetAddressNameService getNetAddressNameService() {
        if (this.netAddressNameService == null) {
            this.netAddressNameService = new CachingNetAddressNameService(new TorNetAddressNameService(this.tor){});
        }
        return this.netAddressNameService;
    }

    public Collection<Router> getValidTorRouters() {
        this.waitUntilReady();
        return this.tor.getValidTorRouters();
    }
}

