/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tor;

import org.silvertunnel_ng.netlib.api.NetAddress;
import org.silvertunnel_ng.netlib.api.util.TcpipNetAddress;
import org.silvertunnel_ng.netlib.layer.tor.TorHiddenServicePrivateNetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TorHiddenServicePortPrivateNetAddress
implements NetAddress {
    private static final Logger LOG = LoggerFactory.getLogger(TorHiddenServicePortPrivateNetAddress.class);
    private final TorHiddenServicePrivateNetAddress torHiddenServicePrivateNetAddress;
    private final int port;
    private static final int MIN_PORT = 0;
    private static final int MAX_PORT = 65535;

    public TorHiddenServicePortPrivateNetAddress(TorHiddenServicePrivateNetAddress torHiddenServicePrivateNetAddress, int port) {
        this.torHiddenServicePrivateNetAddress = torHiddenServicePrivateNetAddress;
        this.port = port;
        this.checkThis();
    }

    private void checkThis() throws IllegalArgumentException {
        if (this.port < 0 || this.port > 65535) {
            throw new IllegalArgumentException("port=" + this.port + " is out of range");
        }
    }

    public byte[] getPublicKeyHash() {
        return this.torHiddenServicePrivateNetAddress.getPublicKeyHash();
    }

    public String getPublicOnionHostname() {
        return this.torHiddenServicePrivateNetAddress.getPublicOnionHostname();
    }

    public TcpipNetAddress getPublicTcpipNetAddress() {
        return new TcpipNetAddress(this.getPublicOnionHostname(), this.getPort());
    }

    protected String getId() {
        return "TorHiddenServicePrivateNetAddress(hostname=" + this.getPublicOnionHostname() + ",port=" + this.port + ")";
    }

    public String toString() {
        return this.getId();
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TorHiddenServicePortPrivateNetAddress)) {
            return false;
        }
        TorHiddenServicePortPrivateNetAddress other = (TorHiddenServicePortPrivateNetAddress)obj;
        return this.getId().equals(other.getId());
    }

    public TorHiddenServicePrivateNetAddress getTorHiddenServicePrivateNetAddress() {
        return this.torHiddenServicePrivateNetAddress;
    }

    public int getPort() {
        return this.port;
    }
}

