/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tls;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.silvertunnel_ng.netlib.api.NetSocket;
import org.silvertunnel_ng.netlib.api.impl.NetSocket2Socket;
import org.silvertunnel_ng.netlib.api.impl.Socket2NetSocket;
import org.silvertunnel_ng.netlib.api.util.TcpipNetAddress;
import org.silvertunnel_ng.netlib.layer.tls.TLSNetSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLSNetSocketUtil {
    private static final Logger LOG = LoggerFactory.getLogger(TLSNetSocketUtil.class);

    public static NetSocket createTLSSocket(NetSocket lowerLayerNetSocket, TcpipNetAddress remoteAddress, boolean autoClose, String[] enabledCipherSuites, KeyManager[] keyManagers, TrustManager[] trustManagers) throws IOException {
        NetSocket2Socket lowerLayerSocket = new NetSocket2Socket(lowerLayerNetSocket);
        SSLContext context = null;
        try {
            context = SSLContext.getInstance("TLS", "SunJSSE");
            context.init(keyManagers, trustManagers, null);
        }
        catch (NoSuchAlgorithmException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        catch (KeyManagementException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        catch (NoSuchProviderException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        SSLSocketFactory f = context.getSocketFactory();
        String hostname = remoteAddress != null ? remoteAddress.getHostname() : null;
        int port = remoteAddress != null ? remoteAddress.getPort() : 0;
        SSLSocket resultSocket = (SSLSocket)f.createSocket(lowerLayerSocket, hostname, port, autoClose);
        if (LOG.isDebugEnabled()) {
            LOG.debug("default enabledCipherSuites=" + Arrays.toString(resultSocket.getEnabledCipherSuites()));
        }
        if (enabledCipherSuites != null) {
            resultSocket.setEnabledCipherSuites(enabledCipherSuites);
            if (LOG.isDebugEnabled()) {
                LOG.debug("set enabledCipherSuites=" + Arrays.toString(enabledCipherSuites));
            }
        }
        return new TLSNetSocket(new Socket2NetSocket(resultSocket), resultSocket.getSession(), "" + lowerLayerNetSocket);
    }
}

