/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tls;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import org.silvertunnel_ng.netlib.api.NetAddress;
import org.silvertunnel_ng.netlib.api.NetAddressNameService;
import org.silvertunnel_ng.netlib.api.NetLayer;
import org.silvertunnel_ng.netlib.api.NetLayerStatus;
import org.silvertunnel_ng.netlib.api.NetServerSocket;
import org.silvertunnel_ng.netlib.api.NetSocket;
import org.silvertunnel_ng.netlib.api.impl.PropertiesUtil;
import org.silvertunnel_ng.netlib.api.util.TcpipNetAddress;
import org.silvertunnel_ng.netlib.layer.tls.TLSNetSocketUtil;

public class TLSNetLayer
implements NetLayer {
    public static final String ENABLES_CIPHER_SUITES = "TLSNetLayer.enabledCipherSuites";
    public static final String KEY_MANAGERS = "TLSNetLayer.KEYManagers";
    public static final String TRUST_MANAGERS = "TLSNetLayer.TrustManagers";
    private final NetLayer lowerNetLayer;

    public TLSNetLayer(NetLayer lowerNetLayer) {
        this.lowerNetLayer = lowerNetLayer;
    }

    @Override
    public NetSocket createNetSocket(Map<String, Object> localProperties, NetAddress localAddress, NetAddress remoteAddress) throws IOException {
        HashMap<String, Object> lowerLayerProperties = null;
        if (localProperties != null) {
            lowerLayerProperties = new HashMap<String, Object>(localProperties);
            lowerLayerProperties.remove(ENABLES_CIPHER_SUITES);
            lowerLayerProperties.remove(KEY_MANAGERS);
            lowerLayerProperties.remove(TRUST_MANAGERS);
        }
        NetSocket lowerLayerSocket = this.lowerNetLayer.createNetSocket(lowerLayerProperties, localAddress, remoteAddress);
        String[] enabledCipherSuites = PropertiesUtil.getAsStringArray(localProperties, ENABLES_CIPHER_SUITES, null);
        Object keyManagersObj = PropertiesUtil.getAsObject(localProperties, KEY_MANAGERS, null);
        KeyManager[] keyManagers = null;
        if (keyManagersObj != null && keyManagersObj instanceof KeyManager[]) {
            keyManagers = (KeyManager[])keyManagersObj;
        }
        Object trustManagersObj = PropertiesUtil.getAsObject(localProperties, TRUST_MANAGERS, null);
        TrustManager[] trustManagers = null;
        if (trustManagersObj != null && trustManagersObj instanceof TrustManager[]) {
            trustManagers = (TrustManager[])trustManagersObj;
        }
        boolean AUTO_CLOSE_TRUE = true;
        TcpipNetAddress tcpidRemoteAddress = null;
        if (remoteAddress != null && remoteAddress instanceof TcpipNetAddress) {
            tcpidRemoteAddress = (TcpipNetAddress)remoteAddress;
        }
        NetSocket higherLayerSocket = TLSNetSocketUtil.createTLSSocket(lowerLayerSocket, tcpidRemoteAddress, true, enabledCipherSuites, keyManagers, trustManagers);
        return higherLayerSocket;
    }

    @Override
    public NetServerSocket createNetServerSocket(Map<String, Object> properties, NetAddress localListenAddress) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NetLayerStatus getStatus() {
        return this.lowerNetLayer.getStatus();
    }

    @Override
    public void waitUntilReady() {
        this.lowerNetLayer.waitUntilReady();
    }

    @Override
    public void clear() throws IOException {
        this.lowerNetLayer.clear();
    }

    @Override
    public NetAddressNameService getNetAddressNameService() {
        return this.lowerNetLayer.getNetAddressNameService();
    }
}

