/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.tcpip;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.UnknownHostException;
import java.util.Map;
import org.silvertunnel_ng.netlib.adapter.socket.ExtendedSocket;
import org.silvertunnel_ng.netlib.adapter.socket.SocketGlobalUtil;
import org.silvertunnel_ng.netlib.api.NetAddress;
import org.silvertunnel_ng.netlib.api.NetAddressNameService;
import org.silvertunnel_ng.netlib.api.NetLayer;
import org.silvertunnel_ng.netlib.api.NetLayerStatus;
import org.silvertunnel_ng.netlib.api.NetServerSocket;
import org.silvertunnel_ng.netlib.api.NetSocket;
import org.silvertunnel_ng.netlib.api.impl.PropertiesUtil;
import org.silvertunnel_ng.netlib.api.impl.ServerSocket2NetServerSocket;
import org.silvertunnel_ng.netlib.api.impl.Socket2NetSocket;
import org.silvertunnel_ng.netlib.api.service.NetlibVersion;
import org.silvertunnel_ng.netlib.api.util.TcpipNetAddress;
import org.silvertunnel_ng.netlib.nameservice.cache.CachingNetAddressNameService;
import org.silvertunnel_ng.netlib.nameservice.inetaddressimpl.DefaultIpNetAddressNameService;

public class TcpipNetLayer
implements NetLayer {
    public static final String BACKLOG = "TcpipNetLayer.backlog";
    public static final String TIMEOUT_IN_MS = "TcpipNetLayer.timeoutInMs";
    private NetAddressNameService netAddressNameService;

    @Override
    public NetSocket createNetSocket(Map<String, Object> localProperties, NetAddress localAddress, NetAddress remoteAddress) throws IOException {
        TcpipNetAddress r = (TcpipNetAddress)remoteAddress;
        boolean TIMEOUT_IN_MS_UNLIMITED = false;
        Integer timeoutInMs = PropertiesUtil.getAsInteger(localProperties, TIMEOUT_IN_MS, 0);
        ExtendedSocket socket = SocketGlobalUtil.createOriginalSocket();
        if (r.getIpaddress() != null) {
            InetAddress remoteInetAddress = InetAddress.getByAddress(r.getIpaddress());
            InetSocketAddress remoteInetSocketAddress = new InetSocketAddress(remoteInetAddress, r.getPort());
            socket.connect(remoteInetSocketAddress, timeoutInMs);
        } else {
            InetSocketAddress remoteInetSocketAddress = new InetSocketAddress(r.getHostname(), r.getPort());
            if (remoteInetSocketAddress.getAddress() == null) {
                throw new UnknownHostException("hostlookup didnt worked. for Hostname : " + r.getHostname());
            }
            socket.connect(remoteInetSocketAddress, timeoutInMs);
        }
        return new Socket2NetSocket(socket);
    }

    public NetSocket createNetSocket(NetAddress localAddress, NetAddress remoteAddress) throws IOException {
        Socket socket;
        TcpipNetAddress r = (TcpipNetAddress)remoteAddress;
        if (r.getIpaddress() != null) {
            InetAddress inetAddress = InetAddress.getByAddress(r.getIpaddress());
            socket = new Socket(inetAddress, r.getPort());
        } else {
            socket = new Socket(r.getHostname(), r.getPort());
        }
        return new Socket2NetSocket(socket);
    }

    @Override
    public NetServerSocket createNetServerSocket(Map<String, Object> properties, NetAddress localListenAddress) throws IOException {
        TcpipNetAddress l = (TcpipNetAddress)localListenAddress;
        Long backlogL = PropertiesUtil.getAsLong(properties, BACKLOG, null);
        int backlog = backlogL == null ? 0 : backlogL.intValue();
        ServerSocket serverSocket = new ServerSocket(l.getPort(), backlog);
        return new ServerSocket2NetServerSocket(serverSocket);
    }

    @Override
    public NetLayerStatus getStatus() {
        return NetLayerStatus.READY;
    }

    @Override
    public void waitUntilReady() {
    }

    @Override
    public void clear() throws IOException {
    }

    @Override
    public NetAddressNameService getNetAddressNameService() {
        if (this.netAddressNameService == null) {
            this.netAddressNameService = new CachingNetAddressNameService(new DefaultIpNetAddressNameService());
        }
        return this.netAddressNameService;
    }

    static {
        NetlibVersion.getInstance();
    }
}

