/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.socks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.silvertunnel_ng.netlib.api.NetAddress;
import org.silvertunnel_ng.netlib.api.NetLayer;
import org.silvertunnel_ng.netlib.api.NetSocket;
import org.silvertunnel_ng.netlib.api.impl.DataNetSocket;
import org.silvertunnel_ng.netlib.api.impl.DataNetSocketPair;
import org.silvertunnel_ng.netlib.api.impl.DataNetSocketUtil;
import org.silvertunnel_ng.netlib.api.impl.DataNetSocketWrapper;
import org.silvertunnel_ng.netlib.api.impl.InterconnectUtil;
import org.silvertunnel_ng.netlib.api.util.TcpipNetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocksServerNetSession
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(SocksServerNetSession.class);
    private final NetLayer lowerNetLayer;
    private DataNetSocket higherLayerSocketExported;
    private DataNetSocket higherLayerSocketInternallyUsed;
    private DataNetSocket lowerLayerSocket;
    private DataInputStream socksIn;
    private DataOutputStream socksOut;
    private DataInputStream lowerIn;
    private DataOutputStream lowerOut;
    static final int BUFFER_SIZE = 498;
    private static long id;

    public SocksServerNetSession(NetLayer lowerNetLayer, Map<String, Object> localProperties, NetAddress localAddress, NetAddress remoteAddress) {
        this.lowerNetLayer = lowerNetLayer;
    }

    public NetSocket createHigherLayerNetSocket() throws IOException {
        if (this.higherLayerSocketExported != null) {
            throw new IllegalStateException("cannot create multiple sockets for one session");
        }
        DataNetSocketPair dataNetSocketPair = DataNetSocketUtil.createDataNetSocketPair();
        this.higherLayerSocketExported = dataNetSocketPair.getSocket();
        this.higherLayerSocketInternallyUsed = dataNetSocketPair.getInvertedSocked();
        this.socksIn = this.higherLayerSocketInternallyUsed.getDataInputStream();
        this.socksOut = this.higherLayerSocketInternallyUsed.getDataOutputStream();
        new Thread((Runnable)this, SocksServerNetSession.createUniqueThreadName()).start();
        return this.higherLayerSocketExported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block7: {
            try {
                byte[] version = new byte[1];
                this.socksIn.read(version, 0, 1);
                if (version[0] == 4) {
                    this.processSocks4Connection();
                    break block7;
                }
                if (version[0] == 5) {
                    this.processSocks5Connection();
                    break block7;
                }
                byte[] answer = new byte[]{0, 91};
                this.socksOut.write(answer);
                this.socksOut.flush();
                throw new Exception("only support for Socks-4(a)/5");
            }
            catch (Exception e) {
                LOG.warn("got Exception", (Throwable)e);
            }
            finally {
                LOG.debug("{} closing down", (Object)id);
            }
        }
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSocks5Connection() {
        LOG.debug("processSocks5Connection(): start");
        byte[] command = new byte[8];
        byte[] answer = new byte[2];
        try {
            int i;
            byte[] address;
            answer[0] = 5;
            this.socksIn.read(command, 0, 1);
            if (command[0] <= 0) {
                answer[1] = -1;
                this.socksOut.write(answer);
                this.socksOut.flush();
                throw new Exception("number of supported methods must be >0");
            }
            byte[] methods = new byte[command[0]];
            this.socksIn.readFully(methods);
            boolean foundAnonymous = false;
            for (int i2 = 0; i2 < methods.length; ++i2) {
                foundAnonymous = foundAnonymous || methods[i2] == 0;
            }
            if (!foundAnonymous) {
                answer[1] = -1;
                this.socksOut.write(answer);
                this.socksOut.flush();
                throw new Exception("no accepted method listed by client");
            }
            answer[1] = 0;
            this.socksOut.write(answer);
            this.socksOut.flush();
            command = new byte[4];
            this.socksIn.readFully(command);
            if (command[0] != 5) {
                throw new Exception("why the f*** does the client change its version number?");
            }
            if (command[1] != 1) {
                throw new Exception("only CONNECT supported");
            }
            if (command[2] != 0) {
                throw new Exception("do not play around with reserved fields");
            }
            if (command[3] != 1 && command[3] != 3) {
                throw new Exception("only IPv4 and HOSTNAME supported");
            }
            String hostname = null;
            if (command[3] == 1) {
                address = new byte[4];
                this.socksIn.readFully(address);
            } else {
                byte[] lenInfo = new byte[1];
                this.socksIn.readFully(lenInfo);
                address = new byte[256 + lenInfo[0] & 0xFF];
                this.socksIn.readFully(address);
                hostname = new String(address);
            }
            byte[] port = new byte[2];
            this.socksIn.readFully(port);
            int intPort = ((port[0] & 0xFF) << 8) + (port[1] & 0xFF);
            TcpipNetAddress remoteAddress = hostname != null ? new TcpipNetAddress(hostname, intPort) : new TcpipNetAddress(address, intPort);
            ArrayList<Byte> answerL = new ArrayList<Byte>();
            answerL.add((byte)5);
            answerL.add((byte)0);
            answerL.add((byte)0);
            answerL.add(command[3]);
            if (hostname != null) {
                answerL.add((byte)address.length);
            }
            for (i = 0; i < address.length; ++i) {
                answerL.add(address[i]);
            }
            answerL.add(port[0]);
            answerL.add(port[1]);
            answer = new byte[answerL.size()];
            for (i = 0; i < answer.length; ++i) {
                answer[i] = (Byte)answerL.get(i);
            }
            this.socksOut.write(answer);
            this.socksOut.flush();
            this.lowerLayerSocket = new DataNetSocketWrapper(this.lowerNetLayer.createNetSocket(null, null, remoteAddress));
            this.lowerIn = this.lowerLayerSocket.getDataInputStream();
            this.lowerOut = this.lowerLayerSocket.getDataOutputStream();
            InterconnectUtil.relay(this.socksIn, this.lowerOut, this.lowerIn, this.socksOut, 498);
            LOG.debug("processSocks5Connection(): end");
        }
        catch (Exception e) {
            LOG.error("unexpected end", (Throwable)e);
        }
    }

    private void processSocks4Connection() {
        throw new UnsupportedOperationException("socks4 is currently not supported");
    }

    protected static synchronized String createUniqueThreadName() {
        return SocksServerNetSession.class.getName() + ++id + "-" + Thread.currentThread().getName();
    }
}

