/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.redirect;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.silvertunnel_ng.netlib.api.NetSocket;
import org.silvertunnel_ng.netlib.layer.redirect.SwitchingNetLayer;

public class SwitchingNetSocket
implements NetSocket {
    private final SwitchingNetLayer switchingNetLayer;
    private final NetSocket lowerNetSocket;
    private boolean closed = false;

    protected SwitchingNetSocket(SwitchingNetLayer switchingNetLayer, NetSocket lowerNetSocket) {
        this.switchingNetLayer = switchingNetLayer;
        this.lowerNetSocket = lowerNetSocket;
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        if (!this.closed) {
            return this.lowerNetSocket.getInputStream();
        }
        throw new IOException("getInputStream(): SwitchingNetSocket already closed");
    }

    @Override
    public synchronized OutputStream getOutputStream() throws IOException {
        if (!this.closed) {
            return this.lowerNetSocket.getOutputStream();
        }
        throw new IOException("getOutputStream(): SwitchingNetSocket already closed");
    }

    @Override
    public synchronized void close() throws IOException {
        this.switchingNetLayer.removeFromLayer(this);
        this.closeLowerLayer();
    }

    public String toString() {
        return "SwitchingNetSocket(" + this.lowerNetSocket + ")";
    }

    protected synchronized void closeLowerLayer() throws IOException {
        this.closed = true;
        this.lowerNetSocket.close();
    }
}

