/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.redirect;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.silvertunnel_ng.netlib.api.NetAddress;
import org.silvertunnel_ng.netlib.api.NetAddressNameService;
import org.silvertunnel_ng.netlib.api.NetLayer;
import org.silvertunnel_ng.netlib.api.NetLayerStatus;
import org.silvertunnel_ng.netlib.api.NetServerSocket;
import org.silvertunnel_ng.netlib.api.NetSocket;
import org.silvertunnel_ng.netlib.layer.redirect.SwitchingNetServerSocket;
import org.silvertunnel_ng.netlib.layer.redirect.SwitchingNetSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchingNetLayer
implements NetLayer {
    private static final Logger LOG = LoggerFactory.getLogger(SwitchingNetLayer.class);
    private static int OPEN_SOCKETS_WARN_THRESHOLD = 100;
    private volatile NetLayer lowerNetLayer;
    private final Collection<SwitchingNetSocket> switchingNetSockets = new ArrayList<SwitchingNetSocket>();
    private final Collection<SwitchingNetServerSocket> switchingNetServerSockets = new ArrayList<SwitchingNetServerSocket>();

    public SwitchingNetLayer(NetLayer lowerNetLayer) {
        this.lowerNetLayer = lowerNetLayer;
    }

    public synchronized void setLowerNetLayer(NetLayer lowerNetLayer, boolean closeAllOpenConnectionsImmediately) {
        for (SwitchingNetServerSocket serverSocket : this.switchingNetServerSockets) {
            try {
                serverSocket.closeLowerLayer();
            }
            catch (Exception e) {
                LOG.info("setLowerNetLayer(): exception while closing lower server socket: " + e);
            }
        }
        this.switchingNetServerSockets.clear();
        if (closeAllOpenConnectionsImmediately) {
            for (SwitchingNetSocket socket : this.switchingNetSockets) {
                try {
                    socket.closeLowerLayer();
                }
                catch (Exception e) {
                    LOG.info("setLowerNetLayer(): exception while closing lower socket: " + e);
                }
            }
        }
        this.switchingNetSockets.clear();
        this.lowerNetLayer = lowerNetLayer;
    }

    @Override
    public NetSocket createNetSocket(Map<String, Object> localProperties, NetAddress localAddress, NetAddress remoteAddress) throws IOException {
        SwitchingNetSocket result = new SwitchingNetSocket(this, this.lowerNetLayer.createNetSocket(localProperties, localAddress, remoteAddress));
        this.addToLayer(result);
        return result;
    }

    @Override
    public NetServerSocket createNetServerSocket(Map<String, Object> properties, NetAddress localListenAddress) throws IOException {
        SwitchingNetServerSocket result = new SwitchingNetServerSocket(this, this.lowerNetLayer.createNetServerSocket(properties, localListenAddress));
        this.addToLayer(result);
        return result;
    }

    @Override
    public NetLayerStatus getStatus() {
        return this.lowerNetLayer.getStatus();
    }

    @Override
    public void waitUntilReady() {
        this.lowerNetLayer.waitUntilReady();
    }

    @Override
    public void clear() throws IOException {
        this.lowerNetLayer.clear();
    }

    @Override
    public NetAddressNameService getNetAddressNameService() {
        return this.lowerNetLayer.getNetAddressNameService();
    }

    protected synchronized void addToLayer(SwitchingNetSocket switchingNetSocket) {
        this.switchingNetSockets.add(switchingNetSocket);
        if (this.switchingNetSockets.size() >= OPEN_SOCKETS_WARN_THRESHOLD) {
            String msg = "SwitchingNetLayer: " + this.switchingNetSockets.size() + " open sockets - this could be a resource and memory leak";
            if (this.switchingNetSockets.size() == OPEN_SOCKETS_WARN_THRESHOLD) {
                LOG.warn(msg, new Throwable("use thread dump to localize potential resource and memory leak"));
            } else {
                LOG.warn(msg);
            }
        }
    }

    private synchronized void addToLayer(SwitchingNetServerSocket switchingNetServerSocket) {
        this.switchingNetServerSockets.add(switchingNetServerSocket);
        if (this.switchingNetServerSockets.size() >= OPEN_SOCKETS_WARN_THRESHOLD) {
            String msg = "SwitchingNetLayer: " + this.switchingNetServerSockets.size() + " open server sockets - this could be a resource and memory leak";
            if (this.switchingNetServerSockets.size() == OPEN_SOCKETS_WARN_THRESHOLD) {
                LOG.warn(msg, new Throwable("use thread dump to localize potential resource and memory leak"));
            } else {
                LOG.warn(msg);
            }
        }
    }

    protected synchronized void removeFromLayer(SwitchingNetSocket switchingNetSocket) {
        this.switchingNetSockets.remove(switchingNetSocket);
    }

    protected synchronized void removeFromLayer(SwitchingNetServerSocket switchingNetServerSocket) {
        this.switchingNetServerSockets.remove(switchingNetServerSocket);
    }
}

