/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.redirect;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.silvertunnel_ng.netlib.api.NetAddress;
import org.silvertunnel_ng.netlib.api.NetAddressNameService;
import org.silvertunnel_ng.netlib.api.NetLayer;
import org.silvertunnel_ng.netlib.api.NetLayerStatus;
import org.silvertunnel_ng.netlib.api.NetServerSocket;
import org.silvertunnel_ng.netlib.api.NetSocket;
import org.silvertunnel_ng.netlib.api.util.IpNetAddress;
import org.silvertunnel_ng.netlib.api.util.TcpipNetAddress;
import org.silvertunnel_ng.netlib.layer.redirect.Condition;
import org.silvertunnel_ng.netlib.layer.redirect.ConditionalNetAddressNameService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionalNetLayer
implements NetLayer {
    private static final Logger LOG = LoggerFactory.getLogger(ConditionalNetLayer.class);
    private List<Condition> conditions = new ArrayList<Condition>();
    private final NetLayer defaultLowerNetLayer;

    public ConditionalNetLayer(List<Condition> conditions, NetLayer defaultLowerNetLayer) {
        this.conditions = Collections.synchronizedList(conditions);
        this.defaultLowerNetLayer = defaultLowerNetLayer;
    }

    protected NetLayer getMatchingNetLayer(NetAddress netAddress) {
        NetLayer result = this.getMatchingNetLayerOrNull(netAddress);
        if (result == null) {
            result = this.defaultLowerNetLayer;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("netAddress={} matches with lowerNetLayer={}", (Object)netAddress, (Object)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetLayer getMatchingNetLayerOrNull(NetAddress netAddress) {
        List<Condition> list = this.conditions;
        synchronized (list) {
            if (netAddress == null) {
                return this.defaultLowerNetLayer;
            }
            if (netAddress instanceof TcpipNetAddress) {
                TcpipNetAddress tcpipNetAddress = (TcpipNetAddress)netAddress;
                String s = tcpipNetAddress.getHostnameAndPort();
                NetLayer result = this.getMatchingNetLayerOrNull(s);
                if (result != null) {
                    return result;
                }
                s = tcpipNetAddress.getIpaddressAndPort();
                result = this.getMatchingNetLayerOrNull(s);
                if (result != null) {
                    return result;
                }
            } else if (netAddress instanceof IpNetAddress) {
                IpNetAddress ipNetAddress = (IpNetAddress)netAddress;
                String s = ipNetAddress.getIpaddressAsString();
                NetLayer result = this.getMatchingNetLayerOrNull(s);
                if (result != null) {
                    return result;
                }
            } else {
                String s = netAddress.toString();
                NetLayer result = this.getMatchingNetLayerOrNull(s);
                if (result != null) {
                    return result;
                }
            }
        }
        return this.defaultLowerNetLayer;
    }

    protected NetLayer getMatchingNetLayer(String addressName) {
        NetLayer result = this.getMatchingNetLayerOrNull(addressName);
        if (result == null) {
            result = this.defaultLowerNetLayer;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("addressName={} matches with lowerNetLayer={}", (Object)addressName, (Object)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetLayer getMatchingNetLayerOrNull(String s) {
        List<Condition> list = this.conditions;
        synchronized (list) {
            for (Condition condition : this.conditions) {
                if (!condition.getPattern().matcher(s).matches()) continue;
                return condition.getNetLayer();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<NetLayer> getAllLowerNetLayers() {
        HashSet<NetLayer> result = new HashSet<NetLayer>(this.conditions.size() + 1);
        List<Condition> list = this.conditions;
        synchronized (list) {
            for (Condition condition : this.conditions) {
                result.add(condition.getNetLayer());
            }
        }
        result.add(this.defaultLowerNetLayer);
        return result;
    }

    @Override
    public NetSocket createNetSocket(Map<String, Object> localProperties, NetAddress localAddress, NetAddress remoteAddress) throws IOException {
        NetLayer lowerNetLayer = this.getMatchingNetLayer(remoteAddress);
        return lowerNetLayer.createNetSocket(localProperties, localAddress, remoteAddress);
    }

    @Override
    public NetServerSocket createNetServerSocket(Map<String, Object> properties, NetAddress localListenAddress) throws IOException {
        NetLayer lowerNetLayer = this.getMatchingNetLayer(localListenAddress);
        return lowerNetLayer.createNetServerSocket(properties, localListenAddress);
    }

    @Override
    public NetLayerStatus getStatus() {
        ArrayList<NetLayerStatus> statuses = new ArrayList<NetLayerStatus>();
        for (NetLayer lowerNetLayer : this.getAllLowerNetLayers()) {
            statuses.add(lowerNetLayer.getStatus());
        }
        return (NetLayerStatus)Collections.max(statuses);
    }

    @Override
    public void waitUntilReady() {
        for (NetLayer lowerNetLayer : this.getAllLowerNetLayers()) {
            lowerNetLayer.waitUntilReady();
        }
    }

    @Override
    public void clear() throws IOException {
        for (NetLayer lowerNetLayer : this.getAllLowerNetLayers()) {
            lowerNetLayer.clear();
        }
    }

    @Override
    public NetAddressNameService getNetAddressNameService() {
        return new ConditionalNetAddressNameService(this);
    }
}

