/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.mock;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.silvertunnel_ng.netlib.api.NetSocket;
import org.silvertunnel_ng.netlib.layer.mock.MockByteArrayInputStream;

public class MockNetSocket
implements NetSocket {
    private final ByteArrayInputStream in;
    private final ByteArrayOutputStream out;

    public MockNetSocket(byte[] response, long waitAtEndOfResponseBeforeClosingMs) {
        this.in = new MockByteArrayInputStream(response, waitAtEndOfResponseBeforeClosingMs);
        this.out = new ByteArrayOutputStream();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.out.close();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.in;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.out;
    }

    public ByteArrayInputStream getByteArrayInputStream() throws IOException {
        return this.in;
    }

    public ByteArrayOutputStream getByteArrayOutputStream() throws IOException {
        return this.out;
    }
}

