/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.mock;

import java.io.IOException;
import java.util.Map;
import org.silvertunnel_ng.netlib.api.NetAddress;
import org.silvertunnel_ng.netlib.api.NetSocket;
import org.silvertunnel_ng.netlib.layer.mock.MockNetSocket;

public class MockNetSession {
    private final Map<String, Object> providedLocalProperties;
    private final NetAddress providedRemoteAddress;
    private final MockNetSocket preparedHigherLayerSocket;
    private boolean isHigherLayerSocketCreated = false;

    public MockNetSession(Map<String, Object> localProperties, NetAddress localAddress, NetAddress remoteAddress, MockNetSocket preparedHigherLayerSocket) {
        this.providedLocalProperties = localProperties;
        this.providedRemoteAddress = remoteAddress;
        this.preparedHigherLayerSocket = preparedHigherLayerSocket;
    }

    public NetSocket createHigherLayerNetSocket() throws IOException {
        if (this.isHigherLayerSocketCreated) {
            throw new IllegalStateException("cannot create multiple sockets for one session");
        }
        this.isHigherLayerSocketCreated = true;
        return this.preparedHigherLayerSocket;
    }

    public MockNetSocket getHigherLayerNetSocket() {
        if (this.isHigherLayerSocketCreated) {
            return this.preparedHigherLayerSocket;
        }
        return null;
    }

    public Map<String, Object> getProvidedLocalProperties() {
        return this.providedLocalProperties;
    }

    public NetAddress getProvidedRemoteAddress() {
        return this.providedRemoteAddress;
    }
}

